/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.bean;

import com.clustercontrol.collectiverun.bean.ItemInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TreeItem
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8195124905953255470L;
    protected TreeItem parent = null;
    protected ItemInfo info = null;
    protected List<TreeItem> children = null;

    public TreeItem(TreeItem parent, ItemInfo info) {
        this.setParent(parent);
        this.setInfo(info);
        if (parent != null) {
            parent.addChildren(this);
        }
        this.children = new ArrayList<TreeItem>();
    }

    public TreeItem getParent() {
        return this.parent;
    }

    public void setParent(TreeItem parent) {
        this.parent = parent;
    }

    public ItemInfo getInfo() {
        return this.info;
    }

    public void setInfo(ItemInfo info) {
        this.info = info;
    }

    public void addChildren(TreeItem child) {
        child.setParent(this);
        this.children.add(child);
    }

    public void removeChildren(TreeItem child) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (!child.equals(this.children.get(i))) continue;
            this.children.remove(i);
            break;
        }
    }

    public int size() {
        return this.children.size();
    }

    public TreeItem[] getChildren() {
        TreeItem[] result = new TreeItem[this.size()];
        return this.children.toArray(result);
    }

    public Object clone() {
        TreeItem clone;
        ItemInfo cloneInfo = (ItemInfo)this.getInfo().clone();
        if (cloneInfo == null) {
            return null;
        }
        try {
            clone = (TreeItem)super.clone();
            clone.setParent(null);
            clone.setInfo(cloneInfo);
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return clone;
    }
}

