/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.action;

import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.util.OutputFormat;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import com.clustercontrol.performanceMGR.bean.CollectedDataSet;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.CollectorProperty;
import com.clustercontrol.performanceMGR.ejb.bmp.RecordCollectorData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class RecordDataWriter
implements Runnable {
    private CollectorProperty property;
    private String facilityID;
    private boolean headerFlag;
    private File file;
    private FileOutputStream fos;
    private OutputStreamWriter osw;
    private BufferedWriter bw;
    private Date lastDate = null;
    private int getSize = 100;
    private long collectStartTime;
    private long collectStopTime;
    private int progress;
    private boolean canceled;

    public RecordDataWriter(String filename, CollectorProperty property, String facilityID, boolean headerFlag) {
        this.file = new File(filename);
        this.property = property;
        this.facilityID = facilityID;
        this.headerFlag = headerFlag;
    }

    public boolean createNewFile() throws IOException {
        return this.file.createNewFile();
    }

    public void run() {
        try {
            this.write(this.property, this.facilityID, this.headerFlag);
        }
        catch (IOException iOException) {}
    }

    public int getProgress() {
        return this.progress;
    }

    private void openFile() throws FileNotFoundException {
        this.fos = new FileOutputStream(this.file);
        this.osw = new OutputStreamWriter(this.fos);
        this.bw = new BufferedWriter(this.osw);
    }

    private void closeFile() throws IOException {
        this.bw.close();
        this.osw.close();
        this.fos.close();
    }

    public void write(CollectorProperty property, String facilityID, boolean headerFlag) throws IOException {
        try {
            this.openFile();
            if (headerFlag) {
                this.writeHeader(property.getCollectorData(), facilityID);
            }
            RecordCollectorData collectorData = property.getCollectorData();
            ArrayList itemList = property.getItemList();
            int[] itemIDs = new int[itemList.size()];
            int i = 0;
            while (i < itemIDs.length) {
                itemIDs[i] = ((CollectorItemInfo)itemList.get(i)).getCollectorItemID();
                ++i;
            }
            Arrays.sort(itemIDs);
            String[] facilityIDs = new String[]{facilityID};
            this.collectStartTime = collectorData.getStartDate().getTime();
            this.collectStopTime = collectorData.getStopDate().getTime();
            int interval = collectorData.getInterval();
            int timeBlock = interval * 1000 * this.getSize;
            long overlap = interval * 3 * 1000;
            long stratTime = this.collectStartTime;
            long endTime = 0L;
            int loopMax = (int)(this.collectStopTime - this.collectStartTime) / timeBlock + 1;
            int loopCount = 0;
            while (!this.canceled && stratTime < this.collectStopTime) {
                endTime = stratTime + (long)timeBlock;
                Date startDate = new Date(stratTime - overlap);
                Date endDate = new Date(endTime);
                RecordController controller = RecordController.getInstance();
                if (controller == null) {
                    throw new RemoteException("Can't connect to manager.");
                }
                CollectedDataSet dataSetBuffer = new CollectedDataSet();
                int i2 = 0;
                while (i2 < itemIDs.length) {
                    int[] itemIDBuffer = new int[]{itemIDs[i2]};
                    CollectedDataSet dataSet = controller.getRecordCollectedData(collectorData.getCollectorID(), facilityIDs, itemIDBuffer, startDate, endDate);
                    if (dataSet == null) {
                        throw new RemoteException("Get performance data failed.");
                    }
                    dataSetBuffer.addCollectedDataList(dataSet);
                    this.progress = (int)(((double)loopCount + (double)i2 / (double)itemIDs.length) / (double)loopMax * 100.0);
                    ++i2;
                }
                this.white(facilityID, property.getItemList(), itemIDs, dataSetBuffer);
                stratTime = endTime;
                ++loopCount;
            }
            this.progress = 100;
        }
        finally {
            this.closeFile();
        }
    }

    private void writeHeader(RecordCollectorData profile, String facilityID) throws IOException {
        this.bw.write(String.valueOf(Messages.getString("EXPORT_HEADER_COLLECTORID")) + ", " + profile.getCollectorID());
        this.bw.newLine();
        this.bw.write(String.valueOf(Messages.getString("EXPORT_HEADER_LABEL")) + ", " + profile.getLabel());
        this.bw.newLine();
        this.bw.write(String.valueOf(Messages.getString("EXPORT_HEADER_FACILITY")) + ", " + facilityID);
        this.bw.newLine();
        this.bw.write(String.valueOf(Messages.getString("EXPORT_HEADER_STARTDATE")) + ", " + OutputFormat.dateToString(profile.getStartDate()));
        this.bw.newLine();
        this.bw.newLine();
    }

    private void white(String facilityID, List itemInfoList, int[] targetItemIDs, CollectedDataSet dataSet) throws IOException {
        List[] collectedDataListArray;
        int i;
        if (this.lastDate == null) {
            String msg = Messages.getString("EXPORT_COLUMN_TIME");
            int j = 0;
            while (j < targetItemIDs.length) {
                i = 0;
                while (i < itemInfoList.size()) {
                    CollectorItemInfo itemInfo = (CollectorItemInfo)itemInfoList.get(i);
                    if (itemInfo.getCollectorItemID() == targetItemIDs[j]) {
                        String itemName = CollectorItemCodeFactory.getFullItemName(itemInfo.getCollectorItemCode(), itemInfo.getDeviceName());
                        msg = String.valueOf(msg) + ", " + itemName;
                        i = itemInfoList.size();
                    }
                    ++i;
                }
                ++j;
            }
            this.bw.write(msg);
            this.bw.newLine();
        }
        if ((collectedDataListArray = new List[dataSet.getDataListNum(facilityID)]).length != targetItemIDs.length) {
            this.bw.write(Messages.getString("INVALID_DATA_IN_DB"));
            this.bw.newLine();
            return;
        }
        int i2 = 0;
        while (i2 < targetItemIDs.length) {
            collectedDataListArray[i2] = dataSet.getCollectedDataList(facilityID, targetItemIDs[i2]);
            ++i2;
        }
        int timeSize = collectedDataListArray[0].size();
        i = 1;
        while (i < targetItemIDs.length) {
            if (timeSize != collectedDataListArray[i].size()) {
                this.bw.write(Messages.getString("INVALID_DATA_IN_DB"));
                this.bw.newLine();
                return;
            }
            ++i;
        }
        CollectedDataInfo data = null;
        int t = 0;
        while (t < timeSize) {
            CollectedDataInfo firstData = (CollectedDataInfo)collectedDataListArray[0].get(t);
            if (this.lastDate == null || firstData.getDate().getTime() > this.lastDate.getTime()) {
                String msg = null;
                int i3 = 0;
                while (i3 < targetItemIDs.length) {
                    data = (CollectedDataInfo)collectedDataListArray[i3].get(t);
                    msg = i3 == 0 ? String.valueOf(OutputFormat.dateToString(data.getDate())) + ", " + OutputFormat.doubleToString(data.getValue()) : String.valueOf(msg) + ", " + OutputFormat.doubleToString(data.getValue());
                    ++i3;
                }
                this.bw.write(msg);
                this.bw.newLine();
            }
            ++t;
        }
        if (data != null) {
            this.lastDate = data.getDate();
        }
    }

    public void setCanceled(boolean b) {
        this.canceled = b;
    }
}

