/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.components.framework;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.ui.internal.components.ComponentMessages;
import org.eclipse.ui.internal.components.ComponentUtil;
import org.eclipse.ui.internal.components.framework.ClassIdentifier;
import org.eclipse.ui.internal.components.framework.ComponentException;
import org.eclipse.ui.internal.components.framework.ComponentFactory;
import org.eclipse.ui.internal.components.framework.ComponentHandle;
import org.eclipse.ui.internal.components.framework.Components;
import org.eclipse.ui.internal.components.framework.IServiceProvider;

public class ReflectionFactory
extends ComponentFactory
implements IExecutableExtension {
    private ClassIdentifier classId = null;
    private Class targetClass = null;

    public ReflectionFactory() {
    }

    public ReflectionFactory(Class toCreateByReflection) {
        this.targetClass = toCreateByReflection;
    }

    public ReflectionFactory(ClassIdentifier classId) {
        this.classId = classId;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.classId = ComponentUtil.getClassFromInitializationData(config, data);
    }

    public ComponentHandle createHandle(IServiceProvider availableServices) throws ComponentException {
        Class targetClass = this.targetClass;
        if (targetClass == null) {
            targetClass = ComponentUtil.loadClass(this.classId);
        }
        Constructor targetConstructor = null;
        Constructor<?>[] constructors = targetClass.getConstructors();
        if (constructors.length == 1) {
            targetConstructor = constructors[0];
        } else {
            ArrayList toSort = new ArrayList();
            int i = 0;
            while (i < constructors.length) {
                Constructor<?> constructor = constructors[i];
                if ((constructor.getModifiers() & 1) != 0) {
                    toSort.add(constructor);
                }
                ++i;
            }
            Collections.sort(toSort, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    Constructor c1 = (Constructor)arg0;
                    Constructor c2 = (Constructor)arg1;
                    int l1 = c1.getParameterTypes().length;
                    int l2 = c2.getParameterTypes().length;
                    return l1 - l2;
                }
            });
            Iterator iter = toSort.iterator();
            while (iter.hasNext() && targetConstructor == null) {
                Constructor next = (Constructor)iter.next();
                boolean satisfiable = true;
                Class<?>[] params = next.getParameterTypes();
                int i2 = 0;
                while (i2 < params.length && satisfiable) {
                    Class<?> clazz = params[i2];
                    if (!availableServices.hasService(clazz)) {
                        satisfiable = false;
                    }
                    ++i2;
                }
                if (!satisfiable) continue;
                targetConstructor = next;
            }
        }
        if (targetConstructor == null) {
            throw new ComponentException(targetClass, ComponentMessages.ReflectionFactory_no_constructors, null);
        }
        Object[] paramKeys = targetConstructor.getParameterTypes();
        try {
            Object[] params = Components.queryInterfaces(availableServices, paramKeys);
            return new ComponentHandle(targetConstructor.newInstance(params));
        }
        catch (Exception e) {
            throw new ComponentException(targetClass, (Throwable)e);
        }
    }
}

