/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.properties;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IResourcePropertyConstants;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.ResourcePropertySource;

public class FilePropertySource
extends ResourcePropertySource {
    private static PropertyDescriptor fileDescriptor = new PropertyDescriptor((Object)"org.eclipse.ui.size", IResourcePropertyConstants.P_DISPLAY_SIZE);

    static {
        fileDescriptor.setAlwaysIncompatible(true);
        fileDescriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
    }

    public FilePropertySource(IFile file) {
        super((IResource)file);
    }

    private static PropertyDescriptor getInitialPropertyDescriptor() {
        return fileDescriptor;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] superDescriptors = super.getPropertyDescriptors();
        int superLength = superDescriptors.length;
        IPropertyDescriptor[] fileDescriptors = new IPropertyDescriptor[superLength + 1];
        System.arraycopy(superDescriptors, 0, fileDescriptors, 0, superLength);
        fileDescriptors[superLength] = FilePropertySource.getInitialPropertyDescriptor();
        return fileDescriptors;
    }

    public Object getPropertyValue(Object key) {
        Object returnValue = super.getPropertyValue(key);
        if (returnValue != null) {
            return returnValue;
        }
        if (key.equals("org.eclipse.ui.size")) {
            return this.getSizeString((IFile)this.element);
        }
        return null;
    }

    private String getSizeString(IFile file) {
        if (!file.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        IPath location = file.getLocation();
        if (location == null) {
            if (file.isLinked()) {
                return UNDEFINED_PATH_VARIABLE;
            }
            return FILE_NOT_FOUND;
        }
        File localFile = location.toFile();
        if (localFile.exists()) {
            return Long.toString(localFile.length());
        }
        return FILE_NOT_FOUND;
    }
}

