/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.factory;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.jobmanagement.bean.JobCommandInfo;
import com.clustercontrol.jobmanagement.bean.JobEndStatusInfo;
import com.clustercontrol.jobmanagement.bean.JobFileInfo;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobNotificationsInfo;
import com.clustercontrol.jobmanagement.bean.JobObjectInfo;
import com.clustercontrol.jobmanagement.bean.JobParameterInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeMasterLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.sql.SQLException;
import java.sql.Time;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectJob {
    public static final String SEPARATOR = ">";
    protected static Log m_log = LogFactory.getLog(SelectJob.class);
    private static final int MAX_DISPLAY_NUMBER = 500;
    private static Boolean m_openForwardFileJob = null;
    private RepositoryControllerLocal repository = null;

    public SelectJob() {
        if (m_openForwardFileJob == null) {
            try {
                Properties properties = new Properties();
                String homedir = System.getProperty("jboss.server.home.dir");
                String propertyFile = homedir + File.separator + "conf" + File.separator + "jobmanagement.properties";
                properties.load(new FileInputStream(propertyFile));
                String mode = properties.getProperty("open.forward.file.job", "false");
                m_openForwardFileJob = mode.equalsIgnoreCase("true") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            catch (Exception e) {
                m_log.error((Object)("SelectJob():" + e.getMessage()));
                m_openForwardFileJob = false;
            }
        }
    }

    public JobTreeItem getJobTree(boolean treeOnly, Locale locale) throws FinderException, NamingException {
        JobInfo info = new JobInfo("", "", -1);
        JobTreeItem tree = new JobTreeItem(null, info);
        info = new JobInfo("", Messages.getString((String)"job", (Locale)locale), -1);
        JobTreeItem item = new JobTreeItem(tree, info);
        Collection ct = JobRelationMasterUtil.getLocalHome().findByParentJobId("TOP");
        for (JobRelationMasterLocal children : ct) {
            JobMasterLocal childJob = children.getJobMaster();
            this.createJobTree(childJob, item, treeOnly);
        }
        return tree;
    }

    protected void createJobTree(JobMasterLocal job, JobTreeItem parent, boolean treeOnly) throws FinderException, NamingException {
        JobInfo info = this.createJobData(job, treeOnly);
        JobTreeItem item = new JobTreeItem(parent, info);
        Collection collection = null;
        try {
            collection = JobRelationMasterUtil.getLocalHome().findByParentJobId(job.getJob_id());
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        if (collection != null && collection.size() > 0) {
            for (JobRelationMasterLocal children : collection) {
                JobMasterLocal childJob = children.getJobMaster();
                this.createJobTree(childJob, item, treeOnly);
            }
        }
    }

    protected JobInfo createJobData(JobMasterLocal job, boolean treeOnly) throws FinderException, NamingException {
        JobInfo info = new JobInfo(job.getJob_id(), job.getJob_name(), job.getJob_type());
        if (treeOnly) {
            return info;
        }
        info.setDescription(job.getDescription());
        info.setCreateTime(job.getReg_date());
        info.setUpdateTime(job.getUpdate_date());
        info.setCreateUser(job.getReg_user());
        info.setUpdateUser(job.getUpdate_user());
        JobWaitRuleInfo waitRule = null;
        JobStartMasterLocal start = job.getJobStartMaster();
        if (start != null) {
            JobStartTimeMasterLocal startTime;
            waitRule = new JobWaitRuleInfo();
            waitRule.setSuspend(start.getSuspend());
            waitRule.setCondition(start.getCondition_type());
            waitRule.setEndCondition(start.getUnmatch_end_flg());
            waitRule.setEndStatus(start.getUnmatch_end_status());
            waitRule.setEndValue(start.getUnmatch_end_value());
            waitRule.setSkip(start.getSkip());
            waitRule.setSkipEndStatus(start.getSkip_end_status());
            waitRule.setSkipEndValue(start.getSkip_end_value());
            waitRule.setCalendar(start.getCalendar());
            waitRule.setCalendarId(start.getCalendar_id());
            waitRule.setCalendarEndValue(start.getCalendar_end_value());
            waitRule.setStart_delay(start.getStart_delay());
            waitRule.setStart_delay_session(start.getStart_delay_session());
            waitRule.setStart_delay_session_value(start.getStart_delay_session_value());
            waitRule.setStart_delay_time(start.getStart_delay_time());
            if (start.getStart_delay_time_value() instanceof Time) {
                waitRule.setStart_delay_time_value(new Date(start.getStart_delay_time_value().getTime()));
            }
            waitRule.setStart_delay_condition_type(start.getStart_delay_condition_type());
            waitRule.setStart_delay_notify(start.getStart_delay_notify());
            waitRule.setStart_delay_notify_priority(start.getStart_delay_notify_priority());
            waitRule.setStart_delay_operation(start.getStart_delay_operation());
            waitRule.setStart_delay_operation_type(start.getStart_delay_operation_type());
            waitRule.setStart_delay_operation_end_value(start.getStart_delay_operation_end_value());
            waitRule.setEnd_delay(start.getEnd_delay());
            waitRule.setEnd_delay_session(start.getEnd_delay_session());
            waitRule.setEnd_delay_session_value(start.getEnd_delay_session_value());
            waitRule.setEnd_delay_job(start.getEnd_delay_job());
            waitRule.setEnd_delay_job_value(start.getEnd_delay_job_value());
            waitRule.setEnd_delay_time(start.getEnd_delay_time());
            if (start.getEnd_delay_time_value() instanceof Time) {
                waitRule.setEnd_delay_time_value(new Date(start.getEnd_delay_time_value().getTime()));
            }
            waitRule.setEnd_delay_condition_type(start.getEnd_delay_condition_type());
            waitRule.setEnd_delay_notify(start.getEnd_delay_notify());
            waitRule.setEnd_delay_notify_priority(start.getEnd_delay_notify_priority());
            waitRule.setEnd_delay_operation(start.getEnd_delay_operation());
            waitRule.setEnd_delay_operation_type(start.getEnd_delay_operation_type());
            waitRule.setEnd_delay_operation_end_value(start.getEnd_delay_operation_end_value());
            Collection startJobList = start.getJobStartJobMaster();
            ArrayList<JobObjectInfo> objectList = new ArrayList<JobObjectInfo>();
            if (startJobList != null && startJobList.size() > 0) {
                for (JobStartJobMasterLocal startJob : startJobList) {
                    if (startJob == null) continue;
                    JobObjectInfo objectInfo = new JobObjectInfo();
                    objectInfo.setJobId(startJob.getTarget_job_id());
                    try {
                        JobMasterLocal targetJob = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(startJob.getTarget_job_id()));
                        objectInfo.setJobName(targetJob.getJob_name());
                        objectInfo.setType(startJob.getTarget_job_type());
                        objectInfo.setValue(startJob.getTarget_job_end_value());
                        objectList.add(objectInfo);
                    }
                    catch (FinderException e) {
                        throw e;
                    }
                    catch (NamingException e) {
                        throw e;
                    }
                }
            }
            if ((startTime = start.getJobStartTimeMaster()) != null) {
                JobObjectInfo objectInfo = new JobObjectInfo();
                objectInfo.setType(2);
                objectInfo.setTime(new Date(startTime.getStart_time().getTime()));
                objectList.add(objectInfo);
            }
            waitRule.setObject(objectList);
            info.setWaitRule(waitRule);
        }
        JobCommandInfo commandInfo = null;
        JobCommandMasterLocal command = job.getJobCommandMaster();
        if (command != null) {
            commandInfo = new JobCommandInfo();
            commandInfo.setFacilityID(command.getFacility_id());
            commandInfo.setProcessingMethod(command.getProcess_mode());
            commandInfo.setStartCommand(command.getStart_command());
            commandInfo.setStopCommand(command.getStop_command());
            commandInfo.setUser(command.getEffective_user());
            commandInfo.setErrorEndFlg(command.getError_end_flg());
            commandInfo.setErrorEndValue(command.getError_end_value());
            try {
                if (this.repository == null) {
                    this.repository = RepositoryControllerUtil.getLocalHome().create();
                }
                commandInfo.setScope(this.repository.getFacilityPath(command.getFacility_id(), null));
            }
            catch (CreateException e) {
            }
            catch (NamingException e) {
            }
            catch (FinderException e) {
                // empty catch block
            }
            info.setCommand(commandInfo);
        }
        JobFileInfo fileInfo = null;
        JobFileMasterLocal file = job.getJobFileMaster();
        if (file != null) {
            fileInfo = new JobFileInfo();
            fileInfo.setProcessingMethod(file.getProcess_mode());
            fileInfo.setSrcFacilityID(file.getSrc_facility_id());
            fileInfo.setDestFacilityID(file.getDest_facility_id());
            fileInfo.setSrcFile(file.getSrc_file());
            fileInfo.setSrcWorkDir(file.getSrc_work_dir());
            fileInfo.setDestDirectory(file.getDest_directory());
            fileInfo.setDestWorkDir(file.getDest_work_dir());
            fileInfo.setCompressionFlg(file.getCompression_flg());
            fileInfo.setCheckFlg(file.getCheck_flg());
            fileInfo.setUser(file.getEffective_user());
            try {
                if (this.repository == null) {
                    this.repository = RepositoryControllerUtil.getLocalHome().create();
                }
                fileInfo.setSrcScope(this.repository.getFacilityPath(file.getSrc_facility_id(), null));
                fileInfo.setDestScope(this.repository.getFacilityPath(file.getDest_facility_id(), null));
            }
            catch (CreateException e) {
            }
            catch (NamingException e) {
            }
            catch (FinderException e) {
                // empty catch block
            }
            info.setFile(fileInfo);
        }
        ArrayList<JobNotificationsInfo> noticeList = new ArrayList<JobNotificationsInfo>();
        Collection notices = job.getJobNoticeMaster();
        if (notices != null) {
            for (JobNoticeMasterLocal notice : notices) {
                JobNotificationsInfo notificationsInfo = new JobNotificationsInfo();
                notificationsInfo.setType(notice.getNotice_type());
                notificationsInfo.setPriority(notice.getPriority());
                notificationsInfo.setNotify_id(notice.getNotify_id());
                noticeList.add(notificationsInfo);
            }
            info.setNotifications(noticeList);
        }
        ArrayList<JobEndStatusInfo> endList = new ArrayList<JobEndStatusInfo>();
        Collection ends = job.getJobEndMaster();
        if (ends != null) {
            for (JobEndMasterLocal end : ends) {
                JobEndStatusInfo endInfo = new JobEndStatusInfo();
                endInfo.setType(end.getEnd_status());
                endInfo.setValue(end.getEnd_value());
                endInfo.setStartRangeValue(end.getEnd_value_from());
                endInfo.setEndRangeValue(end.getEnd_value_to());
                endList.add(endInfo);
            }
            info.setEndStatus(endList);
        }
        ArrayList<JobParameterInfo> paramList = new ArrayList<JobParameterInfo>();
        Collection params = job.getJobParamMaster();
        if (params != null) {
            for (JobParamMasterLocal param : params) {
                JobParameterInfo paramInfo = new JobParameterInfo();
                paramInfo.setParamId(param.getParam_id());
                paramInfo.setType(param.getParam_type());
                paramInfo.setDescription(param.getDescription());
                paramInfo.setValue(param.getValue());
                paramList.add(paramInfo);
            }
            info.setParam(paramList);
        }
        return info;
    }

    public JobTreeItem getJobTreeOneLevel(String parentJobId, Locale locale) throws FinderException, NamingException {
        JobInfo info = new JobInfo("", "", -1);
        JobTreeItem tree = new JobTreeItem(null, info);
        info = new JobInfo("", Messages.getString((String)"job", (Locale)locale), -1);
        JobTreeItem item = new JobTreeItem(tree, info);
        Collection ct = JobRelationMasterUtil.getLocalHome().findByParentJobId(parentJobId);
        for (JobRelationMasterLocal children : ct) {
            JobMasterLocal childJob = children.getJobMaster();
            JobInfo childInfo = new JobInfo(childJob.getJob_id(), childJob.getJob_name(), childJob.getJob_type());
            JobTreeItem childItem = new JobTreeItem(item, childInfo);
        }
        return tree;
    }

    public ViewListInfo getHistoryList(int histories) throws FinderException, NamingException, SQLException {
        ViewListInfo list = new ViewListInfo();
        ArrayList history = new ArrayList();
        int total = 0;
        if (histories <= 0) {
            histories = 500;
        }
        Integer limit = histories + 1;
        Collection sessionList = JobSessionUtil.getLocalHome().findHistory(null, null, null, null, null, null, limit);
        if (sessionList != null) {
            total = sessionList.size() > histories ? JobSessionUtil.getLocalHome().countHistory(null, null, null, null, null, null) : sessionList.size();
            for (JobSessionLocal session : sessionList) {
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(session.getSession_id(), session.getJob_id()));
                JobInfoLocal jobInfo = sessionJob.getJobInfo();
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(sessionJob.getStatus());
                info.add(sessionJob.getEnd_status());
                info.add(sessionJob.getEnd_value());
                info.add(sessionJob.getSession_id());
                info.add(sessionJob.getJob_id());
                info.add(jobInfo.getJob_name());
                info.add(jobInfo.getJob_type());
                if (jobInfo.getJob_type() == 2) {
                    JobCommandInfoLocal jobCommand = jobInfo.getJobCommandInfo();
                    if (jobCommand != null) {
                        info.add(jobCommand.getFacility_id());
                        info.add(sessionJob.getScope_text());
                    } else {
                        info.add(null);
                        info.add(null);
                    }
                } else {
                    info.add(null);
                    info.add(null);
                }
                info.add(session.getSchedule_date());
                info.add(sessionJob.getStart_date());
                info.add(sessionJob.getEnd_date());
                history.add(info);
                if (history.size() < histories) continue;
                break;
            }
        }
        list.setTotal(total);
        list.setList(history);
        return list;
    }

    public ViewListInfo getHistoryList(Property property, int histories) throws FinderException, NamingException, SQLException {
        ArrayList values = null;
        values = PropertyUtil.getPropertyValue((Property)property, (String)"startFromDate");
        Date startFromDate = null;
        if (values.get(0) != null && values.get(0) instanceof Date) {
            startFromDate = (Date)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"startToDate");
        Date startToDate = null;
        if (values.get(0) != null && values.get(0) instanceof Date) {
            startToDate = (Date)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"endFromDate");
        Date endFromDate = null;
        if (values.get(0) != null && values.get(0) instanceof Date) {
            endFromDate = (Date)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"endToDate");
        Date endToDate = null;
        if (values.get(0) != null && values.get(0) instanceof Date) {
            endToDate = (Date)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"jobId");
        String jobId = null;
        if (values.get(0) instanceof JobTreeItem) {
            jobId = ((JobTreeItem)values.get(0)).getData().getId();
        } else if (values.get(0) instanceof String && ((String)values.get(0)).length() > 0) {
            jobId = (String)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"status");
        Integer status = null;
        if (values.get(0) instanceof String) {
            String statusString = (String)values.get(0);
            status = StatusConstant.stringToType((String)statusString);
        }
        ViewListInfo list = new ViewListInfo();
        ArrayList history = new ArrayList();
        int total = 0;
        if (histories <= 0) {
            histories = 500;
        }
        Integer limit = histories + 1;
        Collection sessionList = JobSessionUtil.getLocalHome().findHistory(startFromDate, startToDate, endFromDate, endToDate, jobId, status, limit);
        if (sessionList != null) {
            total = sessionList.size() > histories ? JobSessionUtil.getLocalHome().countHistory(startFromDate, startToDate, endFromDate, endToDate, jobId, status) : sessionList.size();
            for (JobSessionLocal session : sessionList) {
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(session.getSession_id(), session.getJob_id()));
                JobInfoLocal jobInfo = sessionJob.getJobInfo();
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(sessionJob.getStatus());
                info.add(sessionJob.getEnd_status());
                info.add(sessionJob.getEnd_value());
                info.add(sessionJob.getSession_id());
                info.add(sessionJob.getJob_id());
                info.add(jobInfo.getJob_name());
                info.add(jobInfo.getJob_type());
                if (jobInfo.getJob_type() == 2) {
                    JobCommandInfoLocal jobCommand = jobInfo.getJobCommandInfo();
                    if (jobCommand != null) {
                        info.add(jobCommand.getFacility_id());
                        info.add(sessionJob.getScope_text());
                    } else {
                        info.add(null);
                        info.add(null);
                    }
                } else {
                    info.add(null);
                    info.add(null);
                }
                info.add(session.getSchedule_date());
                info.add(sessionJob.getStart_date());
                info.add(sessionJob.getEnd_date());
                history.add(info);
                if (history.size() < histories) continue;
                break;
            }
        }
        list.setTotal(total);
        list.setList(history);
        return list;
    }

    public CommonTableTreeItem getDetailList(String sessionId) throws FinderException, NamingException {
        JobSessionLocal session = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(session.getSession_id(), session.getJob_id()));
        CommonTableTreeItem tree = new CommonTableTreeItem(null, null);
        this.createDetailTree(sessionJob, tree);
        return tree;
    }

    protected void createDetailTree(JobSessionJobLocal sessionJob, CommonTableTreeItem parent) throws FinderException, NamingException {
        ArrayList info = this.createDetailTreeData(sessionJob);
        CommonTableTreeItem item = new CommonTableTreeItem(parent, info);
        JobInfoLocal job = sessionJob.getJobInfo();
        if (m_openForwardFileJob.booleanValue() || job.getJob_type() != 3) {
            Collection collection = null;
            try {
                collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionJob.getSession_id(), sessionJob.getJob_id());
            }
            catch (FinderException e) {
                throw e;
            }
            catch (NamingException e) {
                throw e;
            }
            if (collection != null && collection.size() > 0) {
                for (JobRelationInfoLocal children : collection) {
                    JobSessionJobLocal childJob = children.getJobSessionJob();
                    this.createDetailTree(childJob, item);
                }
            }
        }
    }

    protected ArrayList createDetailTreeData(JobSessionJobLocal sessionJob) {
        JobInfoLocal jobInfo = sessionJob.getJobInfo();
        ArrayList<Object> info = new ArrayList<Object>();
        info.add("");
        info.add(sessionJob.getStatus());
        info.add(sessionJob.getEnd_status());
        info.add(sessionJob.getEnd_value());
        info.add(sessionJob.getJob_id());
        info.add(jobInfo.getJob_name());
        info.add(jobInfo.getJob_type());
        if (jobInfo.getJob_type() == 1 || jobInfo.getJob_type() == 2) {
            JobCommandInfoLocal jobCommand = jobInfo.getJobCommandInfo();
            if (jobCommand != null) {
                info.add(jobCommand.getFacility_id());
                info.add(sessionJob.getScope_text());
            } else {
                info.add(null);
                info.add(null);
            }
            JobStartInfoLocal jobStart = jobInfo.getJobStartInfo();
            if (jobStart != null) {
                JobStartTimeInfoLocal jobStartTime = jobStart.getJobStartTimeInfo();
                if (jobStartTime != null) {
                    info.add(jobStartTime.getStart_time());
                } else {
                    info.add(null);
                }
            } else {
                info.add(null);
            }
        } else {
            info.add(null);
            info.add(null);
            info.add(null);
        }
        info.add(sessionJob.getStart_date());
        info.add(sessionJob.getEnd_date());
        return info;
    }

    public ArrayList getNodeDetailList(String sessionId, String jobId, Locale locale) throws FinderException, NamingException, CreateException {
        ArrayList nodeDetail = new ArrayList();
        if (sessionId != null && sessionId.length() > 0 && jobId != null && jobId.length() > 0) {
            JobSessionJobLocal sessionjob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
            JobInfoLocal job = sessionjob.getJobInfo();
            if (job.getJob_type() == 2) {
                Collection nodeList = sessionjob.getJobSessionNode();
                if (nodeList != null) {
                    for (JobSessionNodeLocal sessionNode : nodeList) {
                        ArrayList<Object> info = new ArrayList<Object>();
                        info.add(sessionNode.getStatus());
                        info.add(sessionNode.getEnd_value());
                        info.add(sessionNode.getFacility_id());
                        info.add(sessionNode.getNode_name());
                        info.add(sessionNode.getStart_date());
                        info.add(sessionNode.getEnd_date());
                        info.add(sessionNode.getMessage());
                        nodeDetail.add(info);
                    }
                }
            } else if (job.getJob_type() == 3) {
                nodeDetail = this.getFileJobNodeDetailList(sessionId, jobId, locale);
            }
        }
        return nodeDetail;
    }

    protected ArrayList getFileJobNodeDetailList(String sessionId, String jobId, Locale locale) throws FinderException, NamingException, CreateException {
        JobSessionJobLocal sessionJob;
        JobInfoLocal job;
        ArrayList nodeDetail = new ArrayList();
        if (sessionId != null && sessionId.length() > 0 && jobId != null && jobId.length() > 0 && (job = (sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId))).getJobInfo()).getJob_type() == 3) {
            Collection collection;
            JobFileInfoLocal file = job.getJobFileInfo();
            if (this.repository == null) {
                this.repository = RepositoryControllerUtil.getLocalHome().create();
            }
            if ((collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionJob.getSession_id(), sessionJob.getJob_id())) != null && collection.size() > 0) {
                for (JobRelationInfoLocal children : collection) {
                    JobSessionJobLocal childSessionJob = children.getJobSessionJob();
                    JobInfoLocal childJob = childSessionJob.getJobInfo();
                    if (childJob.getJob_type() != 1) continue;
                    String facilityId = childSessionJob.getJob_id();
                    facilityId = facilityId.replaceFirst(sessionJob.getJob_id() + "_", "");
                    String destFacilityName = this.repository.getFacilityPath(facilityId, null);
                    ArrayList<Object> info = new ArrayList<Object>();
                    info.add(childSessionJob.getStatus());
                    info.add(childSessionJob.getEnd_value());
                    info.add(facilityId);
                    info.add(childSessionJob.getScope_text());
                    info.add(childSessionJob.getStart_date());
                    info.add(childSessionJob.getEnd_date());
                    info.add(this.getFileJobDetailMessage(childJob.getSession_id(), childJob.getJob_id(), facilityId, destFacilityName, file.getCheck_flg(), locale));
                    nodeDetail.add(info);
                }
            }
        }
        return nodeDetail;
    }

    protected String getFileJobDetailMessage(String sessionId, String jobId, String destFacilityId, String destFacilityName, int checksum, Locale locale) throws FinderException, NamingException {
        Collection collection;
        String START = "_START";
        String END = "_END";
        String FILE = "_FILE";
        String RTN = "\n";
        StringBuilder message = new StringBuilder();
        if (sessionId != null && sessionId.length() > 0 && jobId != null && jobId.length() > 0 && (collection = JobRelationInfoUtil.getLocalHome().findByStartDate(sessionId, jobId)) != null && collection.size() > 0) {
            Iterator itr = collection.iterator();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 2, locale);
            HashMap<String, String> jobIdMap = new HashMap<String, String>();
            while (itr.hasNext()) {
                Object[] args;
                String file;
                String dateString;
                String fileJobId;
                JobRelationInfoLocal children = (JobRelationInfoLocal)itr.next();
                JobSessionJobLocal childSessionJob = children.getJobSessionJob();
                JobInfoLocal job = childSessionJob.getJobInfo();
                JobCommandInfoLocal command = job.getJobCommandInfo();
                if (childSessionJob.getJob_id().indexOf("_GET_CS") != -1) {
                    fileJobId = childSessionJob.getJob_id().replaceAll("_GET_CS", "");
                    jobIdMap.put(fileJobId + "_FILE", command.getArgument());
                    if (childSessionJob.getStart_date() != null) {
                        dateString = dateFormat.format(childSessionJob.getStart_date());
                        file = command.getArgument();
                        args = new Object[]{dateString, file, destFacilityName};
                        message.append(Messages.getString((String)"message.job.48", (Object[])args, (Locale)locale));
                        message.append("\n");
                        jobIdMap.put(fileJobId, "_START");
                    }
                    if (childSessionJob.getEnd_date() == null || childSessionJob.getEnd_status() != null && childSessionJob.getEnd_status() == 0) continue;
                    dateString = dateFormat.format(childSessionJob.getEnd_date());
                    file = command.getArgument();
                    args = new Object[]{dateString, file, destFacilityName};
                    message.append(Messages.getString((String)"message.job.50", (Object[])args, (Locale)locale));
                    message.append("\n");
                    jobIdMap.put(fileJobId, "_END");
                    continue;
                }
                if (childSessionJob.getJob_id().indexOf("_FORWARD") != -1) {
                    fileJobId = childSessionJob.getJob_id().replaceAll("_FORWARD", "");
                    if (childSessionJob.getStart_date() != null && checksum == 0) {
                        dateString = dateFormat.format(childSessionJob.getStart_date());
                        file = command.getArgument();
                        args = new Object[]{dateString, file, destFacilityName};
                        message.append(Messages.getString((String)"message.job.48", (Object[])args, (Locale)locale));
                        message.append("\n");
                        jobIdMap.put(fileJobId, "_START");
                    }
                    if (!(childSessionJob.getEnd_date() == null || jobIdMap.get(fileJobId) != null && ((String)jobIdMap.get(fileJobId)).equals("_END"))) {
                        dateString = dateFormat.format(childSessionJob.getEnd_date());
                        file = command.getArgument();
                        args = new Object[]{dateString, file, destFacilityName};
                        if (childSessionJob.getEnd_status() != null && childSessionJob.getEnd_status() == 0) {
                            if (checksum == 0) {
                                message.append(Messages.getString((String)"message.job.49", (Object[])args, (Locale)locale));
                                message.append("\n");
                                jobIdMap.put(fileJobId, "_END");
                            }
                        } else {
                            message.append(Messages.getString((String)"message.job.50", (Object[])args, (Locale)locale));
                            message.append("\n");
                            jobIdMap.put(fileJobId, "_END");
                        }
                    }
                    if (checksum != 0) continue;
                    jobIdMap.remove(fileJobId);
                    jobIdMap.remove(fileJobId + "_FILE");
                    continue;
                }
                if (childSessionJob.getJob_id().indexOf("_CHECK_CS") == -1) continue;
                fileJobId = childSessionJob.getJob_id().replaceAll("_CHECK_CS", "");
                if (!(childSessionJob.getEnd_date() == null || jobIdMap.get(fileJobId) != null && ((String)jobIdMap.get(fileJobId)).equals("_END"))) {
                    dateString = dateFormat.format(childSessionJob.getEnd_date());
                    file = (String)jobIdMap.get(fileJobId + "_FILE");
                    args = new Object[]{dateString, file, destFacilityName};
                    if (childSessionJob.getEnd_status() != null && childSessionJob.getEnd_status() == 0) {
                        message.append(Messages.getString((String)"message.job.49", (Object[])args, (Locale)locale));
                        message.append("\n");
                    } else {
                        message.append(Messages.getString((String)"message.job.50", (Object[])args, (Locale)locale));
                        message.append("\n");
                        jobIdMap.put(fileJobId, "_END");
                    }
                }
                jobIdMap.remove(fileJobId);
                jobIdMap.remove(fileJobId + "_FILE");
            }
        }
        if (message.length() > 0) {
            message.setLength(message.length() - 1);
        }
        return message.toString();
    }

    public ArrayList getForwardFileList(String sessionId, String jobId) throws FinderException, NamingException, CreateException {
        JobSessionJobLocal sessionJob;
        JobInfoLocal job;
        ArrayList list = new ArrayList();
        if (sessionId != null && sessionId.length() > 0 && jobId != null && jobId.length() > 0 && (job = (sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId))).getJobInfo()).getJob_type() == 3) {
            JobFileInfoLocal file = job.getJobFileInfo();
            if (this.repository == null) {
                this.repository = RepositoryControllerUtil.getLocalHome().create();
            }
            String srcFacilityName = this.repository.getFacilityPath(file.getSrc_facility_id(), null);
            Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionJob.getSession_id(), sessionJob.getJob_id());
            if (collection != null && collection.size() > 0) {
                for (JobRelationInfoLocal children : collection) {
                    JobSessionJobLocal childSessionJob = children.getJobSessionJob();
                    JobInfoLocal childJob = childSessionJob.getJobInfo();
                    if (childJob.getJob_type() != 1) continue;
                    String facilityId = childSessionJob.getJob_id();
                    facilityId = facilityId.replaceFirst(sessionJob.getJob_id() + "_", "");
                    String destFacilityName = this.repository.getFacilityPath(facilityId, null);
                    ArrayList info = this.getForwardFileListInfo(childJob.getSession_id(), childJob.getJob_id(), file.getSrc_facility_id(), srcFacilityName, facilityId, destFacilityName, file.getCheck_flg());
                    list.addAll(info);
                }
            }
        }
        return list;
    }

    protected ArrayList getForwardFileListInfo(String sessionId, String jobId, String srcFacilityId, String srcFacilityName, String destFacilityId, String destFacilityName, int checksum) throws FinderException, NamingException {
        Collection collection;
        String STATUS = "_STATUS";
        String END_STATUS = "_END_STATUS";
        String START_DATE = "_START_DATE";
        String END_DATE = "_END_DATE";
        String FILE = "_FILE";
        ArrayList list = new ArrayList();
        if (sessionId != null && sessionId.length() > 0 && jobId != null && jobId.length() > 0 && (collection = JobRelationInfoUtil.getLocalHome().findByStartDate(sessionId, jobId)) != null && collection.size() > 0) {
            Iterator itr = collection.iterator();
            HashMap<String, Object> jobIdMap = new HashMap<String, Object>();
            while (itr.hasNext()) {
                ArrayList<Object> info;
                String fileJobId;
                JobRelationInfoLocal children = (JobRelationInfoLocal)itr.next();
                JobSessionJobLocal childSessionJob = children.getJobSessionJob();
                JobInfoLocal job = childSessionJob.getJobInfo();
                JobCommandInfoLocal command = job.getJobCommandInfo();
                if (childSessionJob.getJob_id().indexOf("_GET_CS") != -1) {
                    fileJobId = childSessionJob.getJob_id().replaceAll("_GET_CS", "");
                    jobIdMap.put(fileJobId + "_STATUS", childSessionJob.getStatus());
                    jobIdMap.put(fileJobId + "_END_STATUS", childSessionJob.getEnd_status());
                    jobIdMap.put(fileJobId + "_FILE", command.getArgument());
                    jobIdMap.put(fileJobId + "_START_DATE", childSessionJob.getStart_date());
                    jobIdMap.put(fileJobId + "_END_DATE", childSessionJob.getEnd_date());
                    continue;
                }
                if (childSessionJob.getJob_id().indexOf("_FORWARD") != -1) {
                    fileJobId = childSessionJob.getJob_id().replaceAll("_FORWARD", "");
                    if (checksum == 0) {
                        jobIdMap.put(fileJobId + "_STATUS", childSessionJob.getStatus());
                        jobIdMap.put(fileJobId + "_END_STATUS", childSessionJob.getEnd_status());
                        jobIdMap.put(fileJobId + "_FILE", command.getArgument());
                        jobIdMap.put(fileJobId + "_START_DATE", childSessionJob.getStart_date());
                        jobIdMap.put(fileJobId + "_END_DATE", childSessionJob.getEnd_date());
                    } else if (childSessionJob.getEnd_status() != null && childSessionJob.getEnd_status() != 0) {
                        jobIdMap.put(fileJobId + "_STATUS", childSessionJob.getStatus());
                        jobIdMap.put(fileJobId + "_END_STATUS", childSessionJob.getEnd_status());
                        jobIdMap.put(fileJobId + "_END_DATE", childSessionJob.getEnd_date());
                    }
                    if (checksum != 0) continue;
                    info = new ArrayList<Object>();
                    info.add(jobIdMap.get(fileJobId + "_STATUS"));
                    info.add(jobIdMap.get(fileJobId + "_END_STATUS"));
                    info.add(jobIdMap.get(fileJobId + "_FILE"));
                    info.add(srcFacilityId);
                    info.add(srcFacilityName);
                    info.add(destFacilityId);
                    info.add(destFacilityName);
                    info.add(jobIdMap.get(fileJobId + "_START_DATE"));
                    info.add(jobIdMap.get(fileJobId + "_END_DATE"));
                    list.add(info);
                    continue;
                }
                if (childSessionJob.getJob_id().indexOf("_CHECK_CS") == -1) continue;
                fileJobId = childSessionJob.getJob_id().replaceAll("_CHECK_CS", "");
                if (childSessionJob.getEnd_status() != null && childSessionJob.getEnd_status() != 0) {
                    jobIdMap.put(fileJobId + "_STATUS", childSessionJob.getStatus());
                    jobIdMap.put(fileJobId + "_END_STATUS", childSessionJob.getEnd_status());
                    jobIdMap.put(fileJobId + "_END_DATE", childSessionJob.getEnd_date());
                }
                info = new ArrayList();
                info.add(jobIdMap.get(fileJobId + "_STATUS"));
                info.add(jobIdMap.get(fileJobId + "_END_STATUS"));
                info.add(jobIdMap.get(fileJobId + "_FILE"));
                info.add(srcFacilityId);
                info.add(srcFacilityName);
                info.add(destFacilityId);
                info.add(destFacilityName);
                info.add(jobIdMap.get(fileJobId + "_START_DATE"));
                info.add(jobIdMap.get(fileJobId + "_END_DATE"));
                list.add(info);
            }
        }
        return list;
    }

    public JobTreeItem getSessionJobInfo(String sessionId, String jobId) throws FinderException, NamingException {
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobInfoLocal job = sessionJob.getJobInfo();
        JobInfo info = this.createSessionJobData(job);
        JobTreeItem item = new JobTreeItem(null, info);
        return item;
    }

    protected JobInfo createSessionJobData(JobInfoLocal job) throws FinderException, NamingException {
        JobInfo info = new JobInfo(job.getJob_id(), job.getJob_name(), job.getJob_type());
        info.setDescription(job.getDescription());
        info.setCreateTime(job.getReg_date());
        info.setUpdateTime(job.getUpdate_date());
        info.setCreateUser(job.getReg_user());
        info.setUpdateUser(job.getUpdate_user());
        JobWaitRuleInfo waitRule = null;
        JobStartInfoLocal start = job.getJobStartInfo();
        if (start != null) {
            JobStartTimeInfoLocal startTime;
            waitRule = new JobWaitRuleInfo();
            waitRule.setSuspend(start.getSuspend());
            waitRule.setCondition(start.getCondition_type());
            waitRule.setEndCondition(start.getUnmatch_end_flg());
            waitRule.setEndStatus(start.getUnmatch_end_status());
            waitRule.setEndValue(start.getUnmatch_end_value());
            waitRule.setSkip(start.getSkip());
            waitRule.setSkipEndStatus(start.getSkip_end_status());
            waitRule.setSkipEndValue(start.getSkip_end_value());
            waitRule.setCalendar(start.getCalendar());
            waitRule.setCalendarId(start.getCalendar_id());
            waitRule.setCalendarEndValue(start.getCalendar_end_value());
            waitRule.setStart_delay(start.getStart_delay());
            waitRule.setStart_delay_session(start.getStart_delay_session());
            waitRule.setStart_delay_session_value(start.getStart_delay_session_value());
            waitRule.setStart_delay_time(start.getStart_delay_time());
            if (start.getStart_delay_time_value() instanceof Time) {
                waitRule.setStart_delay_time_value(new Date(start.getStart_delay_time_value().getTime()));
            }
            waitRule.setStart_delay_condition_type(start.getStart_delay_condition_type());
            waitRule.setStart_delay_notify(start.getStart_delay_notify());
            waitRule.setStart_delay_notify_priority(start.getStart_delay_notify_priority());
            waitRule.setStart_delay_operation(start.getStart_delay_operation());
            waitRule.setStart_delay_operation_type(start.getStart_delay_operation_type());
            waitRule.setStart_delay_operation_end_value(start.getStart_delay_operation_end_value());
            waitRule.setEnd_delay(start.getEnd_delay());
            waitRule.setEnd_delay_session(start.getEnd_delay_session());
            waitRule.setEnd_delay_session_value(start.getEnd_delay_session_value());
            waitRule.setEnd_delay_job(start.getEnd_delay_job());
            waitRule.setEnd_delay_job_value(start.getEnd_delay_job_value());
            waitRule.setEnd_delay_time(start.getEnd_delay_time());
            if (start.getEnd_delay_time_value() instanceof Time) {
                waitRule.setEnd_delay_time_value(new Date(start.getEnd_delay_time_value().getTime()));
            }
            waitRule.setEnd_delay_condition_type(start.getEnd_delay_condition_type());
            waitRule.setEnd_delay_notify(start.getEnd_delay_notify());
            waitRule.setEnd_delay_notify_priority(start.getEnd_delay_notify_priority());
            waitRule.setEnd_delay_operation(start.getEnd_delay_operation());
            waitRule.setEnd_delay_operation_type(start.getEnd_delay_operation_type());
            waitRule.setEnd_delay_operation_end_value(start.getEnd_delay_operation_end_value());
            Collection startJobList = start.getJobStartJobInfo();
            ArrayList<JobObjectInfo> objectList = new ArrayList<JobObjectInfo>();
            if (startJobList != null && startJobList.size() > 0) {
                for (JobStartJobInfoLocal startJob : startJobList) {
                    if (startJob == null) continue;
                    JobObjectInfo objectInfo = new JobObjectInfo();
                    objectInfo.setJobId(startJob.getTarget_job_id());
                    try {
                        JobInfoLocal targetJob = JobInfoUtil.getLocalHome().findByPrimaryKey(new JobInfoPK(startJob.getSession_id(), startJob.getTarget_job_id()));
                        objectInfo.setJobName(targetJob.getJob_name());
                        objectInfo.setType(startJob.getTarget_job_type());
                        objectInfo.setValue(startJob.getTarget_job_end_value());
                        objectList.add(objectInfo);
                    }
                    catch (FinderException e) {
                        throw e;
                    }
                    catch (NamingException e) {
                        throw e;
                    }
                }
            }
            if ((startTime = start.getJobStartTimeInfo()) != null) {
                JobObjectInfo objectInfo = new JobObjectInfo();
                objectInfo.setType(2);
                objectInfo.setTime(new Date(startTime.getStart_time().getTime()));
                objectList.add(objectInfo);
            }
            waitRule.setObject(objectList);
            info.setWaitRule(waitRule);
        }
        JobCommandInfo commandInfo = null;
        JobCommandInfoLocal command = job.getJobCommandInfo();
        if (command != null) {
            commandInfo = new JobCommandInfo();
            commandInfo.setFacilityID(command.getFacility_id());
            commandInfo.setProcessingMethod(command.getProcess_mode());
            commandInfo.setStartCommand(command.getStart_command());
            commandInfo.setStopCommand(command.getStop_command());
            commandInfo.setUser(command.getEffective_user());
            commandInfo.setErrorEndFlg(command.getError_end_flg());
            commandInfo.setErrorEndValue(command.getError_end_value());
            try {
                if (this.repository == null) {
                    this.repository = RepositoryControllerUtil.getLocalHome().create();
                }
                commandInfo.setScope(this.repository.getFacilityPath(command.getFacility_id(), null));
            }
            catch (CreateException e) {
            }
            catch (NamingException e) {
            }
            catch (FinderException e) {
                // empty catch block
            }
            info.setCommand(commandInfo);
        }
        JobFileInfo fileInfo = null;
        JobFileInfoLocal file = job.getJobFileInfo();
        if (file != null) {
            fileInfo = new JobFileInfo();
            fileInfo.setProcessingMethod(file.getProcess_mode());
            fileInfo.setSrcFacilityID(file.getSrc_facility_id());
            fileInfo.setDestFacilityID(file.getDest_facility_id());
            fileInfo.setSrcFile(file.getSrc_file());
            fileInfo.setSrcWorkDir(file.getSrc_work_dir());
            fileInfo.setDestDirectory(file.getDest_directory());
            fileInfo.setDestWorkDir(file.getDest_work_dir());
            fileInfo.setCompressionFlg(file.getCompression_flg());
            fileInfo.setCheckFlg(file.getCheck_flg());
            fileInfo.setUser(file.getEffective_user());
            try {
                if (this.repository == null) {
                    this.repository = RepositoryControllerUtil.getLocalHome().create();
                }
                fileInfo.setSrcScope(this.repository.getFacilityPath(file.getSrc_facility_id(), null));
                fileInfo.setDestScope(this.repository.getFacilityPath(file.getDest_facility_id(), null));
            }
            catch (CreateException e) {
            }
            catch (NamingException e) {
            }
            catch (FinderException e) {
                // empty catch block
            }
            info.setFile(fileInfo);
        }
        ArrayList<JobNotificationsInfo> noticeList = new ArrayList<JobNotificationsInfo>();
        Collection notices = job.getJobNoticeInfo();
        if (notices != null) {
            for (JobNoticeInfoLocal notice : notices) {
                JobNotificationsInfo notificationsInfo = new JobNotificationsInfo();
                notificationsInfo.setType(notice.getNotice_type());
                notificationsInfo.setPriority(notice.getPriority());
                notificationsInfo.setNotify_id(notice.getNotify_id());
                noticeList.add(notificationsInfo);
            }
            info.setNotifications(noticeList);
        }
        ArrayList<JobEndStatusInfo> endList = new ArrayList<JobEndStatusInfo>();
        Collection ends = job.getJobEndInfo();
        if (ends != null) {
            for (JobEndInfoLocal end : ends) {
                JobEndStatusInfo endInfo = new JobEndStatusInfo();
                endInfo.setType(end.getEnd_status());
                endInfo.setValue(end.getEnd_value());
                endInfo.setStartRangeValue(end.getEnd_value_from());
                endInfo.setEndRangeValue(end.getEnd_value_to());
                endList.add(endInfo);
            }
            info.setEndStatus(endList);
        }
        ArrayList<JobParameterInfo> paramList = new ArrayList<JobParameterInfo>();
        Collection params = job.getJobParamInfo();
        if (params != null) {
            for (JobParamInfoLocal param : params) {
                JobParameterInfo paramInfo = new JobParameterInfo();
                paramInfo.setParamId(param.getParam_id());
                paramInfo.setType(param.getParam_type());
                paramInfo.setDescription(param.getDescription());
                paramInfo.setValue(param.getValue());
                paramList.add(paramInfo);
            }
            info.setParam(paramList);
        }
        return info;
    }
}

