/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.bean;

import com.clustercontrol.performanceMGR.bean.CollectorItemPK;
import com.clustercontrol.performanceMGR.bean.Facility;
import com.clustercontrol.performanceMGR.bean.Node;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Scope
extends Facility {
    protected static Log m_log = LogFactory.getLog(Node.class);
    private TreeSet m_children = new TreeSet();
    private HashSet m_nodes = new HashSet();

    Scope(String facilityID, String faclityName) {
        super(facilityID, faclityName, 1);
    }

    public void addChildren(Facility child) {
        this.m_children.add(child);
        if (child.getType() == 2) {
            this.m_nodes.add(child);
        }
    }

    public HashSet getNode(HashSet nodeSet) {
        Iterator itr = this.m_children.iterator();
        nodeSet.addAll(this.m_nodes);
        while (itr.hasNext()) {
            Facility child = (Facility)itr.next();
            if (child.getType() != 1) continue;
            ((Scope)child).getNode(nodeSet);
        }
        return nodeSet;
    }

    public int getNodeCount() {
        int count = 0;
        for (Facility child : this.m_children) {
            count += child.getNodeCount();
        }
        return count;
    }

    public double calcValue(String itemCode, int deviceIndex) {
        double total = 0.0;
        int counter = 0;
        for (Facility child : this.m_children) {
            if (child.getNodeCount() == 0) continue;
            double childValue = child.calcValue(itemCode, deviceIndex);
            if (Double.isNaN(childValue)) {
                childValue = child.getCalcValueBuffer(new CollectorItemPK(itemCode, deviceIndex));
            }
            if (Double.isNaN(childValue)) continue;
            total += childValue;
            ++counter;
        }
        double returnValue = counter != 0 ? total / (double)counter : Double.NaN;
        if (!Double.isNaN(returnValue)) {
            this.setCalcValueBuffer(new CollectorItemPK(itemCode, deviceIndex), returnValue);
        }
        m_log.debug((Object)("calcValue() : " + this.m_facilityID + " " + itemCode + " " + deviceIndex + "  " + returnValue));
        return returnValue;
    }

    public String[] getChildrenID() {
        String[] facilityIDs = new String[this.m_children.size()];
        Iterator itr = this.m_children.iterator();
        int i = 0;
        while (itr.hasNext()) {
            facilityIDs[i] = ((Facility)itr.next()).getFacilityID();
            ++i;
        }
        return facilityIDs;
    }
}

