/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.util;

import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobObjectInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;

public class JobUtil {
    private static final String COPY_OF = "Copy Of?";

    public static JobTreeItem copy(JobTreeItem original) {
        JobTreeItem clone = null;
        if (original != null) {
            clone = (JobTreeItem)original.clone();
        }
        return clone;
    }

    public static JobTreeItem copy(JobTreeItem original, JobTreeItem top) {
        JobTreeItem clone = JobUtil.copy(original);
        JobUtil.deleteWaitRule(clone);
        JobUtil.changeJobId(clone, top, clone);
        return clone;
    }

    protected static void changeJobId(JobTreeItem item, JobTreeItem top, JobTreeItem clone) {
        if (item == null || top == null) {
            return;
        }
        JobInfo info = item.getData();
        if (info != null && info instanceof JobInfo) {
            int count = 1;
            StringBuffer jobId = new StringBuffer();
            jobId.append(info.getId());
            while (JobUtil.findJobId(jobId.toString(), top) || JobUtil.findJobId(jobId.toString(), clone)) {
                jobId.delete(0, jobId.length());
                if (count == 1) {
                    jobId.append(COPY_OF.replace("?", " "));
                } else {
                    jobId.append(COPY_OF.replace("?", " (" + count + ") "));
                }
                jobId.append(info.getId());
                ++count;
            }
            info.setId(jobId.toString());
        }
        JobTreeItem[] childrens = item.getChildren();
        int i = 0;
        while (i < childrens.length) {
            JobUtil.changeJobId(childrens[i], top, clone);
            ++i;
        }
    }

    protected static void deleteWaitRule(JobTreeItem item) {
        JobWaitRuleInfo waitRule;
        if (item == null) {
            return;
        }
        JobInfo info = item.getData();
        if (info != null && info instanceof JobInfo && (waitRule = info.getWaitRule()) != null && waitRule instanceof JobWaitRuleInfo && waitRule.getObject() != null && waitRule.getObject() instanceof ArrayList) {
            waitRule.setObject(new ArrayList());
        }
        JobTreeItem[] childrens = item.getChildren();
        int i = 0;
        while (i < childrens.length) {
            JobUtil.deleteWaitRule(childrens[i]);
            ++i;
        }
    }

    public static boolean findJobId(String jobId, JobTreeItem item) {
        boolean find = false;
        JobInfo info = item.getData();
        if (info != null && info instanceof JobInfo && jobId.compareTo(info.getId()) == 0) {
            find = true;
            return find;
        }
        JobTreeItem[] childrens = item.getChildren();
        int i = 0;
        while (i < childrens.length) {
            find = JobUtil.findJobId(jobId, childrens[i]);
            if (find) break;
            ++i;
        }
        return find;
    }

    /*
     * Unable to fully structure code
     */
    public static JobTreeItem getTopJobTreeItem(JobTreeItem item) {
        if (item != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            if (item.getParent().getData().getType() == -1) {
                item = item.getParent();
                break;
            }
            item = item.getParent();
lbl7:
            // 2 sources

            ** while (item.getParent() != null)
        }
lbl8:
        // 2 sources

        return item;
    }

    public static boolean checkWaitRule(JobTreeItem item) {
        boolean check = true;
        if (item == null) {
            return check;
        }
        if (item.getData() != null && item.getData() instanceof JobInfo) {
            String jobId = item.getData().getId();
            JobWaitRuleInfo waitRule = item.getData().getWaitRule();
            if (waitRule != null && waitRule instanceof JobWaitRuleInfo && waitRule.getObject() != null && waitRule.getObject().size() > 0) {
                for (JobObjectInfo objectInfo : waitRule.getObject()) {
                    if (objectInfo.getType() == 2) continue;
                    boolean find = false;
                    String targetJobId = objectInfo.getJobId();
                    JobTreeItem[] childrens = item.getParent().getChildren();
                    int i = 0;
                    while (i < childrens.length) {
                        JobInfo childInfo = childrens[i].getData();
                        if (childInfo != null && childInfo instanceof JobInfo && !jobId.equals(childInfo.getId()) && targetJobId.compareTo(childInfo.getId()) == 0) {
                            find = true;
                            break;
                        }
                        ++i;
                    }
                    if (find) continue;
                    Object[] args = new String[]{jobId, targetJobId};
                    MessageDialog.openWarning(null, (String)Messages.getString((String)"message.hinemos.1"), (String)Messages.getString((String)"message.job.58", (Object[])args));
                    check = false;
                    return check;
                }
            }
        }
        JobTreeItem[] childrens = item.getChildren();
        int i = 0;
        while (i < childrens.length) {
            check = JobUtil.checkWaitRule(childrens[i]);
            if (!check) break;
            ++i;
        }
        return check;
    }
}

