package jp.hrtdotnet.java.util;

import jp.hrtdotnet.java.util.TimeUtil;
import junit.framework.TestCase;

public class TimeUtilTest extends TestCase {

    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.java.util.TimeUtil#TimeUtil()} ̂߂̃eXgE\bhB
     */
    public void testTimeUtil() {
        new TimeUtil();
    }

    /**
     * {@link jp.hrtdotnet.java.util.TimeUtil#TimeUtil(long, long)} ̂߂̃eXgE\bhB
     */
    public void testTimeUtil_LongLong() {
        new TimeUtil(100L, 100L);
        new TimeUtil(2000L, -1L);
        new TimeUtil(-1L, 2000L);
        new TimeUtil(10L, 1L);
        try {
            new TimeUtil(1L, 10L);
            fail();
        } catch(IllegalArgumentException e) {            
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.TimeUtil#start()} ̂߂̃eXgE\bhB
     */
    public void testStart() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.java.util.TimeUtil#stop()} ̂߂̃eXgE\bhB
     */
    public void testStop() {
        TimeUtil c = new TimeUtil();
        c.start();
        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
        }
        assertTrue(c.stop());
    }

    /**
     * {@link jp.hrtdotnet.java.util.TimeUtil#check()} ̂߂̃eXgE\bhB
     */
    public void testCheck() {
        TimeUtil c = new TimeUtil(10000L, -1L);
        c.start();
        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
        }
        c.stop();
        assertTrue(c.check());

        c = new TimeUtil(1000L, -1L);
        c.start();
        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
        }
        c.stop();
        assertFalse(c.check());

        c = new TimeUtil(-1L, 1000L);
        c.start();
        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
        }
        c.stop();
        assertTrue(c.check());

        c = new TimeUtil(-1L, 10000L);
        c.start();
        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
        }
        c.stop();
        assertFalse(c.check());    
    }

    /**
     * {@link jp.hrtdotnet.java.util.TimeUtil#getDiff()} ̂߂̃eXgE\bhB
     */
    public void testGetDiff() {
        TimeUtil c = new TimeUtil();
        c.start();
        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
        }
        c.stop();
        assertTrue(c.getDiff() >= 5000L);
    }

    /**
     * {@link jp.hrtdotnet.java.util.TimeUtil#clear()} ̂߂̃eXgE\bhB
     */
    public void testClear() {
        TimeUtil c = new TimeUtil();
        c.start();
        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
        }
        c.stop();
        c.clear();
        assertEquals(c.getDiff(), 0L);
    }

    /**
     * {@link jp.hrtdotnet.java.util.TimeUtil#checkTrue()} ̂߂̃eXgE\bhB
     */
    public void testCheckTrue() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.java.util.TimeUtil#checkFalse()} ̂߂̃eXgE\bhB
     */
    public void testCheckFalse() {
        //sv
    }
}

class TimeCheckTestEx extends TimeUtil {
    
    int i = 0;
    
    public void checkTrue() {
        i = 1;
    }
    
    public void checkFalse() {
        i = 2;
    }

}