package jp.hrtdotnet.java.io;

import java.io.FileInputStream;
import java.io.IOException;

import jp.hrtdotnet.java.HTestCase;

public class HFileWriterTest extends HTestCase {

    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.java.io.HFileWriter#HFileWriter(java.lang.String, boolean, java.lang.String)} ̂߂̃eXgE\bhB
     * @throws IOException 
     */
    public void testHFileWriter_StringBooleanString() throws IOException {
        new HFileWriter(getTmpFilePath("HFileWriterTest","txt",true), false, null);
        try {
            new HFileWriter(getTmpDirectoryPath(), false, null);
            fail();
        } catch (IOException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.io.HFileWriter#HFileWriter(jp.hrtdotnet.java.io.HFile, boolean, java.lang.String)} ̂߂̃eXgE\bhB
     * @throws IOException 
     */
    public void testHFileWriter_HFileBooleanString() throws IOException {
        new HFileWriter(new HFile(getTmpFilePath("HFileWriterTest","txt",true)), false, null);
        try {
            HFile f = null;
            new HFileWriter(f, false, null);
            fail();
        } catch (NullPointerException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.io.HFileWriter#HFileWriter(java.lang.String, boolean, java.lang.String, int)} ̂߂̃eXgE\bhB
     * @throws IOException 
     */
    public void testHFileWriter_StringBooleanStringInt() throws IOException {
        new HFileWriter(getTmpFilePath("HFileWriterTest","txt",true), false, null, 1);
        try {
            new HFileWriter(getTmpDirectoryPath(), false, null, 1);
            fail();
        } catch (IOException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.io.HFileWriter#HFileWriter(jp.hrtdotnet.java.io.HFile, boolean, java.lang.String, int)} ̂߂̃eXgE\bhB
     * @throws IOException 
     */
    public void testHFileWriter_HFileBooleanStringInt() throws IOException {
        new HFileWriter(new HFile(getTmpFilePath("HFileWriterTest","txt",true)), false, null, 1);
        try {
            HFile f = null;
            new HFileWriter(f, false, null, 1);
            fail();
        } catch (NullPointerException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.io.HFileWriter#write(java.io.InputStream)} ̂߂̃eXgE\bhB
     * @throws IOException 
     */
    public void testWrite_InputStream() throws IOException {
        String tmpFile = getTmpFilePath("HFileWriterTest","txt",true);
        HFileWriter writer = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(getTestPngPath());
            for (int i = 0; i < 10; i++) {
                writer = new HFileWriter(tmpFile, false, "_");
                writer.write(fis);
            }
            tmpFile = getTmpFilePath("HFileWriterTest","txt",true);
            for (int i = 0; i < 10; i++) {
                writer = new HFileWriter(tmpFile, false, "_", 3);
                writer.write(fis);
            }
            tmpFile = getTmpFilePath("HFileWriterTest","txt",false, true);
            for (int i = 0; i < 10; i++) {
                writer = new HFileWriter(tmpFile, true, "_", 4);
                writer.write(fis);
            }
        } finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    /**
     * {@link jp.hrtdotnet.java.io.HFileWriter#makeDirectory()} ̂߂̃eXgE\bhB
     * @throws IOException 
     */
    public void testMakeDirectory() throws IOException {
        String tmpFile = getTmpFilePath("HFileWriterTest","txt",false,true);
        HFileWriter writer = new HFileWriter(tmpFile, false, "_");
        writer.makeDirectory();
    }

    /**
     * {@link jp.hrtdotnet.java.io.HFileWriter#makeOutputFile()} ̂߂̃eXgE\bhB
     * @throws IOException 
     */
    public void testMakeOutputFile() throws IOException {
        //mFs
    }

}
