/*
 * SyetemUtil.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.java.util;

/**
 * Ԃv܂B
 * JnI܂ł̎Ԃ擾EvAw肵Ԃ͈͓̔ŏ邩
 * ǂ肷邱Ƃł܂B
 * ܂̃NXg邱ƂŔ肵ʂɂē̏邱Ƃł܂B
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class TimeUtil {
    
    private long start;
    private long stop;
    private long diff;
    private long maxMilliSecond;
    private long minMilliSecond;

    /**
     * RXgN^B
     * ̃RXgN^ō쐬ꂽIuWFNg͎ԃ`FbNs܂B
     * 
     * @since 2.0
     */
    public TimeUtil() {        
        this(-1L, -1L);
    }
    
    /**
     * RXgN^B
     * ̃RXgN^ō쐬ꂽIuWFNg͎ԃ`FbNs܂B
     * <br><br>
     * JnԂƏIԂ̍sԂƂA
     * RXgN^쐬̍ۂɎsԂ̏lƉlw肵܂B
     * ԌvIƂ`FbN\bhĂяoƂ
     * w肵ElɃ`FbNs܂B
     * <br>
     * ȂlEl 0L w肷ƃ`FbN͍s܂B
     * ܂1~b菭Ȃlw肵ꍇ0Lw肵܂B
     * 
     * @param maxMilliSecond i~bj
     * @param minMilliSecond i~bj
     * @since 2.0
     */
    public TimeUtil(long maxMilliSecond, long minMilliSecond) {        
        if (maxMilliSecond >= 0L && minMilliSecond >= 0L && maxMilliSecond < minMilliSecond) {
            throw new IllegalArgumentException();
        }
        this.maxMilliSecond = maxMilliSecond;
        this.minMilliSecond = minMilliSecond;
        this.clear();
    }

    /**
     * JnԂL^܂B
     * JnԂL^ɂ̃\bhĂяoĂ܂Ɖߋ̊JnԂ̓ZbgA
     * Ăяo__ƂĐVL^܂B
     * <br>
     * ܂JnԋL^łȂɊւ炸ߋ̏IԂsԂ̓NA0LƂȂ܂B
     * 
     * @since 2.0
     */
    public synchronized void start() {
        this.clear();
        start = System.currentTimeMillis();
    }
    
    /**
     * IԂL^AsԂ͈͓ł邩ǂ̃`FbN܂B
     * sԂgetDiff()\bhŎ擾邱Ƃł܂B
     * 
     * @return ͈͓łtrueAłȂfalse
     * @since 2.0
     */
    public synchronized boolean stop() {
        stop = System.currentTimeMillis();
        diff = stop - start;
        return check();
    }
    
    /**
     * sԂw肵Ԃ͈͓̔ł邩ǂ̃`FbN܂B
     * w肵Ԃ͈͓̔łcheckTrue()sA
     * łȂcheckFalse()s܂B
     * 
     * @return  ͈͓łtrueAłȂfalse
     * @since 2.0
     */
    public synchronized boolean check() {
        
        boolean b = true;

        try {
            if (maxMilliSecond >= 0L) {
                if (diff > maxMilliSecond) {
                    b = false;
                    return false;
                }
            }

            if (minMilliSecond >= 0L) {
                if (diff < minMilliSecond) {
                    b = false;
                    return false;
                }
            }            
            return true;
        } finally {
            if (b) {
                checkTrue();
            } else {
                checkFalse();
            }
        }
    }
    
    /**
     * sԁiIԂƊJnԂ̍j擾܂B
     * 
     * @return s
     * @since 2.0
     */
    public synchronized long getDiff() {
        return diff;
    }
    
    /**
     * ԃ`FbNɗpf[^NA܂B
     * <br><br>
     * NÂ͈ȉ̍ڂłB
     * <ul>
     * <li>Jn</li>
     * <li>I</li>
     * <li>IԂƊJnԂ̍isԁj</li>
     * </ul>
     * 
     * @since 2.0
     */
    public synchronized void clear() {
        start = 0L;
        stop = 0L;
        diff = 0L;
    }


    /**
     * sԂ̃`FbN({@link #check() check()})ɎsԂw肵
     * Ԃ͈͓̔łƂɂ̃\bhs܂B
     * ftHgł͉s܂B
     * <br>
     * ̏ꍇ̓\bhI[o[ChKv܂B
     * 
     * @since 2.0
     */
    protected void checkTrue() {
    }

    /**
     * sԂ̃`FbN({@link #check() check()})ɎsԂw肵
     * Ԃ͈̔͊OłƂɂ̃\bhs܂B
     * ftHgł͉s܂B
     * <br>
     * ̏ꍇ̓\bhI[o[ChKv܂B
     * 
     * @since 2.0
     */
    protected void checkFalse() {
    }
}
