/*
 * HDirectory.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.java.io;

import java.io.File;
import java.io.IOException;

/**
 * fBNg𑀍삷NXłB
 * ̃NX𗘗păt@C𑀍삷邱Ƃ͋֎~Ă܂B
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class HDirectory extends File {

    private static final long serialVersionUID = -1822934435075769490L;

    /**
     * RXgN^B
     * 
     * @param directoryPath fBNgpX
     * @throws IOException
     *          directoryPatht@CłA܂̓fBNgƂĕsȃpXłꍇ
     * @since 2.0
     */
    public HDirectory(String directoryPath) throws IOException {
        super(directoryPath);
        if (exists() && isFile()) {
            throw new IOException("Directory is file.");
        }        
        if( checkDirectoryName(directoryPath) == false){
            throw new IOException("Directory-path is invalid.");
        }
    }

    /**
     * fBNgpX̐̔܂B
     * fBNgpXȉ̏Ƀ}b`ꍇAsłƔf܂B
     * <ol>
     * <li>null</li>
     * <li>0oCgi󕶎jA256oCgȏ</li>
     * <li>召ʂɓuCON.vuAUX.vuPRN.vuNUL.vn܂</li>
     * <li>gqOuCOM[0-9]vuLPT[0-9]v̂́i[0-9]0`9̂ǂꂩj</li>
     * <li>u\vu:vu*vu?vu&quot;vu&lt;vu&gt;vu|v܂</li>
     * <li>u.vihbgj</li>
     * </ol>
     * 
     * @param directory fBNgpX
     * @return łtrueAȊOfalse
     * @since 2.0
     */
    public static boolean checkDirectoryName(String directory) {

        if (directory == null || directory.length() < 1) {
            return false;
        }        
        directory = directory.replaceAll("\\\\", "/");
        String dirArray[] = directory.split("/");
        
        for (int i = 0; i < dirArray.length; i++) {
            if(dirArray[i] == null || dirArray.length < 1){
                continue;
            }

            // t@C󕶎falseԂ
            if (dirArray[i].length() > 255) {
                return false;
            }

            String upperStr = dirArray[i].toUpperCase();
            
            if (upperStr.startsWith("CON.")
                    || upperStr.startsWith("AUX.")
                    || upperStr.startsWith("PRN.")
                    || upperStr.startsWith("NUL.")) {
                return false;
            }

            if (upperStr.matches("COM[0-9]\\..*")
                    || upperStr.matches("LPT[0-9]\\..*")
                    || upperStr.matches("COM[0-9]")
                    || upperStr.matches("LPT[0-9]")) {
                return false;
            }

            if ((i == 0 && upperStr.matches("[a-zA-Z]:")) == false) {
                if (upperStr.indexOf(":") != -1) {
                    return false;
                }
            }
            
            if (upperStr.indexOf("*") != -1
                    || upperStr.indexOf("?") != -1 || upperStr.indexOf("\"") != -1
                    || upperStr.indexOf("<") != -1 || upperStr.indexOf(">") != -1
                    || upperStr.indexOf("|") != -1) {
                return false;
            }

            // t@C̍Ōオ "." ͕s
            if (dirArray[i].endsWith(".")) {
                return false;
            }
        }        
        return true;
    }

    /**
     * ̃\bh͗pĂ͂Ȃ܂B
     * pꍇAFile#createNewFile()Ɠs܂B
     * 
     * @deprecated ̃\bh͗pĂ͂Ȃ܂B
     * @since 2.0
     */
    public boolean createNewFile() throws IOException {
        return super.createNewFile();
    }

}
