#include "main.h"

struct timers *tms;
extern struct timer *tts;	/* task.c */

void pit_init(void)
{
	io_out8(0x0043, 0x34);	/* NbNݒ */
	io_out8(0x0040, 0x9c);	/* 100hz */
	io_out8(0x0040, 0x2e);
	tms = 0;
	return;
}

void timer_init(void)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct timer *t;
	int i;

	tms = (struct timers *) memory_alloc(mem, sizeof (struct timers));
	tms->count = 0;
	for (i = 0; i < TIMERS; i++) {
		tms->timer[i].flag = 0;
	}

	/* ԕ */
	t = timer_alloc();
	t->tout = 0xffffffff;
	t->flag = TIMER_USING;
	t->next = 0;	/* Ō */
	tms->t = t;		/* ŏł */
	return;
}

void int_20(int *esp)
{
	struct timer *t;
	char fts = 0;

	io_out8(0x0020, 0x60);
	if (tms == 0) {	/* łĂȂ */
		return;
	}
	tms->count++;
	t = tms->t;

	for (;;) {
		if (t->tout > tms->count) {
			tms->t = t;
			if(fts == 1) {
				task_switch();
			}
			return;
		}

		t->flag = TIMER_USING;
		if (t != tts) {
			fifo_put(t->fifo, t->data);
		} else {
			fts = 1;
		}
		t = t->next;
	}
}

struct timer *timer_alloc(void)
{
	int i;

	for (i = 0; i < TIMERS; i++) {
		if (tms->timer[i].flag == 0) {
			tms->timer[i].flag = TIMER_ALLOC;
			return &tms->timer[i];
		}
	}
	return 0;
}			

void timer_free(struct timer *tmr)
{
	timer_cancel(tmr);
	tmr->flag = 0;
	tmr->fapp = 0;
	return;
}

void timer_set(struct timer *tmr, struct fifo *fifo)
{
	tmr->fifo = fifo;
	return;
}

void timer_sett(struct timer *tmr, unsigned int tout, int data)
{
	struct timer *t, *s;
	int e;

	tmr->tout = tms->count + tout;
	tmr->data = data;
	tmr->flag = TIMER_USING;
	e = io_load_eflags();
	io_cli();

	t = tms->t;
	if (tmr->tout <= t->tout) {
		tms->t = tmr;
		tmr->next = t;
		io_store_eflags(e);
		return;
	}

	for (;;) {
		s = t;
		t = t->next;
		if (tmr->tout <= t->tout) {
			s->next = tmr;
			tmr->next = t;
			io_store_eflags(e);
			return;
		}
	}
}

void timer_allcancel(struct fifo *fifo)
{
	struct timer *t;
	int e, i;

	e = io_load_eflags();
	io_cli();
	for (i = 0; i < TIMERS; i++) {
		t = &tms->timer[i];
		if (t->flag != 0 && t->fapp != 0 && t->fifo == fifo) {
			timer_free(t);
		}
	}
	io_store_eflags(e);
	return;
}

int timer_cancel(struct timer *tmr)
{
	struct timer *t;
	int e;

	e = io_load_eflags();
	io_cli();
	if (tmr->flag == TIMER_USING) {
		if (tmr == tms->t) {
			t = tmr->next;
			tms->t = t;
		} else {
			t = tms->t;
			for (;;) {
				if (t->next == tmr) {
					break;
				}
				t = t->next;
			}
			t->next = tmr->next;
		}
		tmr->flag = TIMER_ALLOC;
		io_store_eflags(e);
		return 1;
	}
	io_store_eflags(e);
	return 0;
}
