#include "main.h"

void memory_init(struct memory *mem)
{
	mem->frees = 0;
	mem->maxfrees = 0;
	mem->losts = 0;
	mem->lostsize = 0;
	return;
}

unsigned int memory_test(unsigned int start, unsigned int end)
{
	unsigned int e, cr0, i;
	char f486 = 0;

	/* CPU̎ނ̊mF */
	e = io_load_eflags();
	e |= 0x00040000;		/* AC-bit */
	io_store_eflags(e);
	e = io_load_eflags();
	if ((e & 0x00040000) != 0) {
		f486 = 1;
	}
	e &= ~0x00040000;
	io_store_eflags(e);

	if (f486 != 0) {
		cr0 = load_cr0();
		cr0 |= 0x60000000;	/* LbV֎~ */
		store_cr0(cr0);
	}

	i = memory_test0(start, end);

	if (f486 != 0) {
		cr0 = load_cr0();
		cr0 &= ~0x60000000;	/* LbV */
		store_cr0(cr0);
	}
	return i;
}

unsigned int memory_stat(struct memory *mem)
{
	unsigned int f = 0, i;

	for (i = 0; i < mem->frees; i++) {
		f += mem->free[i].size;
	}
	return f;
}

unsigned int memory_alloc(struct memory *mem, unsigned int size)
{
	unsigned int a, i;

	for (i = 0; i < mem->frees; i++) {
		if(mem->free[i].size >= size) {
			a = mem->free[i].addr;
			mem->free[i].addr += size;
			mem->free[i].size -= size;
			if(mem->free[i].size == 0) {
				mem->frees--;
				for (; i < mem->frees; i++) {
					mem->free[i] = mem->free[i + 1];
				}
			}
			return a;
		}
	}
	return 0;
}

int memory_free(struct memory *mem, unsigned int addr, unsigned int size)
{
	int i, j;

	/* mem->free[i - 1].addr < addr < mem->free[i].addr */
	for (i = 0; i < mem->frees; i++) {
		if(mem->free[i].addr > addr) {
			break;
		}
	}

	if (i > 0) {	/* O */
		if (mem->free[i - 1].addr + mem->free[i - 1].size == addr) {	/* OƗא */
			mem->free[i - 1].size += size;
			if (i < mem->frees) {	/*  */
				if(addr + size == mem->free[i].addr) {	/* Ƃא */
					mem->free[i - 1].size += mem->free[i].size;
					mem->frees--;
					for (; i < mem->frees; i++) {
						mem->free[i] = mem->free[i + 1];
					}
				}
			}
			return 0;
		}
	}

	if (i < mem->frees) {	/* オ */
		if (addr + size == mem->free[i].addr) {	/* Ɨא */
			mem->free[i].addr = addr;
			mem->free[i].size += size;
			return 0;
		}
	}

	if (mem->frees < MEMORY_FREES) {	/* ڂǉ */
		for (j = mem->frees; j > i; j--) {
			mem->free[j] = mem->free[j - 1];
		}
		mem->frees++;
		if (mem->maxfrees < mem->frees) {
			mem->maxfrees = mem->frees;
		}
		mem->free[i].addr = addr;
		mem->free[i].size = size;
		return 0;
	}

	/* L^Ɏs */
	mem->losts++;
	mem->lostsize += size;
	return -1;
}
