/* head.nas */
struct binfo {
	char cyls, leds, cols, reserve;
	short scrnx, scrny;
	unsigned char *vram;
};
#define BINFO_ADDR	0x00000ff0
#define DISK_ADDR	0x00100000

/* low.nas */
void io_hlt(void);
void io_cli(void);
void io_sti(void);
void io_stihlt(void);
int io_in8(int port);
int io_in16(int port);
int io_in32(int port);
void io_out8(int port, int data);
void io_out16(int port, int data);
void io_out32(int port, int data);
int io_load_eflags(void);
void io_store_eflags(int eflags);
void load_gdtr(int limit, int addr);
void load_idtr(int limit, int addr);
int load_cr0(void);
void store_cr0(int cr0);
void load_tr(int tr);
void farjmp(int eip, int cs);
void farcall(int eip, int cs);
void clts(void);
void fnsave(int *addr);
void frstor(int *addr);
void runapp(int eip, int cs, int ds, int esp, int *esp0);
void endapp(void);
void int_07asm(void);
void int_0casm(void);
void int_0dasm(void);
void int_20asm(void);
void int_21asm(void);
void int_27asm(void);
void int_2casm(void);
void api_asm(void);
unsigned int memory_test0(unsigned int start, unsigned int end);

/* desc.c */
struct sdesc {	/* segment descriptor */
	short limit_low, base_low;
	char base_mid, access_right;
	char limit_high, base_high;
};
struct gdesc {	/* gate descriptor */
	short offset_low, selector;
	char dw_count, access_right;
	short offset_high;
};
#define IDT_ADDR	0x0026f800
#define GDT_ADDR	0x00270000
#define MAIN_ADDR	0x00280000
#define IDT_LIMIT	0x000007ff
#define GDT_LIMIT	0x0000ffff
#define MAIN_LIMIT	0x0007ffff
#define	INT			0x008e
#define LDT			0x0082
#define TSS			0x0089
#define RWDATA		0x4092
#define RXCODE		0x409a
void gdt_init(void);
void idt_init(void);
void gdt_set(struct sdesc *sd, int base, unsigned int limit, int ar);
void idt_set(struct gdesc *gd, int offset, int selector, int ar);

/* int.c */
void pic_init(void);
int *int_07(int *esp);
int *int_0c(int *esp);
int *int_0d(int *esp);
void int_27(int *esp);

/* fifo.c */
struct fifo {
	int *buf;
	int size, free, flag;
	int w_next, r_next;
	struct task *t;
};
#define FIFO_OVERRUN	0x01
void fifo_init(struct fifo *f, int *buf, int size, struct task *t);
int fifo_put(struct fifo *f, int data);
int fifo_get(struct fifo *f);
int fifo_stat(struct fifo *f);

/* timer.c */
#define TIMERS	500
struct timer {
	struct timer *next;
	struct fifo *fifo;
	unsigned int tout, flag, fapp;
	int data;
};
struct timers {
	unsigned int count;
	struct timer *t;
	struct timer timer[TIMERS];
};
#define TIMER_ALLOC	1
#define TIMER_USING	2
void pit_init(void);
void timer_init(void);
void int_20(int *esp);
struct timer *timer_alloc(void);
void timer_free(struct timer *tmr);
void timer_set(struct timer *tmr, struct fifo *f);
void timer_sett(struct timer *tmr, unsigned int tout, int data);
void timer_allcancel(struct fifo *fifo);
int timer_cancel(struct timer *tmr);

/* keyboard.c */
void keyboard_init(struct fifo *f);
void int_21(int *esp);
void keyboard_ready(void);

/* mouse.c */
struct mouse {
	unsigned char buf[3], phase;
	int x, y, btn;
	int mx, my, stat;
};
#define MOUSE_RELEASED	1	/* {^ꂽ */
#define MOUSE_PRESSED	2	/* {^ꂽ */
#define MOUSE_MOVED		3	/* }EẌړ */
#define MOUSE_DRAGGED	4	/* hbOꂽ */
void mouse_enable(struct mouse *m, struct fifo *f);
void int_2c(int *esp);
int mouse_decode(struct mouse *m, unsigned char d);

/* memory.c */
#define MEMORY_FREES	4090
struct memfree {
	unsigned int addr, size;
};
struct memory {
	int allsize;			/* ̃TCY */
	int frees, maxfrees;	/* 󂫏 */
	int losts, lostsize;	/* s */
	struct memfree free[MEMORY_FREES];
};
#define MEMORY_ADDR	0x003c0000
void memory_init(struct memory *mem);
unsigned int memory_test(unsigned int start, unsigned int end);
unsigned int memory_stat(struct memory *mem);
unsigned int memory_alloc(struct memory *mem, unsigned int size);
int memory_free(struct memory *mem, unsigned int addr, unsigned int size);

/* task.c */
#define TASKS	1000
#define TLEVELS	10
#define TLTASKS	100
struct tss {
	int blink, esp0, ss0, esp1, ss1, esp2, ss2, cr3;
	int eip, eflags, eax, ecx, edx, ebx, esp, ebp, esi, edi;
	int es, cs, ss, ds, fs, gs;
	int	ldtr, iomap;
};
struct task {
	int flag, sel;			/* GDTZN^ */
	int pri, lv;			/* t = pri * 0.01 (sec) */
	struct tss tss;
	int fpu[27];
	struct sdesc ldt[2];
	struct fifo fifo;
	struct memory *mem;		/* AvP[ṼǗ */
	struct console *cons;
	struct fhandle *fh;
	int *fat, ds, stack;
	unsigned char lbyte;
};
struct tlevel {
	int running, now;
	struct task *t[TLTASKS];
};
struct tasks {
	int now;
	char chlv;
	struct task *tfpu;
	struct tlevel tl[TLEVELS];
	struct task task[TASKS];
};
#define TASK_USING		1
#define TASK_RUNNING	2
struct task *task_init(void);
void task_switch(void);
struct task *task_alloc(void);
void task_run(struct task *t, int lv, int pri);
void task_sleep(struct task *t);
struct task *task_now(void);
void task_add(struct task *t);
void task_remove(struct task *t);
void task_switch0(void);
void task_idle(void);

/* clock.c */
struct clock {
	unsigned short year;
	unsigned char month, day, hour, min, sec;
};
void clock_get(struct clock *c);
void clock_rtc(unsigned char *t);

/* beep.c */
void beep(int mhz);

/* sheet.c */
#define SHEETS	256
struct sheet {
	unsigned char *buf;
	int cinv, height, flag;	/* F */
	int x, y, sx, sy;
	struct task *task;
	struct menu *menu;
};
struct sheets {
	unsigned char *vram, *map;	/* 	~̃}bv */
	int scrnx, scrny, top;
	struct sheet *s[SHEETS];	/*  */
	struct sheet sht[SHEETS];
};
#define SHEET_USING		0x01
#define	SHEET_APP		0x02
#define SHEET_CUR		0x04
#define SHEET_MENU		0x08
#define SHEET_DIALOGUE	0x10
void sheet_init(void);
struct sheet *sheet_alloc(void);
void sheet_free(struct sheet *sht);
void sheet_set(struct sheet *sht, unsigned char *buf, int sx, int sy, int cinv);
void sheet_updown(struct sheet *sht, int height);
void sheet_slide(struct sheet *sht, int x, int y);
void sheet_refresh(struct sheet *sht, int x0, int y0, int x1, int y1);
void sheet_refresh0(int x0, int y0, int x1, int y1, int h0, int h1);
void sheet_map(int x0, int y0, int x1, int y1, int h0);
void sheet_clean(struct task *task);
void sheet_app(struct sheet *sht);
void sheet_mclose(void);
struct menu *sheet_mchk(int h);
void sheet_mupdown(struct sheet *sht);
void sheet_tupdown(struct sheet *sht);

/* graphic.c */
#define COLOR_000000	0
#define COLOR_FF0000	1
#define COLOR_00FF00	2
#define	COLOR_FFFF00	3
#define COLOR_0000FF	4
#define COLOR_FF00FF	5
#define COLOR_00FFFF	6
#define COLOR_FFFFFF	7
#define COLOR_C6C6C6	8
#define COLOR_840000	9
#define COLOR_008400	10
#define COLOR_848400	11
#define COLOR_000084	12
#define COLOR_840084	13
#define COLOR_008484	14
#define COLOR_848484	15
void palette_init(void);
void palette_set(unsigned char *rgb, int start, int end);
void screen_init(struct sheet *sht, int *fat);
void mcursor_init(struct sheet *sht);
void graphic_line(struct sheet *sht, unsigned char c, int x0, int y0, int x1, int y1);
void graphic_box(struct sheet *sht, unsigned char c, int x0, int y0, int x1, int y1);
void graphic_putc(struct sheet *sht, unsigned char col, int x, int y, unsigned char *c);
void graphic_puts(struct sheet *sht, unsigned char c, int x, int y, unsigned char *s);
void graphic_block(struct sheet *sht, int x0, int y0, int spx, int spy, unsigned char *buf, int sx);
unsigned char rgb2pal(int x, int y, int r, int g, int b);
void graphic_button(struct sheet *sht, int x, int y, int sx, int sy, unsigned char *data, int mode);

/* window.c */
void window_alloc(struct sheet *sht, unsigned char *title, char m);
void window_alloc0(struct sheet *sht, unsigned char *title, char m);
void window_chtitle(struct sheet *sht, char m);
void window_textbox(struct sheet *sht, unsigned char c, int x0, int y0, int sx, int sy);
void window_on(struct sheet *skey);
void window_off(struct sheet *skey);

/* file.c */
struct file {
	unsigned char name[8], ext[3], type;
	unsigned char reserve[10];
	unsigned short time, date, caddr;
	unsigned int size;
};
struct fhandle {
	struct file *file;
	unsigned char *buf, mode;
	int size, pos, bcaddr, baddr;
};
#define FILE_CHANGED	1
void fat_read(int *fat, unsigned char *img);
struct file *file_search(unsigned char *name);
void file_setbuf(struct fhandle *fh, int addr);
int file_addbuf(struct fhandle *fh);
void file_flushbuf(struct fhandle *fh);
struct file *file_create(int *fat, unsigned char *name);
void file_delete(int *fat, struct file *file);
int file_rename(struct file *file, unsigned char *name);
unsigned char *file_read(int *fat, int caddr, int size);
unsigned short file_getfat(int *fat);
struct file *file_getlist(void);
void file_setname(struct file *file, unsigned char *name);
void file_setdate(struct file *file);

/* tek.c */
int tek_getsize(unsigned char *p);
int tek_decomp(unsigned char *p, char *q, int size);

/* menu.c */
#define SELECTS	10
struct select {
	unsigned char *name, *line;
	struct menu *menu;
	int mode;
};
struct menu {
	struct select sel[SELECTS];
	unsigned char *title;
	struct sheet *sht;
	int mode;
};
#define MENU_ACCTIVE	1
#define SEL_SELECT		1
#define SEL_SUBMENU		2
void menu_init(struct menu *m, unsigned char *title);
void menu_add(struct menu *menu, unsigned char *name, unsigned char *line, struct menu *m);
void menu_run(struct sheet *sht, struct menu *m, int mx, int my, int h);
void menu_bon(struct sheet *sht);
void menu_boff(struct sheet *sht);
struct sheet *menu_sheet(struct menu *m);
int menu_check(struct menu *m, int x, int y);
int menu_selrun(struct select *s, int i, struct menu *cm);

/* tbar.c */
struct window {
	struct sheet *sht;
	unsigned char *title;
};
struct tbar {
	struct window win[SHEETS];
	struct sheet *sht;
	int cont, select, start, each;
};
void tbar_init(struct sheet *st);
void tbar_add(struct sheet *sht, unsigned char *title);
void tbar_remove(struct sheet *sht);
void tbar_select(struct sheet *sht);
void tbar_unselect(void);
void tbar_run(int h, int x, int y);
void tbar_print(void);
void tbar_print0(struct window *win, int i);

/* console.c */
struct console {
	struct sheet *sht;
	int cx, cy, cc;
	unsigned char line[30];
};
void console_task(struct sheet *sht);
struct sheet *console_open(int *fat);
struct task *console_open0(struct sheet *sht, int *fat);
void console_close(struct sheet *sht);
void console_close0(struct task *task);
void console_putc(struct console *cons, unsigned char c, char m);
void console_puts(struct console *cons, unsigned char *s, int n);
void console_nline(struct console *cons);
void console_runcmd(struct console *cons, int *fat);
void console_mem(struct console *cons);
void console_cls(struct console *cons);
void console_dir(struct console *cons);
void console_exit(struct console *cons, int *fat);
void console_start(struct console *cons, int *fat);
void console_ncst(unsigned char *line, int *fat);
void console_create(struct console *cons, int *fat);
void console_delete(struct console *cons, int *fat);
void console_rename(struct console *cons);
int console_app(struct console *cons, int *fat);

/* api.c */
struct pict {
	int m, sx, sy;
};
struct mapi {	/* }EX */
	int x, y, btn, stat;
};
int *api(int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
void api_putc(struct console *cons, int edx);
void api_puts(struct console *cons, int ds, int ecx, int ebx);
void api_walloc(struct task *task, int *reg, int ds, int edi, int esi, int ebx, int edx, int ecx);
void api_wbox(int ebp, int edi, int esi, int ebx, int edx, int ecx);
void api_wputs(struct task *task, int ds, int ebp, int esi, int ebx, int edx, int ecx);
void api_malloc(struct task *t, int *reg, int ds, int ebx, int edx, int ecx);
void api_mfree(struct task *t, int ds, int edx, int ecx);
void api_wpoint(int esi, int ebx, int edx, int ecx);
void api_wrefresh(int edi, int esi, int ebx, int edx, int ecx);
void api_wline(int ebp, int edi, int esi, int ebx, int edx, int ecx);
void api_wfree(int ebx);
void api_getc(struct task *task, struct console *cons, int *reg, int ecx);
void api_talloc(int *reg);
void api_tset(struct task *task, int ebx, int edx, int ecx);
void api_tfree(int ebx);
void api_beep(int ecx);
void api_fopen(struct task *task, struct fhandle *fh, int *fat, int *reg, int ds, int ebx);
void api_fclose(struct task *task, int ebx);
void api_fsize(struct task *task, int *reg, int ebx, int ecx);
void api_fseek(struct task *task, int ebx, int edx, int ecx);
void api_fread(struct task *task, int ds, int *reg, int ebx, int edx, int ecx);
void api_cline(struct console *cons, int ds, int *reg, int ebx, int ecx);
void api_pchk(struct task *task, int ds, int ebx, int edx);
void api_wpict(struct task *task, int *reg, int ebp, int edi, int esi, int ebx, int edx, int ecx);
void api_clock(int ds, int ebx);
void api_mouse(int ds, int ebx);
void api_fcreate(struct task *task, int *reg, int ds, int ebx);
void api_fdelete(struct task *task, int ebx);
void api_frename(struct task *task, int *reg, int ds, int ebx, int edx);
void api_fwrite(struct task *task, int *reg, int ds, int ebx, int edx, int ecx);
void api_dialogue(struct task *task, int ds, int edx);
void api_fselect(struct task *task, int *reg, int ds, int edx, int ecx);

/* bmp.nasm */
struct DLL_STRPICENV {
	int work[16384];
};
struct RGB {
	unsigned char b, g, r, t;
};
int info_BMP(struct DLL_STRPICENV *env, int *info, int size, char *fp);
int decode0_BMP(struct DLL_STRPICENV *env, int size, char *fp, int b_type, char *buf, int skip);

/* jpeg.c */
int info_JPEG(struct DLL_STRPICENV *env, int *info, int size, char *fp);
int decode0_JPEG(struct DLL_STRPICENV *env, int size, char *fp, int b_type, char *buf, int skip);

/* main.c */
#define NIHONGO_ADDR	0x0fec
void window_refresh(void);
void console_exitreq(struct sheet *sht);
void console_exitreq0(struct task *task);
void console_exitreq1(struct sheet *sht);
void mouse_get(struct mapi *m);
void reset(void);
