#include "main.h"

struct fifo *fkey;

void keyboard_init(struct fifo *f)
{
	fkey = f;
	keyboard_ready();
	io_out8(0x0064, 0x60);	/* [hݒ */
	keyboard_ready();
	io_out8(0x0060, 0x47);	/* KBC̏ */
	return;
}

void int_21(int *esp)
{
	unsigned char data;

	io_out8(0x0020, 0x61);	/* 0x00200x60+IRQŊ荞݊ʒm */
	data = io_in8(0x0060);
	fifo_put(fkey, 256 + (int) data);
	return;
}

void keyboard_ready(void)
{
	for (;;) {
		if ((io_in8(0x0064) & 0x02) == 0) {	/* M\ */
			return;
		}
	}
}
