/* 荞 */
#include "main.h"
#include <stdio.h>

extern struct tasks *tss;

void pic_init(void)
{
	/* ׂĂ̊荞݂󂯕tȂ */
	io_out8(0x0021, 0xff);
	io_out8(0x00a1, 0xff);

	/* }X^PICւ̐ݒ */
	io_out8(0x0020,   0x11);	/* GbWgK[h */
	io_out8(0x0021,   0x20);	/* IRQ-0 - 7INT 0x20-0x27Ŏ󂯕t */
	io_out8(0x0021, 1 << 2);	/* X[uPICIRQ 2ɂĐڑ */
	io_out8(0x0021,   0x01);	/* mobt@[h */

	/* X[uPICւ̐ݒ */
	io_out8(0x00a0, 0x11);	/* GbWgK[h */
	io_out8(0x00a1, 0x28);	/* IRQ-8 - 15INT 0x28-0x2fŎ󂯕t */
	io_out8(0x00a1, 0x02);	/* X[uPICIRQ 2ɂĐڑ */
	io_out8(0x00a1, 0x01);	/* mobt@[h */

	io_out8(0x0021, 0xfb);	/* 11111011 X[uPICȊO͋ */
	io_out8(0x00a1, 0xff);	/* 11111111 ׂĂ */
	return;
}

int *int_07(int *esp)
{
	struct task *t = task_now();

	io_cli();
	clts();
	if (tss->tfpu != t) {
		if (tss->tfpu != 0) {
			fnsave(tss->tfpu->fpu);
		}
		frstor(t->fpu);
		tss->tfpu = t;
	}
	io_sti();
	return 0;
}

int *int_0c(int *esp)
{
	struct task *task = task_now();
	struct console *cons = task->cons;
	unsigned char s[15];

	console_puts(cons, "\nint 0x0c : Stack exception.\n", -1);
	sprintf(s, "eip = 0x%08x", esp[11]);
	console_puts(cons, s, -1);
	return &(task->tss.esp0);
}

int *int_0d(int *esp)
{
	struct task *task = task_now();
	struct console *cons = task->cons;
	unsigned char s[15];

	console_puts(cons, "\nint 0x0d : General protected exception.\n", -1);
	sprintf(s, "eip = 0x%08x", esp[11]);
	console_puts(cons, s, -1);
	return &(task->tss.esp0);
}

void int_27(int *esp)
{
	io_out8(0x0020, 0x67);
	return;
}
