; OS̏
[instrset "i486p"]

VBEMODE	equ		0x0103	; VESA, 800 x 600, 8bitJ[

MAIN	equ		0x00280000
DISKC	equ		0x00100000	; fBXNLbV
DISKCR	equ		0x00008000	; A[h̃fBXNLbV

; bootinfo֌W
CYLS	equ		0x0ff0	; u[gZN^ݒ
LEDS	equ		0x0ff1	; L[{[hLED
COLS	equ		0x0ff2	; ʂ̐F
SCRNX	equ		0x0ff4
SCRNY	equ		0x0ff6
VRAM	equ		0x0ff8

		org		0xc200

; VBȆ݊mF
		mov		ax, 0x9000
		mov		es, ax
		mov		di, 0
		mov		ax, 0x04f00	; [es:di]Ƀf[^
		int		0x10
		cmp		ax, 0x004f
		jne		scrn320

; VBẼo[W2.0ȏ
		mov		ax, [es:di + 4]
		cmp		ax, 0x0200
		jb		scrn320

; ʃ[h̎擾
		mov		cx, VBEMODE
		mov		ax, 0x4f01	; [es:di]Ƀf[^
		int		0x10
		cmp		ax, 0x004f
		jne		scrn320

		cmp		byte [es:di + 0x19], 8	; 8bitJ[
		jne		scrn320
		cmp		byte [es:di + 0x1b], 4	; pbg[h
		jne		scrn320
		mov		ax, [es:di + 0x00]
		and		ax, 0x0080
		jz		scrn320					; 0x4000𑫂ʃ[h

; ʃ[h̐ݒ
		mov		bx, 0x4000 + VBEMODE
		mov		ax, 0x4f02				; ʃ[h̐ݒ
		int		0x10
		mov		byte [COLS], 8
		mov		ax, [es:di + 0x12]
		mov		word [SCRNX], ax
		mov		ax, [es:di + 0x14]
		mov		word [SCRNY], ax
		mov		eax, [es:di + 0x28]
		mov		dword [VRAM], eax
		jmp		kstat

scrn320:
		mov		al, 0x13	; VGA, 320 x 200, 8bitJ[
		mov		ah, 0x00
		int		0x10
		mov		byte [COLS], 8
		mov		word [SCRNX], 320
		mov		word [SCRNY], 200
		mov		dword [VRAM], 0x000a0000

; L[{[hLED̎擾
kstat:
		mov		ah, 0x02	; L[{[hLED̎擾
		int		0x16		; L[{[hBIOS
		mov		[LEDS], al

; PIC荞݂󂯂Ȃ悤ɂ
; AT݊@ŁAPICہACLIOɂĂȂƁAPCnOAbvB
		mov		al, 0xff
		out		0x21, al
		nop					; outA͊댯
		out		0xa1, al
		cli

; A20GATE̐ݒ
		call	waitkbdout
		mov		al, 0xd1
		out		0x64, al
		call	waitkbdout
		mov		al, 0xdf	; A20L
		out		0x60, al
		call	waitkbdout

; 32bitveNg[h
		lgdt	[gdtr0]			; bGDT
		mov		eax, cr0
		and		eax, 0x7fffffff	; y[WO֎~̂߁Abit310
		or		eax, 0x00000001	; veNg[hȍ~̂߁Abit01
		mov		cr0, eax
		jmp		pipelineflash

pipelineflash:
		mov		ax, 1*8	; 32bitǂݏZOg
		mov		ds, ax
		mov		es, ax
		mov		fs, ax
		mov		gs, ax
		mov		ss, ax

; main̓]
		mov		esi, main	; ]
		mov		edi, MAIN	; ]
		mov		ecx, 131072	; _u[hPʂł̃TCYi512kj
		call	memcpy

; u[gZN^̓]
		mov		esi, 0x7c00
		mov		edi, DISKC
		mov		ecx, 128
		call 	memcpy

; fBXN̎c]
		mov		esi, DISKCR+512
		mov		edi, DISKC+512
		mov		ecx, 0
		mov		cl, [CYLS]
		imul	ecx, 4608		; V__u[hPʂ
		sub		ecx, 128		; IPL
		call	memcpy

; main̋N
		mov		ebx, MAIN
		mov		ecx, [EBX+16]
		add		ecx, 3
		shr		ecx, 2
		jz		skip
		mov		esi, [ebx+20]
		add		esi, ebx
		mov		edi, [ebx+12]
		call	memcpy

skip:
		mov		esp, [ebx+12]	; X^bNl
		jmp		dword 2*8:0x0000001b

waitkbdout:
		in		al, 0x64
		and		al, 0x02
		jnz		waitkbdout
		ret

memcpy:
		mov		eax, [esi]
		add		esi, 4
		mov		[edi], eax
		add		edi, 4
		sub		ecx, 1
		jnz		memcpy
		ret

		alignb	8

gdt0:
		resb	8								; kZN^
		dw		0xffff, 0x0000, 0x9200, 0x00cf	; 32bitǂݏZOg
		dw		0xffff, 0x0000, 0x9a28, 0x0047	; mainp32bitsZOg
		dw		0

gdtr0:
		dw		8*3-1
		dd		gdt0

		alignb	8

main:
