#include "main.h"
#include <string.h>

void palette_init(void)
{
	static unsigned char rgb[48] = {
		0x00, 0x00, 0x00,	/*  0  */
		0xff, 0x00, 0x00,	/*  1 邢 */
		0x00, 0xff, 0x00,	/*  2 邢 */
		0xff, 0xff, 0x00,	/*  3 邢F */
		0x00, 0x00, 0xff,	/*  4 邢 */
		0xff, 0x00, 0xff,	/*  5 邢 */
		0x00, 0xff, 0xff,	/*  6 邢F */
		0xff, 0xff, 0xff,	/*  7  */
		0xc6, 0xc6, 0xc6,	/*  8 邢DF */
		0x84, 0x00, 0x00,	/*  9 Â */
		0x00, 0x84, 0x00,	/* 10 Â */
		0x84, 0x84, 0x00,	/* 11 ÂF */
		0x00, 0x00, 0x84,	/* 12 Â */
		0x84, 0x00, 0x84,	/* 13 Â */
		0x00, 0x84, 0x84,	/* 14 ÂF */
		0x84, 0x84, 0x84	/* 15 ÂDF */
	};
	unsigned char rgb2[648];
	int r, g, b;

	palette_set(rgb, 0, 15);
	for (b = 0; b < 6; b++) {	/* RGB6iK̐ݒ */
		for (g = 0; g < 6; g++) {
			for (r = 0; r < 6; r++) {
				rgb2[(r + g * 6 + b * 36) * 3] = r * 51;
				rgb2[(r + g * 6 + b * 36) * 3 + 1] = g * 51;
				rgb2[(r + g * 6 + b * 36) * 3 + 2] = b * 51;
			}
		}
	}
	palette_set(rgb2, 16, 231);
	return;
}

void palette_set(unsigned char *rgb, int start, int end)
{
	int eflags, i;

	eflags = io_load_eflags();
	io_cli();
	io_out8(0x03c8, start);
	for (i = start; i <= end; i++) {
		io_out8(0x03c9, rgb[0] / 4);
		io_out8(0x03c9, rgb[1] / 4);
		io_out8(0x03c9, rgb[2] / 4);
		rgb += 3;
	}
	io_store_eflags(eflags);
	return;
}

void screen_init(struct sheet *sht, int *fat)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct DLL_STRPICENV *env = 0;
	struct RGB *pbuf = 0, *q;
	unsigned char *fbuf = 0, *p;
	struct file *file = file_search("back.bmp");
	int fsize = 0, info[8], x, y, i, j;

	/* wiǂݍ */
	if (file == 0) {
		file = file_search("back.jpg");
		if (file == 0) {
			goto none;
		}
	}
	fsize = file->size;
	fbuf = file_read(fat, file->caddr, fsize);

	env = (struct DLL_STRPICENV *) memory_alloc(mem, sizeof(struct DLL_STRPICENV));
	if (info_BMP(env, info, fsize, fbuf) == 0) {
		if (info_JPEG(env, info, fsize, fbuf) == 0) {
			goto none;
		}
	}
	if (info[2] > sht->sx || info[3] > sht->sy) {
		goto none;
	}
	pbuf = (struct RGB *) memory_alloc(mem, info[2] * info[3] * sizeof(struct RGB));
	if (info[0] == 1) {
		i = decode0_BMP(env, fsize, fbuf, 4, (char *) pbuf, 0);
	} else {
		i = decode0_JPEG(env, fsize, fbuf, 4, (char *) pbuf, 0);
	}
	if (i != 0) {
		goto none;
	}

	x = (sht->sx - info[2]) / 2;
	y = (sht->sy - info[3]) / 2;
	for (i = y; i < y + info[3]; i++) {
		p = sht->buf + i * sht->sx;
		q = pbuf + (i - y) * info[2];
		for (j = x; j < x + info[2]; j++) {
			p[j] = rgb2pal(j, i, q[j - x].r, q[j - x].g, q[j - x].b);
		}
	}
	goto task;

none:
	graphic_box(sht, COLOR_008484, 0,            0, sht->sx - 1, sht->sy - 29);

	/* ^XNo[ */
task:
	graphic_box(sht, COLOR_C6C6C6, 0, sht->sy - 28, sht->sx - 1, sht->sy - 28);
	graphic_box(sht, COLOR_FFFFFF, 0, sht->sy - 27, sht->sx - 1, sht->sy - 27);
	graphic_box(sht, COLOR_C6C6C6, 0, sht->sy - 26, sht->sx - 1,  sht->sy - 1);

	graphic_box(sht, COLOR_848484, sht->sx - 47, sht->sy - 24,  sht->sx - 4, sht->sy - 24);
	graphic_box(sht, COLOR_848484, sht->sx - 47, sht->sy - 23, sht->sx - 47,  sht->sy - 4);
	graphic_box(sht, COLOR_FFFFFF, sht->sx - 47,  sht->sy - 3,  sht->sx - 4,  sht->sy - 3);
	graphic_box(sht, COLOR_FFFFFF,  sht->sx - 3, sht->sy - 24,  sht->sx - 3,  sht->sy - 3);

	menu_boff(sht);

	if (env != 0) {
		memory_free(mem, (unsigned int) env, sizeof(struct DLL_STRPICENV));
	}
	if (pbuf != 0) {
		memory_free(mem, (unsigned int) pbuf, 786432 * sizeof(struct RGB));
	}
	if (fbuf != 0) {
		memory_free(mem, (unsigned int) fbuf, fsize);
	}
	return;
}

void mcursor_init(struct sheet *sht)
{
	static char cursor[16][10] = {
		"*.........",
		"**........",
		"*O*.......",
		"*OO*......",
		"*OOO*.....",
		"*OOOO*....",
		"*OOOOO*...",
		"*OOOOOO*..",
		"*OOOOOOO*.",
		"*OOOOO****",
		"*OO*OO*...",
		"*O*.*OO*..",
		"**..*OO*..",
		"*....*OO*.",
		".....*OO*.",
		"......**.."
	};
	int x, y;

	for (y = 0; y < 16; y++) {
		for (x = 0; x < 10; x++) {
			if(cursor[y][x] == '*') {
				sht->buf[y * 10 + x] = COLOR_000000;
			} else if (cursor[y][x] == 'O') {
				sht->buf[y * 10 + x] = COLOR_FFFFFF;
			} else {
 				sht->buf[y * 10 + x] = sht->cinv;
			}
		}
	}
	return;
}

void graphic_line(struct sheet *sht, unsigned char c, int x0, int y0, int x1, int y1)
{
	int len, dx, dy, x, y, i;

	dx = x1 - x0;
	dy = y1 - y0;
	x = x0 << 10;
	y = y0 << 10;
	if (dx < 0) {
		dx = -dx;
	}
	if (dy < 0) {
		dy = -dy;
	}

	if (dx >= dy) {
		len = dx + 1;
		if (x0 > x1) {
			dx = -1024;
		} else {
			dx = 1024;
		}
		if (y0 <= y1) {
			dy = ((y1 - y0 + 1) << 10) / len;
		} else {
			dy = ((y1 - y0 - 1) << 10) / len;
		}
	} else {
		len = dy + 1;
		if (y0 > y1) {
			dy = -1024;
		} else {
			dy = 1024;
		}
		if (x0 <= x1) {
			dx = ((x1 - x0 + 1) << 10) / len;
		} else {
			dx = ((x1 - x0 - 1) << 10) / len;
		}
	}

	for (i = 0; i < len; i++) {
		sht->buf[(y >> 10) * sht->sx + (x >> 10)] = c;
		x += dx;
		y += dy;
	}
	return;
}

void graphic_box(struct sheet *sht, unsigned char c, int x0, int y0, int x1, int y1)
{
	int x, y;

	for (y = y0; y <= y1; y++) {
		for (x = x0; x <= x1; x++) {
			sht->buf[y * sht->sx + x] = c;
		}
	}
	return;
}

void graphic_putc(struct sheet *sht, unsigned char col, int x, int y, unsigned char *c)
{
	int i;
	unsigned char *p, d;

	for (i = 0; i < 16; i++) {
		p = sht->buf + (y + i) * sht->sx + x;
		d = c[i];
		if ((d & 0x80) != 0) { p[0] = col; }
		if ((d & 0x40) != 0) { p[1] = col; }
		if ((d & 0x20) != 0) { p[2] = col; }
		if ((d & 0x10) != 0) { p[3] = col; }
		if ((d & 0x08) != 0) { p[4] = col; }
		if ((d & 0x04) != 0) { p[5] = col; }
		if ((d & 0x02) != 0) { p[6] = col; }
		if ((d & 0x01) != 0) { p[7] = col; }
	}
	return;
}

void graphic_puts(struct sheet *sht, unsigned char c, int x, int y, unsigned char *s)
{
	struct task *task = task_now();
	unsigned char *nihongo = (unsigned char *) *((int *) NIHONGO_ADDR), *font;
	int ku, ten;

	for (; *s != 0x00; s++) {
		if (task->lbyte == 0) {
			if ((0x81 <= *s && *s <= 0x9f) || (0xe0 <= *s && *s <= 0xfc)) {
				task->lbyte = *s;
			} else {
				graphic_putc(sht, c, x, y, nihongo + *s * 16);
			}
		} else {
			if (0x81 <= task->lbyte && task->lbyte <= 0x9f) {
				ku = (task->lbyte - 0x81) * 2;
			} else {
				ku = 62 + (task->lbyte - 0xe0) * 2;
			}
			if (0x40 <= *s && *s <= 0x7e) {
				ten = *s - 0x40;
			} else if (0x80 <= *s && *s <= 0x9e) {
				ten = *s - 0x80 + 63;
			} else {
				ten = *s - 0x9f;
				ku++;
			}
			task->lbyte = 0;
			font = nihongo + 4096 + (ku * 94 + ten) * 32;
			graphic_putc(sht, c, x - 8, y, font);
			graphic_putc(sht, c, x, y, font + 16);
		}
		x += 8;
	}
	return;
}

void graphic_block(struct sheet *sht, int x0, int y0, int spx, int spy, unsigned char *buf, int sx)
{
	int x, y;

	for (y = 0; y < spy; y++) {
		for (x = 0; x < spx; x++) {
			sht->buf[(y0 + y) * sht->sx + (x0 + x)] = buf[y * sx + x];
		}
	}
	return;
}

unsigned char rgb2pal(int x, int y, int r, int g, int b)
{
	static int table[4] = { 3, 1, 0, 2 };
	int i;

	x &= 1;	/*  */
	y &= 1;
	i = table[y * 2 + x];	/* ԐFp̒萔 */
	r = (r * 21) / 256;	/* 0 - 20 */
	g = (g * 21) / 256;
	b = (b * 21) / 256;
	r = (r + i) / 4;	/* 0 - 5 */
	g = (g + i) / 4;
	b = (b + i) / 4;
	return 16 + r + g * 6 + b * 36;
}

void graphic_button(struct sheet *sht, int x, int y, int sx, int sy, unsigned char *data, int mode)
{
	struct task *task = task_now();
	int x1 = x + sx, y1 = y + sy, s = strlen(data);
	unsigned char c = 0;

	if (s > 15) {
		c = data[16];
		data[16] = 0;
	}
	if (mode == 0) {	/* OFF */
		graphic_box(sht, COLOR_C6C6C6,      x,      y,     x1,     y1);
		graphic_box(sht, COLOR_FFFFFF,  x + 1,      y, x1 - 1,      y);
		graphic_box(sht, COLOR_FFFFFF,      x,      y,      x, y1 - 1);
		graphic_box(sht, COLOR_848484,  x + 1, y1 - 1, x1 - 1, y1 - 1);
		graphic_box(sht, COLOR_848484, x1 - 1,  y + 1, x1 - 1, y1 - 2);
		graphic_box(sht, COLOR_000000,      x,     y1, x1 - 1,     y1);
		graphic_box(sht, COLOR_000000,     x1,      y,     x1,     y1);
		graphic_puts(sht, COLOR_000000, x + 1, y + 3, data);
	} else {
		graphic_box(sht, COLOR_C6C6C6,      x,     y,     x1,     y1);
		graphic_box(sht, COLOR_FFFFFF,      x,    y1,     x1,     y1);
		graphic_box(sht, COLOR_FFFFFF,     x1,     y,     x1,     y1);
		graphic_box(sht, COLOR_000000,  x + 1,     y,     x1,      y);
		graphic_box(sht, COLOR_000000,      x,     y,      x,     y1);
		graphic_box(sht, COLOR_848484,  x + 1, y + 1, x1 - 1,  y + 1);
		graphic_box(sht, COLOR_848484,  x + 1, y + 1,  x + 1, y1 - 1);
		graphic_puts(sht, COLOR_000000, x + 2, y + 4, data);
	}
	if (s > 15) {
		data[16] = c;
	}
	task->lbyte = 0;
	return;
}
