#include "main.h"

void clock_get(struct clock *c)
{
	unsigned char t[7];

	clock_rtc(t);
	c->year = (unsigned short) ((t[6] * 100) | t[5]);
	c->month = (unsigned char) t[4];
	c->day = (unsigned char) t[3];
	c->hour = (unsigned char) t[2];
	c->min = (unsigned char) t[1];
	c->sec = (unsigned char) t[0];
	return;
}

void clock_rtc(unsigned char *t)
{
	static unsigned char addr[7] = { 0x00, 0x02, 0x04, 0x07, 0x08, 0x09, 0x32 };
	static unsigned char max[7] = { 0x60, 0x59, 0x23, 0x31, 0x12, 0x99, 0x99 };
	unsigned char t2[7], err;
	int i;

	for (;;) {	/* ǂݍ݂܂ */
		err = 0;
		for (i = 0; i < 7; i++) {
			io_out8(0x70, addr[i]);
			t2[i] = io_in8(0x71);
		}
		for (i = 0; i < 7; i++) {
			io_out8(0x70, addr[i]);
			if (t2[i] != io_in8(0x71) || (t2[i] & 0x0f) > 9 || t2[i] > max[i]) {
				err = 1;
			}
		}
		if (err == 0) {
			break;
		}
	}
	t[0] = (t2[0] >> 4) * 10 + (t2[0] & 0x0f);
	t[1] = (t2[1] >> 4) * 10 + (t2[1] & 0x0f);
	t[2] = (t2[2] >> 4) * 10 + (t2[2] & 0x0f);
	t[3] = (t2[3] >> 4) * 10 + (t2[3] & 0x0f);
	t[4] = (t2[4] >> 4) * 10 + (t2[4] & 0x0f);
	t[5] = (t2[5] >> 4) * 10 + (t2[5] & 0x0f);
	t[6] = (t2[6] >> 4) * 10 + (t2[6] & 0x0f);
	return;
}
