#include "main.h"

int *api(int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax)
{
	struct task *task = task_now();
	struct console *cons = task->cons;
	struct fhandle *fh = task->fh;
	int *fat = task->fat, *reg = &eax + 1, ds = task->ds;
	/* reg̓^[ƂɁAAvP[ṼWX^ɓ
	  POPAD鏇Ԃl */

	if (eax == 0) {
		/* eax = 0 : AvP[VI */
		return &(task->tss.esp0);
	} else if (eax == 1) {
		/* eax = 1 : R\[ꕶ\
		  edx = R[h */
		api_putc(cons, edx);
	} else if (eax == 2) {
		/* eax = 2 : R\[\
		  ebx = ւ̃|C^
		  ecx = \JEgi-1ȂNULL܂Łj */
		api_puts(cons, ds, ecx, ebx);
	} else if (eax == 3) {
		/* eax = 3 : EBhE쐬
		  ecx = ̃TCY
		  edx = c̃TCY
		  ebx = EBhEobt@
		  esi = EBhE
		  edi = F
		  ߂l:eax = EBhEnh */
		api_walloc(task, reg, ds, edi, esi, ebx, edx, ecx);
	} else if (eax == 4) {
		/* eax = 4 : EBhElp`\
		  ebx = EBhEnhiȂ烊tbVȂj
		  ecx = ̈ʒu
		  edx = c̈ʒu
		  esi = ̃TCY
		  edi = c̃TCY
		  ebp = Fԍ */
		api_wbox(ebp, edi, esi, ebx, edx, ecx);
	} else if (eax == 5) {
 		/* eax = 5 : EBhE\
		  ebx = EBhEnhiȂ烊tbVȂj
		  ecx = ̈ʒu
		  edx = c̈ʒu
		  esi = ւ̃|C^
		  ebp = Fԍ */
		api_wputs(task, ds, ebp, esi, ebx, edx, ecx);
	} else if (eax == 6) {
		/* eax = 6 : 擾
		  ebx = Ǘ\̂ւ̃|C^
		  ecx = TCY
		  edx = ǗTCY
		  ߂l:eax = AhX
		  ŏ̏ꍇAǗ\̂̏ */
		api_malloc(task, reg, ds, ebx, edx, ecx);
	} else if (eax == 7) {
		/* eax = 7 : J
		  ecx = TCY
		  edx = AhX */
		api_mfree(task, ds, edx, ecx);
	} else if (eax == 8) {
		/* eax = 8 : EBhE_\
		  ebx = EBhEnhiȂ烊tbVȂj
		  ecx = ̈ʒu
		  edx = c̈ʒu
		  esi = Fԍ */
		api_wpoint(esi, ebx, edx, ecx);
	} else if (eax == 9) {
		/* eax = 9 : EBhEtbV
		  ebx = EBhEnh
		  ecx = ̈ʒu
		  edx = c̈ʒu
		  esi = ̏I[ʒu
		  edi = c̏I[ʒu */
		api_wrefresh(edi, esi, ebx, edx, ecx);
	} else if (eax == 10) {
		/* eax = 10 : EBhE\
		  ebx = EBhEnhiȂ烊tbVȂj
		  ecx = ̈ʒu
		  edx = c̈ʒu
		  esi = ̏I[ʒu
		  edi = c̏I[ʒu
		  ebp = Fԍ */
		api_wline(ebp, edi, esi, ebx, edx, ecx);
	} else if (eax == 11) {
		/* eax = 11 : EBhE폜
		ebx = EBhEnh */
		api_wfree(ebx);
	} else if (eax == 12) {
		/* eax = 12 : L[
		  ecx = 0ȂAL[͂ȂȂ0ԂA
		        1ȂAL[͂܂ŃX[v
		  ߂l:eax = L[R[hiASCIIj */
		api_getc(task, cons, reg, ecx);
	} else if (eax == 13) {
		/* eax = 13 : ^C}擾
		  ߂l:eax = ^C}nh */
		api_talloc(reg);
	} else if (eax == 14) {
		/* eax = 14 : ^C}ݒ
		  ebx = ^C}nh
		  ecx = ԁi0.01bPʁj
		  edx = f[^ */
		api_tset(task, ebx, edx, ecx);
	} else if (eax == 15) {
		/* eax = 15 : ^C}J
		  ebx = ^C}nh */
		api_tfree(ebx);
	} else if (eax == 16) {
		/* eax = 16 : BEEPTEh
		  ecx = gimhzj */
		api_beep(ecx);
	} else if (eax == 17) {
		/* eax = 17 : t@CI[v
		  ebx = t@C
		  ߂l:eax = t@Cnh */
		api_fopen(task, fh, fat, reg, ds, ebx);
	} else if (eax == 18) {
		/* eax = 18 : t@CN[Y
		  ebx = t@Cnh */
		api_fclose(task, ebx);
	} else if (eax == 19) {
		/* eax = 19 : t@CTCY擾
		  ebx = t@Cnh
		@ecx = t@C擾[h
		        0:t@CTCYA1:ǂݍ݈ʒuA2:I[ǂݍ݈ʒu
		  ߂l:eax = t@CTCY */
		api_fsize(task, reg, ebx, ecx);
	} else if (eax == 20) {
		/* eax = 20 : t@CV[N
		  ebx = t@Cnh
		  ecx = V[NTCY
		  edx = V[N[h
		        0:ŏ 1:݂̈ʒuA2:I[ */
		api_fseek(task, ebx, edx, ecx);
	} else if (eax == 21) {
		/* eax = 21 : t@C[h
		  ebx = t@Cnh
		  ecx = oCgJEg
		  edx = obt@
		  ߂l:eax = ǂݍ񂾃oCgJEg */
		api_fread(task, ds, reg, ebx, edx, ecx);
	} else if (eax == 22) {
		/* eax = 22 : R}hC擾
		  ebx = obt@iƁAst@C΂ĕԂBj
		  ecx = oCgJEg
		  ߂l:eax = ǂݍ񂾃oCgJEg */
		api_cline(cons, ds, reg, ebx, ecx);
	} else if (eax == 23) {
		/* eax = 23 : 摜t@C擾
		  ebx = t@Cnh
		  edx = 摜\̂ւ̃|C^ */
		api_pchk(task, ds, ebx, edx);
	} else if (eax == 24) {
		/* eax = 24 : 摜\
		  ebx = EBhEnh
		  ecx = x0
		  edx = t@Cnh
		  esi = y0
		  edi = x1
		  ebp = y1 */
		api_wpict(task, reg, ebp, edi, esi, ebx, edx, ecx);
	} else if (eax == 25) {
		/* eax = 25 : v
		  ebx = v\̂ւ̃|C^ */
		api_clock(ds, ebx);
	} else if (eax == 26) {
		/* eax = 26 : }EX
		  ebx = }EX\̂ւ̃|C^ */
		api_mouse(ds, ebx);
	} else if (eax == 27) {
		/* eax = 27 : t@C̍쐬
		  ebx = t@C
		  ߂l:eax = t@Cnh */
		api_fcreate(task, reg, ds, ebx);
	} else if (eax == 28) {
		/* eax = 28 : t@C̍폜
		  ebx = t@Cnh */
		api_fdelete(task, ebx);
	} else if (eax == 29) {
		/* eax = 29 : t@C̉
		  ebx = t@Cnh
		  edx = t@C
		  ߂l:eax = G[R[hi1Ȃ琳A0ȂG[j */
		api_frename(task, reg, ds, ebx, edx);
	} else if (eax == 30) {
		/* eax = 30 : t@C̏
		  ebx = t@Cnh
		  ecx = ރTCY
		  edx = obt@AhX
		  ߂l:eax = 񂾃TCY */
		api_fwrite(task, reg, ds, ebx, edx, ecx);
	} else if (eax == 31) {
		/* eax = 31 : _CAO
		  edx =  */
		api_dialogue(task, ds, edx);
	} else if (eax == 32) {
		/* eax = 32 : t@C̑I
		  ecx = obt@̃TCY
		  edx = obt@̃AhX
		  ߂l:eax = t@Cnhiw肳ꂽt@CJj */
		api_fselect(task, reg, ds, edx, ecx);
	}
	return 0;
}

void api_putc(struct console *cons, int edx)
{
	console_putc(cons, edx & 0xff, 1);
	return;
}

void api_puts(struct console *cons, int ds, int ecx, int ebx)
{
	console_puts(cons, (unsigned char *) ds + ebx, ecx);
	return;
}

void api_walloc(struct task *task, int *reg, int ds, int edi, int esi, int ebx, int edx, int ecx)
{
	struct sheet *sht;

	sht = sheet_alloc();
	sht->task = task;
	sht->flag |= SHEET_APP;
	sheet_set(sht, (unsigned char *) (ds + ebx), ecx, edx, edi);
	window_alloc(sht, (unsigned char *) (ds + esi), 0);
	sheet_app(sht);
	window_refresh();
	reg[7] = (int) sht;
	return;
}

void api_wbox(int ebp, int edi, int esi, int ebx, int edx, int ecx)
{
	struct sheet *sht = (struct sheet *) (ebx & 0xfffffffe);

	graphic_box(sht, ebp, ecx, edx, esi, edi);
	if ((ebx & 1) == 0) {
		sheet_refresh(sht, ecx, edx, esi + 1, edi + 1);
	}
	return;
}

void api_wputs(struct task *task, int ds, int ebp, int esi, int ebx, int edx, int ecx)
{
	struct sheet *sht = (struct sheet *) (ebx & 0xfffffffe);
	int s;
	unsigned char *str = (unsigned char *) (ds + esi);

	for (s = 0; str[s] != 0x00; s++) { }
	graphic_puts(sht, ebp, ecx, edx, str);
	if ((ebx & 1) == 0) {
		sheet_refresh(sht, ecx, edx, ecx + s * 16, edx + 16);
	}
	return;
}

void api_malloc(struct task *t, int *reg, int ds, int ebx, int edx, int ecx)
{
	if (t->mem == 0) {	/* ŏ */
		memory_init((struct memory *) (ds + ebx));
		t->mem = (struct memory *) (ds + ebx);
		memory_free(t->mem, (int) (ebx + 32768), edx);
	}
	reg[7] = memory_alloc(t->mem, ecx);
	return;
}

void api_mfree(struct task *t, int ds, int edx, int ecx)
{
	struct memory *mem = t->mem;

	if (mem == 0) {
		return;
	}
	memory_free(mem, edx, ecx);
	return;
}

void api_wpoint(int esi, int ebx, int edx, int ecx)
{
	struct sheet *sht = (struct sheet *) (ebx & 0xfffffffe);

	sht->buf[edx * sht->sx + ecx] = esi;
	if ((ebx & 1) == 0) {
		sheet_refresh(sht, ecx, edx, ecx + 1, edx + 1);
	}
	return;
}

void api_wrefresh(int edi, int esi, int ebx, int edx, int ecx)
{
	struct sheet *sht = (struct sheet *) ebx;

	sheet_refresh(sht, ecx, edx, esi + 1, edi + 1);
	return;
}

void api_wline(int ebp, int edi, int esi, int ebx, int edx, int ecx)
{
	struct sheet *sht = (struct sheet *) (ebx & 0xfffffffe);
	int i;

	graphic_line(sht, ebp, ecx, edx, esi, edi);
	if ((ebx & 1) == 0) {
		if (ecx > esi) {
			i = ecx;
			ecx = esi;
			esi = i;
		}
		if (edx > edi) {
			i = edx;
			edx = edi;
			edi = i;
		}
		sheet_refresh(sht, ecx, edx, esi + 1, edi + 1);
	}
}

void api_wfree(int ebx)
{
	sheet_free((struct sheet *) ebx);
	window_refresh();
	return;
}

void api_getc(struct task *task, struct console *cons, int *reg, int ecx)
{
	int i;

	for (;;) {
		io_cli();
		if (fifo_stat(&task->fifo) == 0) {
			if (ecx != 0) {
				task_sleep(task);
			} else {
				io_sti();
				reg[7] = -1;
				return;
			}
		} else {
			i = fifo_get(&task->fifo);
			io_sti();

			if (i == 2) {
				cons->cc = COLOR_FFFFFF;
			} else if (i == 3) {
				cons->cc = -1;
			} else if (i == 4) {
				io_cli();
				console_exitreq1(cons->sht);
				cons->sht = 0;
				io_sti();
			} else if (i >= 256) {
				reg[7] = i - 256;
				return;
			}
		}
	}
	return;
}

void api_talloc(int *reg)
{
	struct timer *t;

	t = timer_alloc();
	t->fapp = 1;
	reg[7] = (int) t;
	return;
}

void api_tset(struct task *task, int ebx, int edx, int ecx)
{
	struct timer *t = (struct timer *) ebx;

	timer_set(t, &task->fifo);
	timer_sett(t, ecx, edx + 256);
	return;
}

void api_tfree(int ebx)
{
	timer_free((struct timer *) ebx);
	return;
}

void api_beep(int ecx)
{
	beep(ecx);
	return;
}

void api_fopen(struct task *task, struct fhandle *fh, int *fat, int *reg, int ds, int ebx)
{
	struct file *f;
	struct fhandle *fh0;
	int i;

	for (i = 0; i < 8; i++) {
		if (fh[i].buf == 0) {
			break;
		}
	}
	reg[7] = 0;
	if (i < 8) {
		f = file_search((unsigned char *) (ds + ebx));
		if (f != 0) {
			reg[7] = i + 1;
			fh0 = &fh[i];
			fh0->file = f;
			fh0->size = f->size;
			fh0->pos = 0;
			fh0->mode = 0;
			fh0->bcaddr = 0;
			fh0->baddr = 0;
			file_setbuf(fh0, 0);
		}
	}
	return;
}

void api_fclose(struct task *task, int ebx)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct fhandle *fh;

	if ((unsigned int) (ebx - 1) < 8) {
		fh = task->fh + (ebx - 1);
	} else {
		return;
	}
	file_flushbuf(fh);
	memory_free(mem, (int) fh->buf, 512);
	fh->buf = 0;
	return;
}

void api_fsize(struct task *task, int *reg, int ebx, int ecx)
{
	struct fhandle *fh;

	if ((unsigned int) (ebx - 1) < 8) {
		fh = task->fh + (ebx - 1);
	} else {
		return;
	}

	if (ecx == 0) {
		reg[7] = fh->size;
	} else if (ecx == 1) {
		reg[7] = fh->pos;
	} else if (ecx == 2) {
		reg[7] = fh->pos - fh->size;
	}
	return;
}

void api_fseek(struct task *task, int ebx, int edx, int ecx)
{
	struct fhandle *fh;

	if ((unsigned int) (ebx - 1) < 8) {
		fh = task->fh + (ebx - 1);
	} else {
		return;
	}
	if (edx == 0) {
		fh->pos = ecx;
	} else if (edx == 1) {
		fh->pos += ecx;
	} else if (edx == 2) {
		fh->pos = fh->size + ecx;
	}
	if (fh->pos < 0) {
		fh->pos = 0;
	}
	if (fh->pos > fh->size) {
		fh->pos = fh->size;
	}
	file_setbuf(fh, fh->pos);
	return;
}

void api_fread(struct task *task, int ds, int *reg, int ebx, int edx, int ecx)
{
	struct fhandle *fh;
	int i;

	if ((unsigned int) (ebx - 1) < 8) {
		fh = task->fh + (ebx - 1);
	} else {
		return;
	}
	for (i = 0; i < ecx; i++) {
		if (fh->pos >= fh->size) {
			break;
		}
		if (fh->pos - fh->baddr > 512) {
			file_setbuf(fh, fh->pos);
		}
		*((unsigned char *) (ds + edx + i)) = fh->buf[fh->pos - fh->baddr];
		fh->pos++;
	}
	reg[7] = i;
	return;
}

void api_cline(struct console *cons, int ds, int *reg, int ebx, int ecx)
{
	int i = 0, j = 0;

	if ((ebx & 0x01) != 0) {
		for (; cons->line[j] > ' '; j++) { }	/* Xy[X܂œǂݔ΂ */
		for (; cons->line[j] == ' '; j++) { }
	}
	ebx &= ~1;
	for (; ; i++) {
		*((unsigned char *) (ds + ebx + i)) = cons->line[j + i];
		if (cons->line[i] == 0) {
			break;
		}
		if (i >= ecx) {
			break;
		}
	}
	reg[7] = i;
	return;
}

void api_pchk(struct task *task, int ds, int ebx, int edx)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct fhandle *fh;
	struct DLL_STRPICENV *env = (struct DLL_STRPICENV *) memory_alloc(mem, sizeof(struct DLL_STRPICENV));
	struct pict *pict = (struct pict *) (ds + edx);
	unsigned char *fbuf;
	int info[8];

	if ((unsigned int) (ebx - 1) < 8) {
		fh = task->fh + (ebx - 1);
	} else {
		pict->m = 0;
		goto end2;
	}
	fbuf = file_read(task->fat, fh->file->caddr, fh->size);
	if (info_BMP(env, info, fh->size, fbuf) == 0) {
		if (info_JPEG(env, info, fh->size, fbuf) == 0) {
			pict->m = 0;
			goto end;
		}
	}
	/* info[0] = t@C^Cvi1:BMP, 2:JPEGj
	  info[1] = J[
	  info[2] = xsize
	  info[3] = ysize */
	pict->m = info[0];
	pict->sx = info[2];
	pict->sy = info[3];

end:
	memory_free(mem, (unsigned int) fbuf, fh->size);

end2:
	memory_free(mem, (unsigned int) env, sizeof(struct DLL_STRPICENV));
	return;
}

void api_wpict(struct task *task, int *reg, int ebp, int edi, int esi, int ebx, int edx, int ecx)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct fhandle *fh;
	struct sheet *sht = (struct sheet *) ebx;
	struct DLL_STRPICENV *env = (struct DLL_STRPICENV *) memory_alloc(mem, sizeof(struct DLL_STRPICENV));
	struct RGB *pbuf = (struct RGB *) memory_alloc(mem, 786432 * sizeof(struct RGB)), *q;
	unsigned char *fbuf, *p;
	int info[8], i, j;

	if ((unsigned int) (edx - 1) < 8) {
		fh = task->fh + (edx - 1);
	} else {
		reg[7] = 0;
		goto end2;
	}
	fbuf = file_read(task->fat, fh->file->caddr, fh->size);
	if (info_BMP(env, info, fh->size, fbuf) == 0) {
		if (info_JPEG(env, info, fh->size, fbuf) == 0) {
			reg[7] = 0;
			goto end;
		}
	}
	/* info[0] = t@C^Cvi1:BMP, 2:JPEGj
	  info[1] = J[
	  info[2] = xsize
	  info[3] = ysize */
	if (info[0] == 1) {
		i = decode0_BMP(env, fh->size, fbuf, 4, (char *) pbuf, 0);
	} else {
		i = decode0_JPEG(env, fh->size, fbuf, 4, (char *) pbuf, 0);
	}
	if (i != 0) {
			for(;;);
		reg[7] = 0;
		goto end;
	}

	for (i = esi; i < ebp; i++) {
		p = sht->buf + i * sht->sx;
		q = pbuf + (i - esi) * info[2];
		for (j = ecx; j < edi; j++) {
			p[j] = rgb2pal(j, i, q[j - ecx].r, q[j - ecx].g, q[j - ecx].b);
		}
	}
	sheet_refresh(sht, ecx, esi, edi, ebp);
	reg[7] = 1;

end:
	memory_free(mem, (unsigned int) fbuf, fh->size);

end2:
	memory_free(mem, (unsigned int) pbuf, 786432 * sizeof(struct RGB));
	memory_free(mem, (unsigned int) env, sizeof(struct DLL_STRPICENV));
	return;
}

void api_clock(int ds, int ebx)
{
	struct clock *clock = (struct clock *) (ds + ebx);

	clock_get(clock);
	return;
}

void api_mouse(int ds, int ebx)
{
	struct mapi *m = (struct mapi *) (ds + ebx);

	mouse_get(m);
	return;
}

void api_fcreate(struct task *task, int *reg, int ds, int ebx)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct file *f;
	struct fhandle *fh0;
	int i;

	for (i = 0; i < 8; i++) {
		if (task->fh[i].buf == 0) {
			break;
		}
	}
	reg[7] = 0;
	if (i < 8) {
		f = file_create(task->fat, (unsigned char *) (ds + ebx));
		if (f != 0) {
			reg[7] = i + 1;
			fh0 = &task->fh[i];
			fh0->file = f;
			fh0->size = f->size;
			fh0->pos = 0;
			fh0->buf = (unsigned char *) memory_alloc(mem, 512);
			fh0->mode = 0;
			fh0->bcaddr = f->caddr;
			fh0->baddr = 0;
		}
	}
	return;
}

void api_fdelete(struct task *task, int ebx)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct fhandle *fh;

	if ((unsigned int) (ebx - 1) < 8) {
		fh = task->fh + (ebx - 1);
	} else {
		return;
	}
	file_delete(task->fat, fh->file);
	memory_free(mem, (int) fh->buf, 512);
	fh->buf = 0;
	return;
}

void api_frename(struct task *task, int *reg, int ds, int ebx, int edx)
{
	struct fhandle *fh;
	int i;

	if ((unsigned int) (ebx - 1) < 8) {
		fh = task->fh + (ebx - 1);
	} else {
		return;
	}
	i = file_rename(fh->file, (unsigned char *) (ds + edx));
	reg[7] = i;
	return;
}

void api_fwrite(struct task *task, int *reg, int ds, int ebx, int edx, int ecx)
{
	struct fhandle *fh;
	int i;

	if ((unsigned int) (ebx - 1) < 8) {
		fh = task->fh + (ebx - 1);
	} else {
		return;
	}
	for (i = 0; i < ecx; i++) {
		if (fh->pos > fh->size) {
			fh->size = fh->pos;
			fh->file->size = fh->pos;
		}
		if (fh->pos - fh->baddr > 512) {
			file_setbuf(fh, fh->pos);
		}
		fh->mode = FILE_CHANGED;
		fh->buf[fh->pos - fh->baddr] = *((unsigned char *) (ds + edx + i));
		fh->pos++;
	}
	reg[7] = i;
	return;
}

void api_dialogue(struct task *task, int ds, int edx)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct sheet *sht;
	unsigned char *sbuf, *s = (unsigned char *) (ds + edx);
	int i;

	for (i = 0; s[i] != 0x00; i++) { }
	if (i > 33) {
		return;
	}
	sht = sheet_alloc();
	sbuf = (unsigned char *) memory_alloc(mem, (16 + 8 * i) * (36 + 16));
	sheet_set(sht, sbuf, 16 + 8 * i, 36 + 16, -1);
	window_alloc(sht, "_CAO", 0);
	graphic_puts(sht, COLOR_000000, 8, 28, s);
	sht->task = task;
	sht->flag |= SHEET_DIALOGUE;
	sheet_app(sht);
	window_refresh();
	for (;;) {
		io_cli();
		if ((sht->flag & SHEET_DIALOGUE) != 0) {
			task_sleep(task);
			io_sti();
		} else {
			break;
		}
	}
	sheet_free(sht);
	memory_free(mem, (unsigned int) sbuf, (16 + 8 * i) * (36 + 16));
	return;
}

void api_fselect(struct task *task, int *reg, int ds, int edx, int ecx)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct file *f;
	struct fhandle *fh = task->fh, *fh0;
	struct sheet *sht;
	unsigned char *sbuf, *buf = (unsigned char *) (ds + edx), s[2];
	int x = 42, i;

	for (i = 0; i < ecx; i++) {
		buf[i] = 0x00;
	}
	sht = sheet_alloc();
	sbuf = (unsigned char *) memory_alloc(mem, 10472);
	sheet_set(sht, sbuf, 187, 56, -1);
	window_alloc(sht, "t@C̑I", 0);
	window_textbox(sht, COLOR_FFFFFF, 42, 31, 104, 16);
	graphic_box(sht, COLOR_000000, x, 31, x + 7, 46);
	sht->task = task;
	sht->flag |= SHEET_DIALOGUE;
	sheet_app(sht);
	window_refresh();
	reg[7] = 1;
	s[1] = 0;

	for (;;) {
		io_cli();
		if ((sht->flag & SHEET_DIALOGUE) == 0) {
			io_sti();
			reg[7] = 0;
			break;
		}
		if (fifo_stat(&task->fifo) == 0) {
			task_sleep(task);
			io_sti();
		} else {
			i = fifo_get(&task->fifo);
			io_sti();

			if (256 <= i && i < 512) {
				i -= 256;
				if (i == 0x08) {
					if (42 < x) {
						graphic_box(sht, COLOR_FFFFFF, x, 31, x + 7, 47);
						sheet_refresh(sht, x, 31, x + 8, 48);
						buf[x] = 0x00;
						x -= 8;
					}
				} else if (i == 0x0a) {
					break;
				} else {
					if (x < 138) {
						if (((x - 42) / 8) < ecx - 2) {
							buf[(x - 42) / 8] = i;
							s[0] = i;
							graphic_box(sht, COLOR_FFFFFF, x, 31, x + 7, 47);
							graphic_puts(sht, COLOR_000000, x, 31, s);
							sheet_refresh(sht, x, 31, x + 8, 48);
							x += 8;
						}
					}
				}
				graphic_box(sht, COLOR_000000, x, 31, x + 7, 47);
				sheet_refresh(sht, x, 31, x + 8, 48);
			}
		}
	}

	if (reg[7] != 0) {
		for (i = 0; i < 8; i++) {
			if (fh[i].buf == 0) {
				break;
			}
		}
		reg[7] = 0;
		if (i < 8) {
			f = file_search(buf);
			if (f != 0) {
				reg[7] = i + 1;
				fh0 = &fh[i];
				fh0->file = f;
				fh0->size = f->size;
				fh0->pos = 0;
				fh0->mode = 0;
				fh0->bcaddr = 0;
				fh0->baddr = 0;
				file_setbuf(fh0, 0);
			}
		}
	}
	sheet_free(sht);
	memory_free(mem, (unsigned int) sbuf, 10472);
	return;
}
