/* bootpack̃C */

#include "bootpack.h"
#include <stdio.h>

#define KEYCMD_LED	0xed

void HariMain(void)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	struct FIFO32 fifo, keycmd;
	char s[40];
	int fifobuf[128], keycmd_buf[32], mx, my, i, cursor_x, cursor_c;
	struct TIMER *timer;
	unsigned int memtotal;
	struct MOUSE_DEC mdec;
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct SHTCTL *shtctl;
	struct SHEET *sht_back, *sht_mouse, *sht_win, *sht_cons;
	unsigned char *buf_back, buf_mouse[256], *buf_win, *buf_cons;
	static char keytable0[0x54] = {
		0,   0,   '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '^', 0,   0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '@', '[', 0,   0,   'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', ';', ':', 0,   0,   ']', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', ',', '.', '/', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.'
	};
	static char keytable1[0x80] = {
		0,   0,   '!', 0x22, '#', '$', '%', '&', 0x27, '(', ')', '~', '=', '~', 0,   0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '`', '{', 0,   0,   'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', '+', '*', 0,   0,   '}', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', '<', '>', '?', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   '_', 0,   0,   0,   0,   0,   0,   0,   0,   0,   '|', 0,   0
	};
	struct TASK *task_a, *task_cons;
	int key_to = 0, key_shift = 0, key_leds = (binfo->leds >> 4) & 7, keycmd_wait = -1;

/*
	static char font_mini_A[12] = {
		0x00, 0x30, 0x30, 0x48, 0x48, 0x48,
		0x48, 0x78,	0x48, 0x48, 0x48, 0x00
	};
*/

	init_gdtidt();
	init_pic();
	io_sti(); /* IDT/PIC̏ÎCPŮ荞݋֎~ */
	fifo32_init(&fifo, 128, fifobuf, 0);
	fifo32_init(&keycmd, 32, keycmd_buf, 0);
	init_pit();
	init_keyboard(&fifo, 256);
	enable_mouse(&fifo, 512, &mdec);
	io_out8(PIC0_IMR, 0xf8); /* PITPIC1ƃL[{[h(11111000) */
	io_out8(PIC1_IMR, 0xef); /* }EX(11101111) */

	memtotal = memtest(0x00400000,0xbfffffff);
	memman_init(memman);
	memman_free(memman, 0x00001000, 0x0009e000); /*	0x00001000 - 0x0009efff */
	memman_free(memman, 0x00400000, memtotal - 0x00400000);

	init_palette();
	shtctl = shtctl_init(memman, binfo->vram, binfo->scrnx, binfo->scrny);
	task_a = task_init(memman);
	fifo.task = task_a;
	task_run(task_a, 1, 0);

	/* sht_back */
	sht_back  = sheet_alloc(shtctl);
	buf_back  = (unsigned char *) memman_alloc_4k(memman, binfo->scrnx * binfo->scrny);
	sheet_setbuf(sht_back,  buf_back,  binfo->scrnx, binfo->scrny, -1);	/* FȂ */
	init_screen8(buf_back, binfo->scrnx, binfo->scrny);

	/* sht_cons */
	sht_cons = sheet_alloc(shtctl);
	buf_cons = (unsigned char *) memman_alloc_4k(memman, 256 * 165);
	sheet_setbuf(sht_cons, buf_cons, 256, 165, -1);	/* FȂ */
	make_window8(buf_cons, 256, 165, "Console", 0/* iI~ */, 0);
	make_textbox8(sht_cons, 8, 28, 240, 128, COL8_000000);
	task_cons = task_alloc();
	task_cons->tss.esp = memman_alloc_4k(memman, 64 * 1024) + 64 * 1024 - 12;
	task_cons->tss.eip = (int) &console_task;
	task_cons->tss.es = 1 * 8;
	task_cons->tss.cs = 2 * 8;
	task_cons->tss.ss = 1 * 8;
	task_cons->tss.ds = 1 * 8;
	task_cons->tss.fs = 1 * 8;
	task_cons->tss.gs = 1 * 8;
	*((int *) (task_cons->tss.esp + 4)) = (int) sht_cons;
	*((int *) (task_cons->tss.esp + 8)) = memtotal;
	task_run(task_cons, 2, 2);

	/* sht_win */
	sht_win = sheet_alloc(shtctl);
	buf_win = (unsigned char *) memman_alloc_4k(memman, 160 * 52);
	sheet_setbuf(sht_win,   buf_win,   160, 52, -1);	/* FȂ */
	make_window8(buf_win, 160, 52, "OSAkkie", 1/* Nyanpo */, 1);
	make_textbox8(sht_win, 8, 28, 144, 16, COL8_FFFFFF);
	cursor_x = 8;
	cursor_c = COL8_FFFFFF;
	timer = timer_alloc();
	timer_init(timer, &fifo, 1);
	timer_settime(timer, 50);

	/* sht_mouse */
	sht_mouse = sheet_alloc(shtctl);
	sheet_setbuf(sht_mouse, buf_mouse, 16,  16, 99);	/* Fԍ99 */
	init_mouse_cursor8(buf_mouse, 99/* wiF */);
	mx = (binfo->scrnx - 16) / 2; /* ʒɂȂ悤ɍWvZ */
	my = (binfo->scrny - 16) / 2;

	sheet_slide(sht_back,    0,  0);
	sheet_slide(sht_cons,    8, 16);
	sheet_slide(sht_win,   270, 16);
	sheet_slide(sht_mouse,  mx, my);
	sheet_updown(sht_back,  0);
	sheet_updown(sht_cons,  1);
	sheet_updown(sht_win,   2);
	sheet_updown(sht_mouse, 3);

	/* ŏ̃L[{[hԂݒ肵Ă܂ */
	fifo32_put(&keycmd, KEYCMD_LED);
	fifo32_put(&keycmd, key_leds);

	for (;;) {
		if (fifo32_status(&keycmd) > 0 && keycmd_wait < 0) {
			/* L[{[hɑf[^Α */
			keycmd_wait = fifo32_get(&keycmd);
			wait_KBC_sendready();
			io_out8(PORT_KEYDAT, keycmd_wait);
		}
		io_cli();
		if (fifo32_status(&fifo) == 0) {
			task_sleep(task_a);
			io_sti();
		} else {
			i = fifo32_get(&fifo);
			io_sti();
			if (256 <= i && i < 512) {
				/* L[{[h */
				i -= 256;	// ɈƂ
				if (i < 0x80) {
					/* L[R[h𕶎R[hɕϊ */
					if (key_shift == 0)
						s[0] = keytable0[i];
					else
						s[0] = keytable1[i];
				} else {
					s[0] = 0;
				}
				if ('A' <= s[0] && s[0] <= 'Z')	{
					/* At@xbg͂ꂽ */
					if (((key_leds & 4) == 0 && key_shift == 0) ||
						((key_leds & 4) != 0 && key_shift != 0)   ) {
						s[0] += 0x20;	/* ɕϊ */
					}
				}
				if (s[0]) {
					/* ʂ̕ */
					if (key_to == 0) {
						/* ^XNA(OSAkkie) */
						if (cursor_x < 144) {
							/* ꕶ\ăJ[\1߂ */
							s[1] = 0;
							putfonts8_asc_sht(sht_win, cursor_x, 28, COL8_000000, COL8_FFFFFF, s, 1);
							cursor_x += 8;
						}
					} else {
						/* R\[ */
						fifo32_put(&task_cons->fifo, s[0] + 256);
					}
				}
				if (i == 0x0e) {
					/* obNXy[X */
					if (key_to == 0) {
						/* ^XNA(OSAkkie) */
						if (cursor_x > 8) {
							/* ꕶ߂ĂXy[X2ď */
							cursor_x -= 8;
							putfonts8_asc_sht(sht_win, cursor_x, 28, COL8_000000, COL8_FFFFFF, "  ", 2);
						}
					} else {
						/* R\[ */
						fifo32_put(&task_cons->fifo, 8 + 256);
					}
				}
				if (i == 0x1c) {
					/* EnterL[ */
					if (key_to)
						fifo32_put(&task_cons->fifo, 10 + 256);
				}
				if (i == 0x0f) {
					/* Tab */
					if (key_to == 0) {
						key_to = 1;
						make_wtitle8(buf_win, sht_win->bxsize, "OSAkkie", 1, 0);
						make_wtitle8(buf_cons, sht_cons->bxsize, "Console", 0, 1);
						cursor_c = -1;	/* OSAkkieJ[\OFF */
						boxfill8(sht_win->buf, sht_win->bxsize, COL8_FFFFFF, cursor_x, 43, cursor_x + 7, 43);
						fifo32_put(&task_cons->fifo, 2);	/* R\[ON */
					} else {
						key_to = 0;
						make_wtitle8(buf_win, sht_win->bxsize, "OSAkkie", 1, 1);
						make_wtitle8(buf_cons, sht_cons->bxsize, "Console", 0, 0);
						cursor_c = COL8_000000;	/* OSAkkieJ[\ON */
						fifo32_put(&task_cons->fifo, 3);	/* R\[OFF */
					}
					sheet_refresh(sht_win,  0, 0, sht_win->bxsize,  21);
					sheet_refresh(sht_cons, 0, 0, sht_cons->bxsize, 21);
				}
				if (i == 0x2a)
					key_shift |= 1;		// Vtgon
				if (i == 0x36)
					key_shift |= 2;		// EVtgon
				if (i == 0xaa)
					key_shift &= ~1;	// Vtgoff
				if (i == 0xb6)
					key_shift &= ~2;	// EVtgoff
				if (i == 0x3a) {
					/* CapsLock */
					key_leds ^= 4;
					fifo32_put(&keycmd, KEYCMD_LED);
					fifo32_put(&keycmd, key_leds);
				}
				if (i == 0x45) {
					/* NumLock */
					key_leds ^= 2;
					fifo32_put(&keycmd, KEYCMD_LED);
					fifo32_put(&keycmd, key_leds);
				}
				if (i == 0x46) {
					/* ScrollLock */
					key_leds ^= 1;
					fifo32_put(&keycmd, KEYCMD_LED);
					fifo32_put(&keycmd, key_leds);
				}
				if (i == 0xfa) {
					/* L[{[hf[^󂯎 */
					keycmd_wait = -1;
				}
				if (i == 0xfe) {
					/* L[{[hf[^󂯎Ȃ */
					wait_KBC_sendready();
					io_out8(PORT_KEYDAT, keycmd_wait);
				}
				if (cursor_c >= 0) {
					boxfill8(sht_win->buf, sht_win->bxsize, cursor_c, cursor_x, 43, cursor_x + 7, 43);
				}
				sheet_refresh(sht_win, cursor_x, 43, cursor_x + 8, 44);
			} else if (512 <= i && i < 768) {
				/* }EX */
				if (mouse_decode(&mdec, i - 512)) {
					/* }EXړ */
					mx += mdec.x;
					my += mdec.y;
					if (mx < 0)
						mx = 0;
					if (my < 0)
						my = 0;
					if (mx > binfo->scrnx - 1)
						mx = binfo->scrnx - 1;
					if (my > binfo->scrny - 1)
						my = binfo->scrny - 1;
					sheet_slide(sht_mouse, mx, my);
					if (mdec.btn & 0x01) {
						sheet_slide(sht_win, mx - 80, my - 8);
					}
				}
			} else if (i <= 1) {
				/* J[\p */
				if (i) {
					timer_init(timer, &fifo, 0);	/* 0 */
					if (cursor_c >= 0)
						cursor_c = COL8_000000;
				} else {
					timer_init(timer, &fifo, 1);	/* 1 */
					if (cursor_c >= 0)
						cursor_c = COL8_FFFFFF;
				}
				timer_settime(timer, 50);
				if (cursor_c >= 0) {
					boxfill8(buf_win, sht_win->bxsize, cursor_c, cursor_x, 43, cursor_x + 7, 43);
					sheet_refresh(sht_win, cursor_x, 43, cursor_x + 8, 44);
				}
			}
		}
	}
}
