/* bootpack̃C */

#include "bootpack.h"
#include <stdio.h>

static unsigned char osakkielogo[3] = {0x80, 0x81, '\0'};

void console_task(struct SHEET *sheet);
void make_window8(unsigned char *buf, int xsize, int ysize, char *title, char act);
void make_wtitle8(unsigned char *buf, int xsize, char *title, char act);
void make_textbox8(struct SHEET *sht, int x0, int y0, int sx, int sy, int c);
void putfonts8_asc_sht(struct SHEET *sht, int x, int y, int c, int b, char *s, int l);

void HariMain(void)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	struct FIFO32 fifo;
	char s[40];
	int fifobuf[128], mx, my, i, cursor_x, cursor_c;
	struct TIMER *timer;
	unsigned int memtotal;
	struct MOUSE_DEC mdec;
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct SHTCTL *shtctl;
	struct SHEET *sht_back, *sht_mouse, *sht_win, *sht_cons;
	unsigned char *buf_back, buf_mouse[256], *buf_win, *buf_cons;
	static char keytable[0x54] = {
		0,   0,   '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '^', 0,   0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '@', '[', 0,   0,   'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', ';', ':', 0,   0,   ']', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', ',', '.', '/', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.'
	};
	struct TASK *task_a, *task_cons;
	int key_to = 0;

/*
	static char font_mini_A[12] = {
		0x00, 0x30, 0x30, 0x48, 0x48, 0x48,
		0x48, 0x78,	0x48, 0x48, 0x48, 0x00
	};
*/

	init_gdtidt();
	init_pic();
	io_sti(); /* IDT/PIC̏ÎCPŮ荞݋֎~ */
	fifo32_init(&fifo, 128, fifobuf, 0);
	init_pit();
	init_keyboard(&fifo, 256);
	enable_mouse(&fifo, 512, &mdec);
	io_out8(PIC0_IMR, 0xf8); /* PITPIC1ƃL[{[h(11111000) */
	io_out8(PIC1_IMR, 0xef); /* }EX(11101111) */


	memtotal = memtest(0x00400000,0xbfffffff);
	memman_init(memman);
	memman_free(memman, 0x00001000, 0x0009e000); /*	0x00001000 - 0x0009efff */
	memman_free(memman, 0x00400000, memtotal - 0x00400000);

	init_palette();
	shtctl = shtctl_init(memman, binfo->vram, binfo->scrnx, binfo->scrny);
	task_a = task_init(memman);
	fifo.task = task_a;
	task_run(task_a, 1, 0);

	/* sht_back */
	sht_back  = sheet_alloc(shtctl);
	buf_back  = (unsigned char *) memman_alloc_4k(memman, binfo->scrnx * binfo->scrny);
	sheet_setbuf(sht_back,  buf_back,  binfo->scrnx, binfo->scrny, -1);	/* FȂ */
	init_screen8(buf_back, binfo->scrnx, binfo->scrny);

	/* sht_cons */
	sht_cons = sheet_alloc(shtctl);
	buf_cons = (unsigned char *) memman_alloc_4k(memman, 256 * 165);
	sheet_setbuf(sht_cons, buf_cons, 256, 165, -1);	/* FȂ */
	make_window8(buf_cons, 256, 165, "Console", 0);
	make_textbox8(sht_cons, 8, 28, 240, 128, COL8_000000);
	task_cons = task_alloc();
	task_cons->tss.esp = memman_alloc_4k(memman, 64 * 1024) + 64 * 1024 - 8;
	task_cons->tss.eip = (int) &console_task;
	task_cons->tss.es = 1 * 8;
	task_cons->tss.cs = 2 * 8;
	task_cons->tss.ss = 1 * 8;
	task_cons->tss.ds = 1 * 8;
	task_cons->tss.fs = 1 * 8;
	task_cons->tss.gs = 1 * 8;
	*((int *) (task_cons->tss.esp + 4)) = (int) sht_cons;
	task_run(task_cons, 2, 2);

	/* sht_win */
	sht_win = sheet_alloc(shtctl);
	buf_win = (unsigned char *) memman_alloc_4k(memman, 160 * 52);
	sheet_setbuf(sht_win,   buf_win,   160, 52, -1);	/* FȂ */
	make_window8(buf_win, 160, 52, "OSAkkie", 1);
	make_textbox8(sht_win, 8, 28, 144, 16, COL8_FFFFFF);
	cursor_x = 8;
	cursor_c = COL8_FFFFFF;
	timer = timer_alloc();
	timer_init(timer, &fifo, 1);
	timer_settime(timer, 50);

	/* sht_mouse */
	sht_mouse = sheet_alloc(shtctl);
	sheet_setbuf(sht_mouse, buf_mouse, 16,  16, 99);	/* Fԍ99 */
	init_mouse_cursor8(buf_mouse, 99/* wiF */);
	mx = (binfo->scrnx - 16) / 2; /* ʒɂȂ悤ɍWvZ */
	my = (binfo->scrny - 16) / 2;

	sheet_slide(sht_back,    0,  0);
	sheet_slide(sht_cons,   32,  4);
	sheet_slide(sht_win,    64, 56);
	sheet_slide(sht_mouse,  mx, my);
	sheet_updown(sht_back,  0);
	sheet_updown(sht_cons,  1);
	sheet_updown(sht_win,   2);
	sheet_updown(sht_mouse, 3);

	sprintf(s, "(%3d, %3d)", mx, my);
	putfonts8_asc_sht(sht_back, 0, 0, COL8_FFFFFF, COL8_3A6EA5, s, 10);
	sprintf(s, "Memory: %dKB   Free: %dKB", memtotal / 1000, memman_total(memman) / 1024);
	putfonts8_asc_sht(sht_back, 0, 32, COL8_FFFFFF, COL8_3A6EA5, s, 40);

	for (;;) {
		io_cli();
		if (fifo32_status(&fifo) == 0) {
			task_sleep(task_a);
			io_sti();
		} else {
			i = fifo32_get(&fifo);
			io_sti();
			if (256 <= i && i < 512) {
				/* L[{[h */
				i -= 256;	// ɈƂ
				sprintf(s, "%02X", i);
				putfonts8_asc_sht(sht_back, 0, 16, COL8_FFFFFF, COL8_3A6EA5, s, 2);
				if (i < 0x54) {
					if (keytable[i] && cursor_x < 144) {
						s[0] = keytable[i];
						s[1] = 0;
						putfonts8_asc_sht(sht_win, cursor_x, 28, COL8_000000, COL8_FFFFFF, s, 1);
						cursor_x += 8;
					}
				}
				if (i == 0x0e && cursor_x > 8) {
					/* obNXy[X */
					cursor_x -= 8;
					putfonts8_asc_sht(sht_win, cursor_x, 28, COL8_000000, COL8_FFFFFF, "  ", 2);
				}
				if (i == 0x0f) {
					/* Tab */
					if (key_to == 0) {
						key_to = 1;
						make_wtitle8(buf_win, sht_win->bxsize, "OSAkkie", 0);
						make_wtitle8(buf_cons, sht_cons->bxsize, "Console", 1);
					} else {
						key_to = 0;
						make_wtitle8(buf_win, sht_win->bxsize, "OSAkkie", 1);
						make_wtitle8(buf_cons, sht_cons->bxsize, "Console", 0);
					}
					sheet_refresh(sht_win,  0, 0, sht_win->bxsize,  21);
					sheet_refresh(sht_cons, 0, 0, sht_cons->bxsize, 21);
				}
				boxfill8(buf_win, sht_win->bxsize, cursor_c, cursor_x, 43, cursor_x + 7, 43);
				sheet_refresh(sht_win, cursor_x, 43, cursor_x + 8, 44);
			} else if (512 <= i && i < 768) {
				/* }EX */
				if (mouse_decode(&mdec, i - 512)) {
					sprintf(s, "[lcr %4d %4d]", mdec.x, mdec.y);
					if (mdec.btn & 0x01)
						s[1] = 'L';
					if (mdec.btn & 0x02)
						s[3] = 'R';
					if (mdec.btn & 0x04)
						s[2] = 'C';
					putfonts8_asc_sht(sht_back, 32, 16, COL8_FFFFFF, COL8_3A6EA5, s, 15);
					/* }EXړ */
					mx += mdec.x;
					my += mdec.y;
					if (mx < 0)
						mx = 0;
					if (my < 0)
						my = 0;
					if (mx > binfo->scrnx - 1)
						mx = binfo->scrnx - 1;
					if (my > binfo->scrny - 1)
						my = binfo->scrny - 1;
					sprintf(s, "(%3d, %3d)", mx, my);
					putfonts8_asc_sht(sht_back, 0, 0, COL8_FFFFFF, COL8_3A6EA5, s, 10);
					sheet_slide(sht_mouse, mx, my);
					if (mdec.btn & 0x01) {
						sheet_slide(sht_win, mx - 80, my - 8);
					}
				}
			} else if (i <= 1) {
				/* J[\p */
				if (i) {
					timer_init(timer, &fifo, 0);	/* 0 */
					cursor_c = COL8_000000;
				} else {
					timer_init(timer, &fifo, 1);	/* 1 */
					cursor_c = COL8_FFFFFF;
				}
				timer_settime(timer, 50);
				boxfill8(buf_win, sht_win->bxsize, cursor_c, cursor_x, 43, cursor_x + 7, 43);
				sheet_refresh(sht_win, cursor_x, 43, cursor_x + 8, 44);
			}
		}
	}
}


void console_task(struct SHEET *sheet)
{
	struct FIFO32 fifo;
	struct TIMER *timer;
	struct TASK *task = task_now();

	int i, fifobuf[128], cursor_x = 8, cursor_c = COL8_000000;
	fifo32_init(&fifo, 128, fifobuf, task);

	timer = timer_alloc();
	timer_init(timer, &fifo, 1);
	timer_settime(timer, 50);

	for (;;) {
		io_cli();
		if (fifo32_status(&fifo) == 0) {
			task_sleep(task);
			io_sti();
		} else {
			i = fifo32_get(&fifo);
			io_sti();
			if (i <= 1) {
				/* J[\p */
				if (i) {
					timer_init(timer, &fifo, 0);
					cursor_c = COL8_FFFFFF;
				} else {
					timer_init(timer, &fifo, 1);
					cursor_c = COL8_000000;
					
				}
				timer_settime(timer, 50);
				boxfill8(sheet->buf, sheet->bxsize, cursor_c, cursor_x, 43, cursor_x + 7, 43);
				sheet_refresh(sheet, cursor_x, 43, cursor_x + 8, 44);
			}
		}
	}
}


void make_window8(unsigned char *buf, int xsize, int ysize, char *title, char act)
{
	boxfill8(buf, xsize, COL8_C6C6C6, 0      , 0      , xsize-2, 0      );	// 㔖DF
	boxfill8(buf, xsize, COL8_C6C6C6, 0      , 0      , 0,       ysize-2);	// DF
	boxfill8(buf, xsize, COL8_FFFFFF, 1      , 1      , xsize-2, 1      );	// 㔒F
	boxfill8(buf, xsize, COL8_FFFFFF, 1      , 1      , 1,       ysize-2);	// F
	boxfill8(buf, xsize, COL8_C6C6C6, 2      , 2      , xsize-3, ysize-3);	// DFiEBhE{́j
	boxfill8(buf, xsize, COL8_848484, xsize-2, 1      , xsize-2, ysize-2);	// EZDF
	boxfill8(buf, xsize, COL8_848484, 1      , ysize-2, xsize-2, ysize-2);	// ZDF
	boxfill8(buf, xsize, COL8_000000, xsize-1, 0      , xsize-1, ysize-1);	// EF
	boxfill8(buf, xsize, COL8_000000, 0      , ysize-1, xsize-1, ysize-1);	// F
	make_wtitle8(buf, xsize, title, act);
	return;
}

void make_wtitle8(unsigned char *buf, int xsize, char *title, char act)
{
	static unsigned char closebtn[14 * 15] = {
		0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x07,0x07,0x11,0x11,0x11,0x07,0x07,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x07,0x07,0x11,0x07,0x07,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x07,0x07,0x07,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x07,0x07,0x07,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x07,0x07,0x11,0x07,0x07,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x07,0x07,0x11,0x11,0x11,0x07,0x07,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07
	};
	char tc, tbc;

	if (act) {
		tc  = COL8_FFFFFF;
		tbc = COL8_0080FF;
	} else {
		tc  = COL8_C6C6C6;
		tbc = COL8_848484;
	}
	boxfill8(buf, xsize, tbc,         3      , 3      , xsize-4, 20);	// ^Cgo[

	putfonts8_asc(buf, xsize,  8, 4, tc, osakkielogo);
	putfonts8_asc(buf, xsize, 24, 4, tc, title);
	picdata8(buf, xsize, closebtn, 15, 14, COL8_0080FF, xsize - 20, 5);

	return;
}

void make_textbox8(struct SHEET *sht, int x0, int y0, int sx, int sy, int c)
{
	int x1 = x0 + sx, y1 = y0 + sy;

	boxfill8(sht->buf, sht->bxsize, COL8_848484, x0 - 2, y0 - 3, x1 + 1, y0 - 3);
	boxfill8(sht->buf, sht->bxsize, COL8_848484, x0 - 3, y0 - 3, x0 - 3, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, COL8_FFFFFF, x0 - 3, y1 + 2, x1 + 1, y1 + 2);
	boxfill8(sht->buf, sht->bxsize, COL8_FFFFFF, x1 + 2, y0 - 3, x1 + 2, y1 + 2);
	boxfill8(sht->buf, sht->bxsize, COL8_000000, x0 - 1, y0 - 2, x1 + 0, y0 - 2);
	boxfill8(sht->buf, sht->bxsize, COL8_000000, x0 - 2, y0 - 2, x0 - 2, y1 + 0);
	boxfill8(sht->buf, sht->bxsize, COL8_C6C6C6, x0 - 2, y1 + 1, x1 + 0, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, COL8_C6C6C6, x1 + 1, y0 - 2, x1 + 1, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, c,           x0 - 1, y0 - 1, x1 + 0, y1 + 0);

	return;
}

void putfonts8_asc_sht(struct SHEET *sht, int x, int y, int c, int b, char *s, int l)
{
	boxfill8(sht->buf, sht->bxsize, b, x, y, x + l * 8 - 1, y + 15);
	putfonts8_asc(sht->buf, sht->bxsize, x, y, c, s);
	sheet_refresh(sht, x, y, x + l * 8, y + 16);
}
