using System;
using System.IO;
using System.Diagnostics;
using RVII;

namespace MortalRoar
{
    public class MyGame
    {
        static void Main(string[] args)
        {
            Trace.Listeners.Add(new TextWriterTraceListener(File.Create("MortalRoar.log")));
            Trace.WriteLine(DateTime.Now.ToString());
            try {
                RVIIManager app = new RVIIManager(null);
                try {
                    app.Fire();
                } finally {
                    app.Extinguisher();
                }
            } catch (Exception ex) {
                Trace.WriteLine(ex.ToString());
            } finally {
                Trace.WriteLine(DateTime.Now.ToString());
                Trace.Flush();
            }
        }
    }
}
