package jp.ifrog.genbuframework.xml.generator;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;

import farm.example.Util;

public class XmlConvertorGeneratorTest {

	private static File _tmpFile;
	
	@BeforeClass
	public static void setUpBeforeClass() throws FileNotFoundException, IOException {
		Util.setUp();
		_tmpFile = new File("res/test/tmp");
		_tmpFile.delete();
	}
	
	@After
	public void tearDown() {
		_tmpFile.delete();
	}
	
	@Test(timeout=1000)
	public void testOutputSameFile1() throws Exception {
		XmlConvertorGenerator.generateJavaFile(
				"farm.example.car.Car", 
				"res/tmpl/XmlConvertor.vm",
				_tmpFile.getPath());
		assertTrue(Util.fileContentCompare("res/test/CarXmlConvertor.java", _tmpFile.getPath()));
	}
	
	@Test(timeout=1000)
	public void testOutputSameFile2() throws Exception {
		XmlConvertorGenerator.generateJavaFile(
				"farm.example.car.Car", 
				"res/tmpl/Parser.vm",
				_tmpFile.getPath());		
		assertTrue(Util.fileContentCompare("res/test/CarParser.java", _tmpFile.getPath()));
	}

	@Test(timeout=1000)
	public void testOutputSameFile3() throws Exception {
		XmlConvertorGenerator.generateJavaFile(
				"farm.example.car.Car", 
				"res/tmpl/ConvertParseCycleTest.vm",
				_tmpFile.getPath());		
		assertTrue(Util.fileContentCompare("res/test/CarConvertParseCycleTest.java", _tmpFile.getPath()));
	}
	
	/** 
	 * 上書き設定のテスト。上書きするパターン。
	 * @throws Exception
	 */
	@Test
	public void testOverwrite1() throws Exception {
		_tmpFile.createNewFile();
		XmlConvertorGenerator.setProperty("force_overwrite", "true");
		XmlConvertorGenerator.generateJavaFile(
				"farm.example.car.Car", 
				"res/tmpl/ConvertParseCycleTest.vm",
				_tmpFile.getPath());	
		assertTrue(Util.fileContentCompare("res/test/CarConvertParseCycleTest.java", _tmpFile.getPath()));
	}
	
	/** 
	 * 上書き設定のテスト。上書きしないパターン。
	 * @throws Exception
	 */	
	@Test
	public void testOverwrite2() throws Exception {
		_tmpFile.createNewFile();
		XmlConvertorGenerator.setProperty("force_overwrite", "false");
		XmlConvertorGenerator.generateJavaFile(
				"farm.example.car.Car", 
				"res/tmpl/ConvertParseCycleTest.vm",
				_tmpFile.getPath());
		assertTrue(Util.fileContentCompare("res/test/no_contents", _tmpFile.getPath()));
	}
	
	@Test
	public void testIgnoreFields1() throws Exception {
		XmlConvertorGenerator.setProperty("ignore_fields", "");
		XmlConvertorGenerator.generateJavaFile(
				"farm.example.car.Car", 
				"res/tmpl/ConvertParseCycleTest.vm",
				_tmpFile.getPath());
		assertTrue(Util.fileContentCompare("res/test/CarConvertParseCycleTest.java", _tmpFile.getPath()));
	}
	
	@Test
	public void testIgnoreFields2() throws Exception {
		XmlConvertorGenerator.setProperty("ignore_fields", "transmission");
		XmlConvertorGenerator.generateJavaFile(
				"farm.example.car.Car", 
				"res/tmpl/ConvertParseCycleTest.vm", 
				_tmpFile.getPath());
		assertTrue(Util.fileContentCompare("res/test/CarConvertParseCycleTest2.java", _tmpFile.getPath()));
	}

	@Test
	public void testProperties() throws FileNotFoundException, IOException {
		Properties cfg = new Properties();
		cfg.load(new FileReader("res/test/test.properties"));
		
		assertEquals("bar",            cfg.getProperty("1"));// 正常系
		assertEquals("",               cfg.getProperty("2"));// 値なし
		assertEquals("Program Files",  cfg.getProperty("3"));// スペースを含む 
		assertEquals("beginsSpace",    cfg.getProperty("4"));// 先頭のスペースは省かれる
		assertEquals("hasSpaceAtEnd ", cfg.getProperty("5"));// おしりのスペースは残される
		assertEquals("SParoundEqual",  cfg.getProperty("6"));// = の前後のスペースは省かれる
		assertEquals("a=b",            cfg.getProperty("7"));// = が複数ある場合は2つ目以降の = はリテラルに扱われる
		assertEquals("SPatHead",       cfg.getProperty("8"));// 行頭のスペースは無視される
		assertEquals("おはよう",          cfg.getProperty("日本語"));// 日本語大丈夫
		assertEquals("スペースによる設定",  cfg.getProperty("9"));// スペースでkey と value を区切ることもできる。
		assertEquals("a = c",          cfg.getProperty("10"));// 紛らわしいがこうなる。
	}
	
	/** 正常系 */
	@Test
	public void testProperty100() throws Exception {
		String key = "ROCK";
		String value1 = "";
		String value2 = "SHOX";
		
		XmlConvertorGenerator.setProperty(key, value1);
		assertEquals(value1, XmlConvertorGenerator.getProperty(key));
		
		XmlConvertorGenerator.setProperty(key, value2);
		assertEquals(value2, XmlConvertorGenerator.getProperty(key));
	}

	/** 異常系(境界条件) */
	@Test
	public void testProperty101() throws Exception {
		String key = "";
		String value = null;
		
		assertEquals(value, XmlConvertorGenerator.getProperty(key));
	}
	
	/** 異常系(境界条件) */
	@Test(expected=IllegalArgumentException.class)
	public void testProperty201() throws Exception {
		String key = null;
		String value = "";
		
		XmlConvertorGenerator.setProperty(key, value);
		assertEquals(value, XmlConvertorGenerator.getProperty(key));
	}
	
	/** 異常系(境界条件) */
	@Test(expected=IllegalArgumentException.class)
	public void testProperty202() throws Exception {
		String key = "";
		String value = null;
		
		XmlConvertorGenerator.setProperty(key, value);
		assertEquals(value, XmlConvertorGenerator.getProperty(key));
	}
	

}
