package jp.ifrog.genbuframework.xml;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Map;

import org.junit.BeforeClass;
import org.junit.Test;

import farm.example.Util;


/**
 * 
 * @author yupong7@gmail.com
 *
 */
public class XmlConvertorGenesicTest {
	
	@BeforeClass
	public static void setUpBeforeClass() throws FileNotFoundException, IOException {
		Util.setUp();
	}
	
	/** 
	 * readable
	 */
	@Test
	public void testSetXMLDeclaration1() {
		XmlConvertorGenesic xmlcg =new XmlConvertorGenesic(true) {
			@Override
			public String convert() {
				setXMLDeclaration();
				return xml.toString();
			}
		};
		
		String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

		assertEquals(expected, xmlcg.convert());
	}
	
	/**
	 * unreadable
	 * この場合においても、 <XML>宣言の後には改行が入る。
	 */
	@Test
	public void testSetXMLDeclaration2() {
		XmlConvertorGenesic xmlcg =new XmlConvertorGenesic(false) {
			@Override
			public String convert() {
				setXMLDeclaration();
				return xml.toString();
			}
		};
		
		String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

		assertEquals(expected, xmlcg.convert());
	}

	@Test
	public void testSetOpenResultElement() {
		XmlConvertorGenesic xmlcg =new XmlConvertorGenesic(false) {
			@Override
			public String convert() {
				setOpenResultElement(132);
				return xml.toString();
			}
		};

		assertEquals("<result recs=\"132\">", xmlcg.convert());
	}

	@Test
	public void testSetOpenResponseElement() {
		XmlConvertorGenesic xmlcg =new XmlConvertorGenesic(false) {
			@Override
			public String convert() {
				setOpenResponseElement("403");
				return xml.toString();
			}
		};
		
		assertEquals("<response status=\"403\">", xmlcg.convert());
	}

	@Test
	public void testSetOpenElementString() {
		XmlConvertorGenesic xmlcg =new XmlConvertorGenesic(false) {
			@Override
			public String convert() {
				setOpenElement("TextView");
				return xml.toString();
			}
		};

		assertEquals("<TextView>", xmlcg.convert());
	}

	/**
	 * 要素数0
	 */
	@Test
	public void testSetOpenElementStringHashtable0() {
		XmlConvertorGenesic xmlcg =new XmlConvertorGenesic(false) {
			@Override
			public String convert() {
				Map<String, String> properties = new Hashtable<String, String>();
				setOpenElement("application", properties);
				return xml.toString();
			}
		};
		
		String expected = "<application>";
		
		String actual = xmlcg.convert();
		
		assertEquals(expected, actual);
	}
	
	/**
	 * 要素数1
	 */
	@Test
	public void testSetOpenElementStringHashtable1() {
		XmlConvertorGenesic xmlcg =new XmlConvertorGenesic(false) {
			@Override
			public String convert() {
				Map<String, String> properties = new Hashtable<String, String>();
				properties.put("name", "pink elephant");
				setOpenElement("application", properties);
				return xml.toString();
			}
		};
		
		String expected = "<application name=\"pink elephant\">";
		
		String actual = xmlcg.convert();
		
		assertEquals(expected, actual);
	}

	/**
	 * 要素数2
	 */
	@Test
	public void testSetOpenElementStringHashtable2() {
		XmlConvertorGenesic xmlcg =new XmlConvertorGenesic(false) {
			@Override
			public String convert() {
				Map<String, String> properties = new Hashtable<String, String>();
				properties.put("name", "pink elephant");
				properties.put("weight", "43kg");
				setOpenElement("application", properties);
				return xml.toString();
			}
		};
		
		// attribute は、 name と weight のどちらが先にくるかはわからない（と思う)。
		String expected1 = "<application name=\"pink elephant\" weight=\"43kg\">";
		String expected2 = "<application weight=\"43kg\" name=\"pink elephant\">";
		
		String actual = xmlcg.convert();
		
		assertTrue(expected1.equals(actual) || expected2.equals(actual));
	}

	/**
	 * 空要素
	 */
	@Test
	public void testSetElementEmpty() {
		XmlConvertorGenesic xmlcg =new XmlConvertorGenesic(false) {
			@Override
			public String convert() {
				setElement("song", "");
				return xml.toString();
			}
		};

		assertEquals("<song></song>", xmlcg.convert());
	}

	/**
	 * 非空要素
	 */
	@Test
	public void testSetElement() {
		XmlConvertorGenesic xmlcg =new XmlConvertorGenesic(false) {
			@Override
			public String convert() {
				setElement("song", "昭和枯れすすき");
				return xml.toString();
			}
		};

		assertEquals("<song>昭和枯れすすき</song>", xmlcg.convert());
	}
	
	@Test(expected=EmptyStackException.class)
	public void testSetCloseElement0() {
		XmlConvertorGenesic xmlcg =new XmlConvertorGenesic(false) {
			@Override
			public String convert() {
				setCloseElement();
				return xml.toString();
			}
		};

		xmlcg.convert();
	}
	
	@Test
	public void testSetCloseElement1() {
		XmlConvertorGenesic xmlcg =new XmlConvertorGenesic(false) {
			@Override
			public String convert() {
				setOpenElement("body");
				setCloseElement();
				return xml.toString();
			}
		};
		
		assertEquals("<body></body>", xmlcg.convert());
	}
	
	@Test
	public void testSetCloseElement2() {
		String expected = "<body>" +
                           "<ListView>" +
                           "</ListView>" +
                         "</body>";
		doTest(false, expected);
	}
	
	/** 
	 * XmpAppend が正しくインデントと改行を出力している
	 * ことをテスト
	 */
	@Test
	public void testXmlAppend() {
		String expected = "<body>\n" +
                         "\t<ListView>\n" +
                         "\t</ListView>\n" +
                         "</body>\n";
		doTest(true, expected);
	}
	
	
	public void doTest(boolean readable, String expected) {
		XmlConvertorGenesic xmlcg =new XmlConvertorGenesic(readable) {
			@Override
			public String convert() {
				setOpenElement("body");
				setOpenElement("ListView");
				setCloseElement();
				setCloseElement();
				return xml.toString();
			}
		};

		assertEquals(expected, xmlcg.convert());
	}
	
	
}
