package farm.example.dog;

import static org.junit.Assert.assertEquals;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

import org.junit.BeforeClass;
import org.junit.Test;

import farm.example.Util;

/**
 * 
 * @author yupong7@gmail.com
 *
 */
public class DogXmlConvertorTest {
	@BeforeClass
	public static void setUpBeforeClass() throws FileNotFoundException, IOException {
		Util.setUp();
	}
	
	/**
	 * readable
	 * 
	 * @throws IOException
	 */
	@Test
	public void testConvertReadable() throws IOException {
		DogXmlConvertor conv = new DogXmlConvertor(true);
		conv.setDogs(createDogs());

		assertEquals(conv.convert(), Util.getFileContent("res/test/sample.xml"));
	}
	
	/**
	 * un readable
	 * 
	 * @throws IOException
	 */
	@Test
	public void testConvertUnReadable() throws IOException {
		DogXmlConvertor conv = new DogXmlConvertor(false);
		conv.setDogs(createDogs());

		assertEquals(conv.convert(), Util.getFileContent("res/test/sample2.xml"));
	}

	private List<Dog> createDogs() {
		List<Dog> dogs = new Vector<Dog>();
		dogs.add(new Dog("柴犬","タロウ",12));
		dogs.add(new Dog("シェパード","次郎",2));
		return dogs;
	}

}
