package farm.example.dog;

import static org.junit.Assert.*;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

import org.junit.BeforeClass;
import org.junit.Test;

import farm.example.Util;

/**
 * 
 * @author yupong7@gmail.com
 *
 */
public class DogTest {

	/**
	 * TestSuite の中で一番最初に一度だけ呼び出される
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws FileNotFoundException, IOException {
		Util.setUp();
	}
	
	@Test
	public void testDog() {
		String type = "柴犬";
		String name = "太郎";
		int age = 13;
		Dog dog = new Dog(type, name, age);
		
		assertEquals(type, dog.getType());
		assertEquals(name, dog.getName());
		assertEquals(age, dog.getAge());
	}
	
	@Test
	public void testToString() {
		Dog dog = new Dog("シベリアンハスキー", "スフレ", 60);
		assertEquals("Dog: (type,name,age)=(シベリアンハスキー,スフレ,60)", dog.toString());
	}
	
	@Test
	public void getOlder() {
		Dog dog = new Dog("ブーヴィエ・デ・フランドル", "パトラッシュ", 3);
		dog.getOlder();
		assertEquals(4, dog.getAge());
	}
	
	@Test
	public void testClone() throws CloneNotSupportedException {
		Dog src = new Dog("パグ", "ショコラ", 41);
		Dog clone = (Dog) src.clone();
		assertNotSame(src, clone);
		assertEquals(src, clone);
	}
	
	@Test
	public void testEqualsReturnTrue() {
		Dog src = new Dog("狛犬", "カプチーノ", 16);
		Dog dst = new Dog("狛犬", "カプチーノ", 16);
		assertNotSame(src, dst);
		assertEquals(src, dst);
	}
	
	@Test
	public void testEqualsReturnFalse() {
		Dog src = new Dog(",", "", 16);
		Dog dst = new Dog("", ",", 16);
		// Dog#equals() の旧実装ではエラーになっていた。
		assertFalse(src.equals(dst));
	}
	
	/**
	 *  空の ListofDogs の比較
	 * @throws CloneNotSupportedException
	 */
	@Test
	public void testEmptyListofDog() throws CloneNotSupportedException {
		List<Dog> src = new Vector<Dog>();
		List<Dog> dst = new Vector<Dog>();
		
		assertNotSame(src, dst);
		assertEquals(src, dst);
	}
	
	/**
	 * 要素数の違う List の比較
	 * @throws CloneNotSupportedException
	 */
	@Test
	public void testListofDog() throws CloneNotSupportedException {
		List<Dog> src = new Vector<Dog>();
		List<Dog> dst = new Vector<Dog>();
		 
		src.add(new Dog("チャウチャウ", "獅子丸", 3));
		
		assertNotSame(src, dst);
		assertFalse(src.equals(dst));
	}
	
	/**
	 * 同じ内容の要素をもつ List の比較
	 * @throws CloneNotSupportedException
	 */
	@Test
	public void testEqualListofDogEquals() throws CloneNotSupportedException {		
		List<Dog> src = new Vector<Dog>();
		List<Dog> dst = new Vector<Dog>();
		
		Dog dog = new Dog("チャウチャウ", "獅子丸", 3);
		src.add(dog);
		dst.add((Dog)dog.clone());
		
		assertEquals(src, dst);
		assertNotSame(src,dst);
	}
	
	/**
	 * 異なる内容の要素をもつ List の比較
	 * @throws CloneNotSupportedException
	 */
	@Test
	public void testNotEqualListofDogEquals() throws CloneNotSupportedException {
		List<Dog> src = new Vector<Dog>();
		List<Dog> dst = new Vector<Dog>();

		Dog dog = new Dog("チャウチャウ", "獅子丸", 3);
		Dog dog2 = (Dog)dog.clone();
		dog2.getOlder();
		dst.add(dog2);	
		
		assertNotSame(src, dst);
		assertFalse(src.equals(dst));
	}
	

}
