package farm.example.dog;

import static org.junit.Assert.assertEquals;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.junit.BeforeClass;
import org.junit.Test;
import org.xml.sax.SAXException;

import farm.example.Util;

/**
 * 
 * @author yupong7@gmail.com
 *
 */
public class DogParserTest {
	
	@BeforeClass
	public static void setUpBeforeClass() throws FileNotFoundException, IOException {;
		Util.setUp();
	}

	public static String parse(String path) {
		StringBuffer ret = new StringBuffer();
		File f = new File(path);

		SAXParserFactory spfactory = SAXParserFactory.newInstance();
		SAXParser parser;
		try {
			parser = spfactory.newSAXParser();

			List<Dog> dogs = new Vector<Dog>();
			DogParser g = new DogParser(dogs);
			parser.parse(f, g);

			for (Iterator<Dog> e = dogs.iterator(); e.hasNext();) {
				ret.append(e.next());
			}
		} catch (ParserConfigurationException e1) {
			e1.printStackTrace();
		} catch (SAXException e1) {
			e1.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return ret.toString();
	}

	@Test
	public void test0() {
		// 一つも dog 要素を持たない
		assertEquals("", parse("res/test/dog_0.xml"));
	}

	@Test
	public void test1() {
		// 一つの 標準的な dog 要素のテスト
		assertEquals("Dog: (type,name,age)=(カラ\nフト犬,タロー,0)", parse("res/test/dog_1.xml"));
	}

	@Test
	public void test2() {
		// 1つのdog 要素のテスト、type, name, age とも空要素である。
		assertEquals("Dog: (type,name,age)=(,,0)", parse("res/test/dog_2.xml"));
	}

	@Test
	public void test3() {
		// 1つのdog 要素のテスト、子要素 type, name, age ともに含まない
		assertEquals("Dog: (type,name,age)=(null,null,0)", parse("res/test/dog_3.xml"));
	}
	
	@Test
	public void test4() {
		// 2つのgreeting 要素のテスト
		assertEquals("Dog: (type,name,age)=(null,null,0)Dog: (type,name,age)=(秋田犬,ジロー,1)", 
				parse("res/test/dog_4.xml"));
	}
}
