package farm.example.dog;

import static org.junit.Assert.assertEquals;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xml.sax.SAXException;

import farm.example.Util;

/**
 * Dog オブジェクトのリストから、 XML を作る。
 * その XML から Dog オブジェクトのリストを作る。
 * 前後の Dog オブジェクトを比較して一致することを
 * テストする。
 * 
 * @author yupong7@gmail.com
 *
 */
public class DogConvertParseCycleTest {
	
	private DogXmlConvertor _xmlcg;
	
	@BeforeClass
	public static void setUpBeforeClass() throws FileNotFoundException, IOException {
		Util.setUp();
	}
	
	@Before
	public void setUp() throws Exception {
		_xmlcg = new DogXmlConvertor(true);
	}
	
	public static List<Dog> parse(String xml) {
		List<Dog> ret = new Vector<Dog>();

		try {
			SAXParserFactory spfactory = SAXParserFactory.newInstance();
			SAXParser parser = spfactory.newSAXParser();
			
			DogParser g = new DogParser(ret);
			parser.parse(new ByteArrayInputStream(xml.getBytes()), g);
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return ret;
	}
	
	/**
	 * 空の dog list
	 */
	@Test
	public void testCharacters1() {
		List<Dog> srcDogs = new Vector<Dog>();
		
		_xmlcg.setDogs(srcDogs);
		List<Dog> dogs = parse(_xmlcg.convert());
		
		assertEquals(srcDogs, dogs);
	}
	
	/**
	 * 一つの dog list
	 */
	@Test
	public void testCharacters() {
		List<Dog> srcDogs = new Vector<Dog>();
		Dog dog = new Dog();
		dog.setType(Util.getRandStr());
		dog.setName(Util.getRandStr());
		dog.setAge(Util.getRandInt());
		srcDogs.add(dog);
		_xmlcg.setDogs(srcDogs);
		List<Dog> dogs = parse(_xmlcg.convert());
		
		assertEquals(srcDogs, dogs);
	}

	/**
	 * 複数の dog list
	 */
	@Test
	public void testDogParser() {
		List<Dog> srcDogs = new Vector<Dog>();
		Dog dog;

		dog = new Dog();
		dog.setType(Util.getRandStr());
		dog.setName(Util.getRandStr());
		dog.setAge(Util.getRandInt());
		srcDogs.add(dog);
		
		dog = new Dog();
		dog.setType(Util.getRandStr());
		dog.setName(Util.getRandStr());
		dog.setAge(Util.getRandInt());
		srcDogs.add(dog);
		
		dog = new Dog();
		dog.setType(Util.getRandStr());
		dog.setName(Util.getRandStr());
		dog.setAge(Util.getRandInt());
		srcDogs.add(dog);
		
		_xmlcg.setDogs(srcDogs);
		List<Dog> dogs = parse(_xmlcg.convert());
		
		assertEquals(srcDogs,dogs);
	}
}
