package farm.example;

import static org.junit.Assert.*;

import java.io.FileNotFoundException;
import java.io.IOException;

import org.junit.BeforeClass;
import org.junit.Test;

public class UtilTest {
	@BeforeClass
	public static void setUpBeforeClass() throws FileNotFoundException, IOException {
		Util.setUp();
	}

	@Test
	public void testGetInitalLowerCase() {		
		assertEquals("", Util.getInitalLowerCase(""));
		assertEquals("a", Util.getInitalLowerCase("A"));
		assertEquals("a", Util.getInitalLowerCase("a"));
		assertEquals("car", Util.getInitalLowerCase("Car"));
	}

	@Test
	public void testGetInitalUpperCase() {
		assertEquals("", Util.getInitalUpperCase(""));
		assertEquals("A", Util.getInitalUpperCase("A"));
		assertEquals("A", Util.getInitalUpperCase("a"));
		assertEquals("Car", Util.getInitalUpperCase("car"));
	}
	
	/** 
	 * fileContentCompre() の正常パターン 
	 */
	@Test
	public void test1FileContentCompare() throws IOException {
		assertTrue(Util.fileContentCompare("res/test/same_content1", "res/test/same_content2"));
		assertTrue(!Util.fileContentCompare("README", "VERSION"));
		assertTrue(!Util.fileContentCompare("VERSION", "README"));
	}
	/** 
	 * fileContentCompre() の境界条件正常パターン 
	 * 指定された一つ以上のファイルの内容が空である。
	 */
	@Test
	public void test2FileContentCompare() throws IOException {
		assertTrue(Util.fileContentCompare("res/test/no_contents", "res/test/no_contents"));
		assertTrue(!Util.fileContentCompare("res/test/no_contents", "README"));
		assertTrue(!Util.fileContentCompare("README", "res/test/no_contents"));
	}
	/**
	 * 指定されたファイルが存在しない。path1
	 * @throws IOException
	 */
	@Test(expected=FileNotFoundException.class)
	public void test3FileContentCompare() throws IOException {
		assertTrue(Util.fileContentCompare("", "res/system.properties"));
	}
	
	/**
	 * 指定されたファイルが存在しない。path2
	 * @throws IOException
	 */
	@Test(expected=FileNotFoundException.class)
	public void test4FileContentCompare() throws IOException {
		assertTrue(Util.fileContentCompare("res/system.properties", ""));
	}
	
	/**
	 * 指定されたファイルが存在しない。path1, path2
	 * @throws IOException
	 */
	@Test(expected=FileNotFoundException.class)
	public void test5FileContentCompare() throws IOException {
		assertTrue(Util.fileContentCompare("", ""));
	}
	
	@Test
	public void testGetFileContent() throws IOException {
		String expected = "やってみせて、言って聞かせて、やらせてみて、 ほめてやらねば人は動かじ。\n山本 五十六\n";

		assertEquals(expected, Util.getFileContent("res/test/same_content1"));
	}
	
	@Test
	public void testGetFileContentNoContent() throws IOException {
		String expected = "";

		assertEquals(expected, Util.getFileContent("res/test/no_contents"));
	}
	
	@Test
	public void testGetRandStr() {
		// これ以外のテストは思いつかない。
		assertNotNull(Util.getRandStr());	
	}
	
	@Test
	public void testGetRandInt() {
		// テストのしようがない。
		Util.getRandInt();
	}
}
