package farm.example;

import java.io.FileNotFoundException;
import java.io.IOException;

import jp.ifrog.genbuframework.xml.XmlConvertorGenesicTest;
import jp.ifrog.genbuframework.xml.generator.MyClassTest;
import jp.ifrog.genbuframework.xml.generator.MyFieldTest;
import jp.ifrog.genbuframework.xml.generator.XmlConvertorGeneratorTest;

import org.junit.BeforeClass;
import org.junit.runner.JUnitCore;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.junit.runners.Suite.SuiteClasses;

import farm.example.dog.DogConvertParseCycleTest;
import farm.example.dog.DogParserTest;
import farm.example.dog.DogTest;
import farm.example.dog.DogXmlConvertorTest;

/**
 * すべての JUnit テストケースを一括で実行するためのクラス。
 * 
 * @author yupong7@gmail.com
 */
@RunWith(Suite.class)                                    
@SuiteClasses( { 
	//AllTests.class,
	/* farm.example                          */ 
	UtilTest.class,                 
	/* farm.exmaple.dog                      */ 
	DogConvertParseCycleTest.class, DogParserTest.class, DogTest.class, DogXmlConvertorTest.class, 
	/* jp.ifrog.genbuframework.xml           */ 
	XmlConvertorGenesicTest.class,
	/* jp.ifrog.genbuframework.xml.generator */ 
	MyFieldTest.class, MyClassTest.class, XmlConvertorGeneratorTest.class 
})
public class AllTests {
	@BeforeClass
	public static void setUpBeforeClass() throws FileNotFoundException, IOException {
		Util.setUp();
	}
	
	public static void main(String[] args) throws FileNotFoundException, IOException {
		JUnitCore.main(AllTests.class.getName());
	}
}
