package jp.ifrog.genbuframework.xml.generator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;

import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

/**
 * 指定したデータ格納クラス（Bean)に応じたClass ファイルを生成する
 * 
 * @author tatsuya
 * @author yupong7@gmail.com
 */
public class XmlConvertorGenerator {
	
	/** configuration properties */
	protected static Properties _cfg;
	
	private static Logger _log = Logger.getLogger(XmlConvertorGenerator.class.getName());

	/**
	 * 
	 * @param targetClass
	 * @param tmplPath
	 * @param outputPath
	 * @throws Exception
	 */
	public static void generateJavaFile(String targetClass, String tmplPath, String outputPath) 
		throws Exception {
		List<MyField> fields = loadFieldNames(targetClass);
		
		File file = new File(outputPath);
		
		if("true".equals(_cfg.getProperty("force_overwrite")) || !file.exists() ) {
			Writer out = new FileWriter(file);
			writeMergedThing(out, fields, tmplPath);
			out.close();
		}	
	}

	/**
	 * 自動生成対象のフィールドを取得する
	 * 
	 * @return フィールド名がListに直列化されたオブジェクト
	 * @throws Exception
	 */
	protected static List<MyField> loadFieldNames(String targetClass) throws Exception {
		List<MyField> ret = new Vector<MyField>();

		List<String> ignoreFieldNames = generateIgnoreFieldNames(_cfg.getProperty("ignore_fields"));
		
		// Reflection を利用して Fields を取得する。
		Class<?> clazz = Class.forName(targetClass);
		Field[] fields = clazz.getDeclaredFields();
		for(Field field : fields) {
			if(!ignoreFieldNames.contains(field.getName())){
				ret.add(new MyField(field));
			}
		}		
		
		return ret;
	}
	
	/**
	 * 無視する Field Name の List を生成する。
	 * @return ignoreFields
	 */
	private static List<String> generateIgnoreFieldNames(String ignoreFields) {
		List<String> ret = new Vector<String>();
		
		for(String fieldName : ignoreFields.split(",")) {
			ret.add(fieldName);
			_log.config(fieldName);
		}
	
		return ret;
	}
	
	/**
	 * 
	 * @param out
	 * @param fields
	 * @param templateFile
	 */
	private static void writeMergedThing(Writer out,List<MyField> fields, String templateFile) {
		try {
			Velocity.init();
			VelocityContext context = new VelocityContext();
			
			MyClass clazz = fields.get(0).getDeclaringMyClass();
			context.put("clazz", clazz);
			context.put("fields", fields);			

			Template template = Velocity.getTemplate(templateFile, "UTF-8");
			template.merge(context, out);
		} catch (ResourceNotFoundException e) {
			// テンプレートが見つからないときの処理
		} catch (ParseErrorException e) {
			// 構文にエラーがあるときの処理
		} catch (MethodInvocationException e) {
			// テンプレートのどこかにエラーがあるときの処理
		} catch (Exception e) {
			// その他のエラー時の処理
		}
	}
	
	/**
	 * 
	 * @param propertyPath
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	public static void readConfiguration(String propertyPath) throws FileNotFoundException, IOException {
		_cfg = new Properties();
		_cfg.load(new FileReader(propertyPath));
		
		for(Map.Entry<Object,Object> e : _cfg.entrySet()) {
			_log.config((String)e.getKey() + " " + (String)e.getValue());
		}
	}
	
	public static void setProperty(String key, String value) {
		if(key == null || value == null) {
			throw new IllegalArgumentException();
		}
		_cfg.put(key, value);
		_log.config(key + value);
	}
	
	public static String getProperty(String key) {
		return (String)_cfg.get(key);
	}
}
