package jp.ifrog.genbuframework.xml;

import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;

/**
 * 
 * @author yupong7@gmail.com
 * @author tatsuya.miyadai@gmail.com
 */
public abstract class XmlConvertorGenesic {

	static final protected String TAB = "\t";
	static final protected String CRNL = "\n";

	/**
	 * 出力する XML を読み易くインデントする。
	 */
	protected boolean _isReadable = true;
	protected Stack<String> _elements = new Stack<String>();
	protected StringBuffer xml = new StringBuffer();

	public abstract String convert();
	
	public XmlConvertorGenesic(boolean isReadable) {
		_isReadable = isReadable;
	}

	protected void setXMLDeclaration() {
		// XML 宣言は可読性(_isReadableの値)とは関係なく常に独立した行とする。
		xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
	}
	
	protected final void setOpenResultElement(int recNum) {
		Map<String,String> properties = new Hashtable<String, String>();
		properties.put("recs", new Integer(recNum).toString());
		
		setOpenElement("result", properties);
	}
	
	protected void setOpenResponseElement(String status) {
		Map<String, String> properties = new Hashtable<String,String>();
		properties.put("status", status);
		
		setOpenElement("response", properties);
	}
	
	protected final void setOpenElement(String elementName) {
		setOpenElement(elementName, new Hashtable<String,String>());
	}
	
	protected void setOpenElement(String elementName, Map<String, String> properties) {
		StringBuffer propertiesString = new StringBuffer();

		for(Map.Entry<String, String> e : properties.entrySet()) {
			propertiesString.append(" " + e.getKey() + "=\"" + e.getValue() + "\"");
		}
		
		xmlAppend("<" + elementName + propertiesString + ">");
		_elements.push(elementName);
	}

	/**
	 * エレメントを書きだす
	 * 
	 * @param element エレメント名
	 * @param val 空間の文字列
	 */
	protected void setElement(String elementName, String val) {
		xmlAppend("<" + elementName + ">" + val + "</" + elementName + ">");
	}

	protected void setCloseElement() {
		String element = _elements.pop();
		xmlAppend("</" + element + ">");
	}
	
	protected void xmlAppend(String element) {
		if (_isReadable) {
			for (int i = 0; _elements.size() > i; i++) {
				xml.append(TAB);
			}
		}
		xml.append(element);
		if (_isReadable) {
			xml.append(CRNL);
		}
	}
}
