package farm.example.dog;

import java.util.List;

import jp.ifrog.genbuframework.xml.XmlConvertorGenesic;

/**
 * 
 * @author yupong7@gmail.com
 * @author tatsuya.miyadai@gmail.com
 */
public class DogXmlConvertor extends XmlConvertorGenesic {

	private List<Dog> _dogs;
	
	public void setDogs(List<Dog> dogs) {
		_dogs = dogs;
	}

	public DogXmlConvertor(boolean isReadable) {
		super(isReadable);
	}

	public String convert() {	
		setXMLDeclaration();
		setOpenResponseElement("200");
		setOpenResultElement(_dogs.size());
		setDogElement();
		setCloseElement();
		setCloseElement();
		
		return xml.toString();
	}

	private void setDogElement() {
		for(Dog dog : _dogs) {
			setOpenElement("dog");
			setElement("type", dog.getType());
			setElement("name", dog.getName());
			setElement("age", new Integer(dog.getAge()).toString());
			setCloseElement();
		}
	}

}
