package farm.example.dog;

import java.util.List;
import java.util.logging.Logger;

import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;


/**
 * 
 * @author yupong7@gmail.com
 */
public class DogParser extends DefaultHandler {
	
	private List<Dog> mDogs;
	private Dog mDog;
	private String mText;
	private static Logger log = Logger.getLogger(DogParser.class.getName());
	
	public DogParser(List<Dog> dogs) {
		mDogs = dogs;
	}

	public void startElement(String uri, String localName, String qName,
			Attributes attributes) {
		log.fine("(" + uri + "," + localName + "," + qName + ")");
		if(qName.equals("dog")) {
			mDog = new Dog();
		}
		mText = "";
	}

	public void characters(char[] ch, int offset, int length) {
		mText = new String(ch, offset, length);
		log.fine("(" + mText.replace("\n", "\\n") + ")");
	}

	public void endElement(String uri, String localName, String qName) {
		log.fine("(" + uri + "," + localName + "," + qName + "), mText(" + mText.replace("\n", "\\n") + ")");
		if(qName.equals("age")) {
			if(!mText.equals("")) {
				mDog.setAge(Integer.valueOf(mText).intValue());
			}
		} else if(qName.equals("name")) {
			mDog.setName(mText); 
		} else if(qName.equals("type")) {
			mDog.setType(mText);
		} else if(qName.equals("dog")) {
			mDogs.add(mDog);
		}
	}
}
