package farm.example.dog;

import java.util.logging.Logger;

/**
 * 
 * @author yupong7@gmail.com
 *
 */
public class Dog implements Cloneable{
	
	private String type;
	private String name;
	private int age = 0;
	private static Logger _log = Logger.getLogger(Dog.class.getName());
	
	public Dog() {
		// no-op
	}
	
	public Dog(String type, String name, int age) {
		this();
		this.type = type;
		this.name = name;
		this.age = age;
	}
	
	public String getType() {
		return type;
	}

	public String getName() {
		return name;
	}
	
	public int getAge() {
		return age;
	}
	
	public void setType(String type) {
		this.type = type;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setAge(int age) {
		this.age = age;
	}
	
	public void getOlder() {
		this.age++;
	}
	
	@Override
	public String toString() {
		return "Dog: (type,name,age)=(" + type + "," + name + "," + age + ")";
	}
	
	@Override
	public boolean equals(Object obj) {	
		boolean ret = false;
		
		if(obj instanceof Dog) {
			Dog dog = (Dog)obj;
			ret = getAge() == dog.getAge() && getName().equals(dog.getName()) && getType().equals(getType());
		}
		
		_log.fine(""+ret);
		return ret;
	}

	@Override
	public Object clone() throws CloneNotSupportedException {
		return super.clone();
	}
	
}
