package farm.example.car;

import java.util.logging.Logger;

/**
 * 車
 * 
 * @author tatsuya
 * @author yupong7@gmail.com
 */
public class Car implements Cloneable {

	/** 
	 * 種別（スポーツカー,ワゴン等） 
	 * Deprecated アノテーションは、XmlConvertorGenerator#loadFieldNames() のテストとして
	 * 指示している。
	 */
	@Deprecated
	private String type;
	
	/** 車名 */
	private String name;

	/** 変速機(トランスミッション） */
	private int transmission;
	
	private static Logger _log = Logger.getLogger(Car.class.getName());
	
	
	
	public Car() {
		// no-op
	}
	
	public Car(String type, String name, int transmission) {
		this();
		this.type = type;
		this.name = name;
		this.transmission = transmission;
	}
	
	public String getType() {
		return type;
	}

	public String getName() {
		return name;
	}
	
	public int getTransmission() {
		return transmission;
	}
	
	public void setType(String type) {
		this.type = type;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setTransmission(int transmission) {
		this.transmission = transmission;
	}
	
	//TODO このメソッドはどういう意味?
	public void getOlder() {
		this.transmission++;
	}
	
	@Override
	public String toString() {
		return "Car: (type,name,transmission)=(" + type + "," + name + "," + transmission + ")";
	}
	
	@Override
	public boolean equals(Object obj) {	
		boolean ret = false;
		
		if(obj instanceof Car) {
			Car car = (Car)obj;
			ret = getTransmission() == car.getTransmission() && getName().equals(car.getName()) && getType().equals(getType());
		}
		
		_log.fine(""+ret);
		return ret;
	}

	@Override
	public Object clone() throws CloneNotSupportedException {
		return super.clone();
	}
	
}
