package farm.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.Random;
import java.util.logging.LogManager;

import jp.ifrog.genbuframework.xml.generator.XmlConvertorGenerator;

public class Util {
	
	private static boolean setupFlag = false;
	private static Random rand;
	private static final long RANDOM_SEED = -1155869325L;
	
	public static void setUp() throws FileNotFoundException, IOException {
		if(setupFlag) {
			return;
		}
		// System Property の設定
		Properties properties = new Properties();
		properties.load(new FileReader("res/system.properties"));
		
		// ロギングの設定ファイルを読み込む
		String key = "java.util.logging.config.file";		
		System.setProperty(key, properties.getProperty(key));
		LogManager.getLogManager().readConfiguration();
		
		// XmlConvertorGenerator の設定ファイルを読み込む
		key = "jp.ifrog.genbuframework.xml.generator.XmlConvertorGenerator.config.file";
		XmlConvertorGenerator.readConfiguration(properties.getProperty(key));
		
		// 乱数生成器の初期化
		rand = new Random(RANDOM_SEED);
		
		setupFlag = true;
	}
	
	public static String getInitalLowerCase(String str) {
		if(str.length() == 0) {
			return "";
		}
		String head = str.substring(0, 1) ;
		String tail = str.substring(1);
		return head.toLowerCase() + tail;
	}
	
	public static String getInitalUpperCase(String str) {
		if(str.length() == 0) {
			return "";
		}
		String head = str.substring(0, 1) ;
		String tail = str.substring(1);
		return head.toUpperCase() + tail;
	}

	public static boolean fileContentCompare(String path1, String path2) throws IOException {
		FileReader fr1 = new FileReader(path1);
		FileReader fr2 = new FileReader(path2);
		
		int c1;
		int c2;
		
		do {
			c1 = fr1.read();
			c2 = fr2.read();
			if(c1 != c2) {
				return false;
			}
		} while(c1 != -1); // この条件分岐で c2 を調べる必要は無い。ここでは常に c1 == c2 が成立するため。
		
		return true;
	}

	/**
	 * 
	 * @return ランダムな文字列。
	 */
	public static String getRandStr() {
		return String.valueOf(rand.nextLong());
	}
	
	/**
	 * 
	 * @return ランダムな数。
	 */
	public static int getRandInt() {
		return rand.nextInt();
	}

	public static String getFileContent(String path) throws IOException{	
		StringBuffer ret = new StringBuffer();
		
		InputStreamReader reader = new InputStreamReader(new FileInputStream(new File(path)), "UTF-8");
		
		char[] buf = new char[512];
		int len;
		while((len = reader.read(buf)) != -1) {
			ret.append(new String(buf,0,len));
		}
		return ret.toString();
	}
}
