#define BOOST_AUTO_TEST_MAIN
#include <boost/test/auto_unit_test.hpp>
#include <gslib/sapling/tree.h>
#include <gslib/sapling/scribble.h>
#include <gslib/sapling/dump.h>
#include <iostream>
#include <gslib/test/assert_new.h>
#include <gslib/test/del_counter.h>

using namespace gslib;
using namespace sapling;

typedef tree< int >	tree_type;

BOOST_AUTO_UNIT_TEST( test_basic ) {
	tree_type	t;
	BOOST_CHECK( true == t.empty() );
	BOOST_CHECK( t.begin() == t.end() );
	t.root( 100 );
	BOOST_CHECK( false == t.empty() );
	BOOST_CHECK( 100 == t.root() );
	tree_type::sibling_iterator root = t.begin_sibling();
	BOOST_CHECK( 100 == *root );
	BOOST_CHECK( t.begin() != t.end() );
	BOOST_CHECK( root.begin() == root.end() );
//	BOOST_CHECK( 1 == t.size() );
	t.insert( root.end(), 10 );
//	BOOST_CHECK( 2 == t.size() );
//	BOOST_CHECK( 10 == root.front() );
	BOOST_CHECK( 10 == *root.begin() );
	BOOST_CHECK( root.begin() != root.end() );
	tree_type::sibling_iterator child1 = root.begin();
	BOOST_CHECK( child1.begin() == child1.end() );
	BOOST_CHECK( child1.parent() == root );
	BOOST_CHECK( root.parent() == t.end() );
	t.insert( root.end(), 11 );
	tree_type::sibling_iterator child2 = boost::prior( root.end() );
	BOOST_CHECK( 11 == *child2 );
	BOOST_CHECK( boost::prior( child2 ) == child1 );
	BOOST_CHECK( child2 == boost::next( child1 ) );

	//	ӂ post_order_iterator eXg
	tree_type::post_order_iterator post_it = t.begin_post_order();
	BOOST_CHECK( 10 == *post_it++ );
	BOOST_CHECK( 11 == *post_it++ );
	BOOST_CHECK( 100 == *post_it++ );
	BOOST_CHECK( t.end() == post_it );
	
	{
		//	Rs[RXgN^Ő؂ɑ΂ post_order_iterator eXg
		tree_type t2( t );
		post_it = t2.begin_post_order();
		BOOST_CHECK( 10 == *post_it++ );
		BOOST_CHECK( 11 == *post_it++ );
		BOOST_CHECK( 100 == *post_it++ );
		BOOST_CHECK( t2.end() == post_it );
	}
	
	{
		//	ZqŐ؂ɑ΂ post_order_iterator eXg
		tree_type t3;
		t3 = t;
		post_it = t3.begin_post_order();
		BOOST_CHECK( 10 == *post_it++ );
		BOOST_CHECK( 11 == *post_it++ );
		BOOST_CHECK( 100 == *post_it++ );
		BOOST_CHECK( t3.end() == post_it );
	}
	
	//	
	t.erase( root );
	BOOST_CHECK( true == t.empty() );

	//	deXg
	t.clear();
	BOOST_CHECK( true == t.empty() );
}

tree_type make_tree() {
	//	ȉ̂悤Ȗ؂
	//	0
	//		1
	//			2
	//			3
	//		4
	//			5
	//			6
	//				7
	//				8
	//			9
	//		10
	tree_type t;
	tree_type::iterator it = t.end();
	it = t.insert( it, 0 );
		it = t.insert( it.end(), 1 );
			t.insert( it.end(), 2 );
			t.insert( it.end(), 3 );
		it = it.parent();
		it = t.insert( it.end(), 4 );
			t.insert( it.end(), 5 );
			it = t.insert( it.end(), 6 );
				t.insert( it.end(), 7 );
				t.insert( it.end(), 8 );
			it = it.parent();
			t.insert( it.end(), 9 );
		it = it.parent();
		it = t.insert( it.end(), 10 );
	/*
	scribble( t )
		.b( 0 )		//	qm[h .b()Bxml ł <tag>
			.b( 1 )
				( 2 )	//	qȂm[h ()Bxml ł <tag/>
				( 3 )
			.e()
			.b( 4 )
				( 5 )
				.b( 6 )
					( 7 )
					( 8 )
				.e()
				( 9 )
			.e()
			( 10 )
		.e();		//	I^O .e()Bxml ł </tag>*/
	return t;
}

BOOST_AUTO_UNIT_TEST( test_release ) {
	using namespace test;
	
	typedef tree< del_counter >	tree_type;
	
	int	delcnt = 0;
	{
		tree_type	t;
		t.root( del_counter( delcnt ) );
		delcnt = 0;
	}
	BOOST_CHECK( 1 == delcnt ); // t  del_counter fXgN^		
	
	//	tree ̃fXgN^ɂmF
	tree_type	t;
	{
		tree_type	t1;
		scribble( t1 )
			.b( del_counter( delcnt ) )
				.b( del_counter( delcnt ) )
					( del_counter( delcnt ) )
					( del_counter( delcnt ) )
				.e()
				( del_counter( delcnt ) )
				.b( del_counter( delcnt ) )
					( del_counter( delcnt ) )
					.b( del_counter( delcnt ) )
						( del_counter( delcnt ) )
						( del_counter( delcnt ) )
					.e()
					( del_counter( delcnt ) )
				.e()
				( del_counter( delcnt ) )
			.e();
		t = t1;
		
		delcnt = 0;
	}
	BOOST_CHECK( 12 == delcnt );
	
	//	폜
	{
		tree_type t1( t );
		delcnt = 0;
		t1.erase( t1.begin().begin().begin() );
		BOOST_CHECK( 1 == delcnt );
		t1.erase( t1.begin().begin() );
		BOOST_CHECK( 3 == delcnt );
	}
}

template < size_t BlockSize, size_t NumBlock >
class array_allocator {
	char	array_[ BlockSize * NumBlock ];
	char*	cur_;
	int		count_;
public:
	int count() const { return count_; }
	array_allocator() {
		cur_ = array_;
		count_ = 0;
	}
	void* allocate( size_t n ) {
		char* result = cur_;
		cur_ += BlockSize;
		++count_;
		return cur_;
	}
	void deallocate( void* adrs, size_t n ) {}
};

template < typename Value, typename Allocator >
class allocator_ref {
	Allocator*	allocator_;
public:
	Allocator* get() const { return allocator_; }
	template < typename Other >
	struct rebind {
		typedef allocator_ref< Other, Allocator >	other;
	};
	allocator_ref( Allocator* allocator = 0 ) : allocator_( allocator ) {}
	template < typename Other >
	allocator_ref( const allocator_ref< Other, Allocator >& other ) : allocator_( other.get() ) {}
	Value* allocate( size_t n ) {
		return reinterpret_cast< Value* >( allocator_->allocate( n ) );
	}
	void deallocate( void* adrs, size_t n ) {
		allocator_->deallocate( adrs, n );
	}
};

BOOST_AUTO_UNIT_TEST( test_pool ) {
	test::assert_new::begin();
	typedef array_allocator< tree_type::allocation_size, 100 >	ary_alloc_type;
	typedef allocator_ref< void, ary_alloc_type >	alloc_ref;
	typedef tree<
		int,
		alloc_ref >	pool_tree;
	
	ary_alloc_type	ary_alloc;
	alloc_ref	ary_alloc_ref( &ary_alloc );
	pool_tree t( ary_alloc_ref );
	scribble( t )
		.b( 1 )
			.b( 100 )
				( 34 )
				( 36 )
			.e()
			.b( 3563 )
				.b( 32 )
					( 35 )
					( 63 )
				.e()
				( 24 )
				( 98 )
			.e()
		.e();
	
	BOOST_CHECK( 10 == ary_alloc.count() );
		
	test::assert_new::end();
}

BOOST_AUTO_UNIT_TEST( test_iterator ) {
	
	tree_type t = make_tree();
	
	dump( t, std::cout );
	
	//	pre order Ȃ炻̂܂܂̏ԂɂȂ͂
	{
		tree_type::pre_order_iterator it = t.begin_pre_order();
		int cnt = 0;
		for ( ; it != t.end(); ++it, ++cnt ) {
			BOOST_CHECK( cnt == *it );
		}
		BOOST_CHECK( 11 == cnt );
		for ( --cnt, --it; it != t.end(); --it, --cnt ) {
			BOOST_CHECK( cnt == *it );
		}
	}
	
	//	post order Ȃ
	//	10
	//		2
	//			0
	//			1
	//		8
	//			3
	//			6
	//				4
	//				5
	//			7
	//		9
	{
		int expect_table[] = {
			2,
			3,
			1,
			5,
			7,
			8,
			6,
			9,
			4,
			10,
			0
		};
		tree_type::post_order_iterator it = t.begin_post_order();
		int cnt = 0;
		for ( ; it != t.end(); ++it, ++cnt ) {
			BOOST_CHECK( expect_table[ cnt ] == *it );
		}
		BOOST_CHECK( 11 == cnt );
		for ( --cnt, --it; it != t.end(); --it, --cnt ) {
			BOOST_CHECK( expect_table[ cnt ] == *it );
		}
	}
}