#ifndef GAME_SYOKUNIN_COM_TEST_ASSERT_NEW_H

#define GAME_SYOKUNIN_COM_TEST_ASSERT_NEW_H

#include <boost/assert.hpp>
#include <malloc.h>

inline bool& is_testing() {
	static bool is_testing = false;
	return is_testing;
}

inline void* operator new ( size_t s ) {
	BOOST_ASSERT( false == is_testing() );
	return malloc( s );
}

namespace test {
	namespace assert_new {
		inline void begin() {
			is_testing() = true;
		}
		inline void end() {
			is_testing() = false;
		}
	}
}

#endif