#ifndef GAME_SYOKUNIN_COM_SAPLING_SCRIBBLE_H

#define GAME_SYOKUNIN_COM_SAPLING_SCRIBBLE_H

/*
gslib/sapling/scribble.h

zlib/libpng license
-------------------

Copyright (C) 2004 &o

This software is provided 'as-is', without any express or implied warranty. In n
o event will the authors be held liable for any damages arising from the use of 
this software.

Permission is granted to anyone to use this software for any purpose, including 
commercial applications, and to alter it and redistribute it freely, subject to 
the following restrictions:

The origin of this software must not be misrepresented; you must not claim that 
you wrote the original software. If you use this software in a product, an ackno
wledgment in the product documentation would be appreciated but is not required.

Altered source versions must be plainly marked as such, and must not be misrepre
sented as being the original software.
This notice may not be removed or altered from any source distribution.

project site : https://sourceforge.jp/projects/gslib/
my site : http://www.game-syokunin.com/
--------------------------------------------------------------------------------

@Iɂ́AĽ̂قLȂ̂ŁA茵ɂ͓{Qlɂ
ĂB{́Ahttp://opensource.jp/licenses/zlib-license.html 璸
Ă܂B

zlib/libpngCZX ( { )

Copyright (C) 2004 &o

{\tgEFÁû܂܁vŁAł邩Öقł邩킸A̕ۏ؂
Ȃ񋟂܂B{\tgEFA̎gpɂĐ邢Ȃ鑹QɂĂA
͈؂̐ӔC𕉂Ȃ̂Ƃ܂B ȉ̐ɏ]ApAvP[V
܂߂āA{\tgEFACӂ̖ړIɎgpARɉςčĔЕz邱Ƃ
Ă̐lɋ܂B

{\tgEFȀoɂċU̕\Ă͂Ȃ܂BȂIWĩ\
tgEFA쐬Ǝ咣Ă͂Ȃ܂BȂ{\tgEFA𐻕iŎgp
ꍇAi̕ɎӎĂ΍KłAK{ł͂܂B
\[XύXꍇ́ÂƂ𖾎Ȃ΂Ȃ܂BIWĩ\tgE
FAłƂU̕\Ă͂Ȃ܂B
\[X̔ЕzA̕\폜A\̓eύX肵Ă͂Ȃ܂
B 

project site : https://sourceforge.jp/projects/gslib/
my site : http://www.game-syokunin.com/
*/

#include <gslib/sapling/tree.h>

namespace gslib {
	namespace sapling {

		///	񂿂ؗc[
		template < typename Value, typename Allocator >
		class scribbler {
			typedef tree<
				Value,
				Allocator >									tree_type;
			typedef typename tree_type::sibling_iterator	iterator;
			typedef typename tree_type::const_reference		const_reference;
			tree_type&	tree_;
			iterator	cur_;
		public:
			scribbler( tree_type& t ) : tree_( t ) {
				cur_ = tree_.end_sibling();
			}
			
			scribbler& b( const_reference v ) {
				cur_ = tree_.insert( cur_, v ).end();
				return *this;
			}
			
			scribbler& e() {
				cur_ = cur_.parent().next();
				return *this;
			}
			
			scribbler& operator () ( const_reference v ) {
				cur_ = tree_.insert( cur_, v ).next();
				return *this;
			}
		};
			
		///	gbL[ȋL@Ŗ؂ȒPɍ
		/**
		 *	@code
		 *	tree< int >	t;
		 *	scribble( t )
		 *		.b( 0 )	//	qm[h .b()Bxml ł <tag>
		 *			( 1 )
		 *				( 2 )		//	qȂm[h []Bxml ł <tag/>
		 *				.b( 3 ).e()	//	.b( ? ).e()  () ͓
		 *			.e()
		 *			( 4 )
		 *				( 5 )
		 *				.b( 6 )
		 *					( 7 )
		 *					( 8 )
		 *				.e()
		 *				( 9 )
		 *			.e()
		 *			( 10 )
		 *		.e();		//	I^O .e()Bxml ł </tag>
		 *	@endcode
		 */
		template < typename Value, typename Allocator >
		scribbler< Value, Allocator > scribble( tree< Value, Allocator >& t ) {
			BOOST_ASSERT( true == t.empty() );
			return scribbler< Value, Allocator >( t );
		}
	}
}

#endif