/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system.seasar;

import java.io.File;
import jp.wda.gpss.system.Configuration;
import jp.wda.gpss.system.Main;
import jp.wda.gpss.system.SystemCommander;
import org.seasar.system.Lifecycle;
import org.seasar.util.SeasarException;

public final class GPSSService
implements Lifecycle {
    private String _config = null;
    private String _gpss_home = null;

    public String getConfig() {
        return this._config;
    }

    public void setConfig(String s) {
        this._config = this.getAbsolutePath(s);
    }

    public String getHome() {
        return this._gpss_home;
    }

    public void setHome(String s) {
        this._gpss_home = this.getAbsolutePath(s);
    }

    public void start() throws SeasarException {
        System.out.println("GPSS\u30b5\u30fc\u30d3\u30b9\u3092\u958b\u59cb\u3057\u307e\u3059\u3002");
        System.setProperty("gpss.home", this._gpss_home);
        new GPSSStarter(this._config).start();
    }

    public void stop() throws SeasarException {
        System.setProperty("gpss.home", this._gpss_home);
        Configuration configuration = new Configuration(new File(this._config));
        try {
            configuration.loadConfig();
        }
        catch (Exception e) {
            throw new SeasarException("ESR001");
        }
        SystemCommander.main(new String[]{"" + configuration.getPort(), "shutdown"});
    }

    private String getAbsolutePath(String path) {
        File result = new File(path);
        if (!result.isAbsolute()) {
            result = new File(new File(System.getProperty("seasar.home")), path);
        }
        return result.getAbsolutePath();
    }

    private class GPSSStarter
    extends Thread {
        private String _config = null;

        GPSSStarter(String config) {
            this._config = config;
        }

        public final void run() {
            Main.main(new String[]{this._config});
        }
    }
}

