/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import jp.wda.gpss.system.MainNio;
import jp.wda.gpss.system.SocketProcessorBase;

final class SocketProcessorImplNio
extends SocketProcessorBase
implements Runnable {
    private SocketChannel channel;
    private Charset codec;
    private StringBuffer messageBuffer = new StringBuffer();
    private boolean terminated = true;

    public SocketProcessorImplNio(MainNio server, SocketChannel channel, String encoding, int buffersize) throws IOException {
        super(server, encoding, buffersize, channel.socket().getInetAddress().getHostAddress());
        this.channel = channel;
        this.codec = server.getCharCoder();
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    void setMessage(String message, boolean execute) {
        this.messageBuffer.append(message);
        if (execute) {
            if (this.getApplication() != null) {
                this.onCommand(this.messageBuffer.toString());
            } else {
                this.onInitialize(this.messageBuffer.toString());
            }
            this.messageBuffer = new StringBuffer();
        }
    }

    public void run() {
    }

    private void onInitialize(String mesage) {
        try {
            this.getProgress().log("debuglogger", "connection:" + mesage + " [" + this.getClientID() + "]");
            this.doInitialCommand(mesage);
            if (this.getApplication() == null) {
                this.terminate();
                return;
            }
            if (!this.getApplication().checkConnection(this)) {
                this.terminate();
                return;
            }
            this.terminated = false;
            this.channel.socket().setSoTimeout(this.getApplication().getTimeout());
        }
        catch (SocketException ioe) {
            this.getProgress().errlog(String.valueOf(ioe.getMessage()) + ":" + this.getClientID());
            this.terminate();
        }
        catch (Throwable e) {
            this.getProgress().errlog("\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.getClientID(), e);
        }
    }

    private void onCommand(String message) {
        try {
            if (!this.getApplication().doCommand(this, message)) {
                this.terminate();
            }
        }
        catch (Throwable e) {
            this.getProgress().errlog("\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.getClientID(), e);
        }
    }

    public boolean send(String message) {
        if (this.channel == null) {
            this.getProgress().errlog("\u30e9\u30a4\u30bf\u3092\u55aa\u5931\u3057\u307e\u3057\u305f\u3002" + this.getClientID());
            return false;
        }
        try {
            this.channel.write(this.codec.encode(String.valueOf(message) + "\u0000"));
        }
        catch (IOException e) {
            this.getProgress().errlog("\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + this.getClientID() + "\n" + message, e);
            return false;
        }
        return true;
    }

    public synchronized void terminate() {
        this.terminated = true;
        this.getProgress().log("debuglogger", "disconnect [" + this.getClientID() + "]");
        try {
            if (this.getApplication() != null) {
                this.getApplication().preRemoveClient(this);
                this.getApplication().removeClient(this);
                this.notifyToSystemCommandSocklet();
            }
        }
        catch (Throwable e) {
            this.getProgress().errlog("\u7d42\u4e86\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.getClientID(), e);
            e.printStackTrace();
        }
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.channel = null;
    }

    public synchronized void terminate(String message) {
        this.send(message);
        this.terminate();
    }
}

