/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.system.ScriptSocklet;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;

public class RhinoJsSocklet
extends ScriptSocklet {
    private Context cx;
    private Scriptable scope;
    private String encoding;
    private String debug;

    public void init(List linkedSocklets) {
        try {
            this.cx = Context.enter(null);
            this.scope = new ImporterTopLevel(this.cx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.encoding = this.getInitParam("sourceEncoding");
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        this.debug = this.getInitParam("debug");
        if (this.debug == null) {
            this.debug = "normal";
        }
        String fileName = this.getInitParam("source");
        String script = "";
        if (fileName != null) {
            try {
                script = this.loadFile(fileName, this.encoding);
                System.out.println("  \u30b9\u30af\u30ea\u30d7\u30c8'" + fileName + "'\u3092\u521d\u671f\u5316\u4e2d\u3067\u3059\u3002");
            }
            catch (Exception e) {
                System.out.println("  \u30b9\u30af\u30ea\u30d7\u30c8'" + fileName + "'\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002");
            }
        }
        try {
            this.scope.put("application", this.scope, (Object)this);
            this.cx.evaluateString(this.scope, script, fileName, 1, null);
            if (!(this.get("onInit") instanceof Function)) {
                System.out.println("      onInit\u304c\u672a\u5b9a\u7fa9\u3067\u3059\u3002");
                this.cx.evaluateString(this.scope, "function onInit(){}", fileName, 1, null);
            }
            if (!(this.get("onConnect") instanceof Function)) {
                System.out.println("      onConnect\u304c\u672a\u5b9a\u7fa9\u3067\u3059\u3002");
                this.cx.evaluateString(this.scope, "function onConnect(client){client.send(\"+OK\");return true;}", fileName, 1, null);
            }
            if (!(this.get("onDisconnect") instanceof Function)) {
                System.out.println("      onDisconnect\u304c\u672a\u5b9a\u7fa9\u3067\u3059\u3002");
                this.cx.evaluateString(this.scope, "function onDisconnect(client){}", fileName, 1, null);
            }
            if (!(this.get("onCommand") instanceof Function)) {
                System.out.println("      onCommand\u304c\u672a\u5b9a\u7fa9\u3067\u3059\u3002");
                this.cx.evaluateString(this.scope, "function onCommand(client,command){application.sendToAllClients(command);return true;}", fileName, 1, null);
            }
            if (!(this.get("onDestroy") instanceof Function)) {
                this.cx.evaluateString(this.scope, "function onDestroy(){}", fileName, 1, null);
            }
            if (!(this.get("onSockletLink") instanceof Function)) {
                this.cx.evaluateString(this.scope, "function onSockletLink(from){return false;}", fileName, 1, null);
            }
            this.call("onInit", new Object[]{linkedSocklets});
            Context.exit();
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            } else {
                System.out.println(e);
            }
            Context.exit();
        }
    }

    public boolean checkConnection(SocketProcessor client) {
        try {
            Context.enter();
            Object result = this.call("onConnect", new Object[]{client});
            Context.exit();
            return "true".equals(result.toString());
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            } else {
                System.out.println(e);
            }
            Context.exit();
            return false;
        }
    }

    public void preRemoveClient(SocketProcessor client) {
        try {
            Context.enter();
            this.call("onDisconnect", new Object[]{client});
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            }
            System.out.println(e);
        }
        Context.exit();
    }

    public boolean doCommand(SocketProcessor client, String command) {
        try {
            Context.enter();
            Object result = this.call("onCommand", new Object[]{client, command});
            Context.exit();
            return "true".equals(result.toString());
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            } else {
                System.out.println(e);
            }
            Context.exit();
            return false;
        }
    }

    public void destroy() {
        try {
            Context.enter();
            this.call("onDestroy", new Object[0]);
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            }
            System.out.println(e);
        }
        this.cx = null;
        this.scope = null;
        Context.exit();
    }

    public boolean allowAccessFromOtherSocklet(Socklet from) {
        try {
            Context.enter();
            Object result = this.call("onSockletLink", new Object[]{from});
            Context.exit();
            return "true".equals(result.toString());
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            } else {
                System.out.println(e);
            }
            Context.exit();
            return false;
        }
    }

    public boolean importSource(String fileName) {
        String script = this.loadFile(fileName, this.encoding);
        try {
            this.cx.evaluateString(this.scope, script, fileName, 1, null);
            return true;
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            } else {
                System.out.println(e);
            }
            return false;
        }
    }

    public void addSocklet(List links, String sockletName, String className) {
        SockletDeployInfo appinfo = this.copyInfo(sockletName, className);
        links.add(appinfo);
    }

    public void addScriptSocklet(List links, String sockletName, String fileName) {
        SockletDeployInfo appinfo = this.copyInfo(sockletName, "jp.wda.gpss.system.RhinoJsSocklet");
        appinfo.setInitParam("source", fileName);
        links.add(appinfo);
    }

    public Object call(String functionName, Object[] args) {
        try {
            Object func = this.scope.get(functionName, this.scope);
            if (func instanceof Function) {
                return ((Function)func).call(this.cx, this.scope, this.scope, args);
            }
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            }
            System.out.println(e);
        }
        return null;
    }

    public Object get(String variableName) {
        try {
            return this.scope.get(variableName, this.scope);
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            } else {
                System.out.println(e);
            }
            return null;
        }
    }

    private String loadFile(String fileName, String encoding) {
        String result = "";
        try {
            BufferedReader fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), encoding));
            String inLine = fr.readLine();
            while (inLine != null) {
                result = String.valueOf(result) + inLine + "\n";
                inLine = fr.readLine();
            }
            fr.close();
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            }
            System.out.println(e);
        }
        return result;
    }
}

