/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.wda.gpss.AttributeException;
import jp.wda.gpss.Progress;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.system.AttributeContainer;
import jp.wda.gpss.system.ExecutableBase;
import jp.wda.gpss.system.InitParamContainer;
import jp.wda.gpss.util.Finder;
import jp.wda.gpss.util.SocketProcessorFinder;
import org.apache.log4j.Priority;

public abstract class GeneralSocklet
implements Socklet,
InitParamContainer,
AttributeContainer {
    private SockletDeployInfo info;
    private ArrayList clients;
    protected Progress progress;
    private String defaultLogger = "gpssSystemLogger";
    private Hashtable attributes = new Hashtable();
    private ExecutableBase server;
    private String deployedby = "BySystemServer";

    public final ExecutableBase getMain() {
        return null;
    }

    public final void setMain(ExecutableBase server) {
        if (server != null) {
            this.server = server;
        }
    }

    public final String deployedBy() {
        return this.deployedby;
    }

    public final void deployedBy(ExecutableBase server, String name) {
        if (server != null && name != null) {
            this.deployedby = name;
        }
    }

    public final String getName() {
        return this.info.getName();
    }

    public final int getTimeout() {
        return this.info.getTimeout();
    }

    public final void setTimeout(int timeout) {
        this.info.setTimeout(timeout);
    }

    public final String getInitParam(String key) {
        return this.info.getInitParam(key);
    }

    public final List getInitParams(String key) {
        return this.info.getInitParams(key);
    }

    public List getInitParams() {
        return this.info.getInitParams();
    }

    public List getInitParamKeys() {
        return this.info.getInitParamKeys();
    }

    public boolean hasInitParam(String key) {
        return this.info.hasInitParam(key);
    }

    public final void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public final Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public Set getAttributes() {
        return this.attributes.entrySet();
    }

    public boolean containsAttributeKey(Object key) {
        return this.attributes.containsKey(key);
    }

    public Set getAttributeKeys() {
        return this.attributes.keySet();
    }

    public Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public final void setAttribute(Object key, int value) {
        this.attributes.put(key, new Integer(value));
    }

    public final int getAttributeInt(Object key) throws AttributeException {
        Object ret = this.attributes.get(key);
        if (ret instanceof Integer) {
            return (Integer)ret;
        }
        throw new AttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306fint\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public final void setAttribute(Object key, long value) {
        this.attributes.put(key, new Long(value));
    }

    public final long getAttributeLong(Object key) throws AttributeException {
        Object ret = this.attributes.get(key);
        if (ret instanceof Long) {
            return (Long)ret;
        }
        throw new AttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306flong\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public final void setAttribute(Object key, double value) {
        this.attributes.put(key, new Double(value));
    }

    public final double getAttributeDouble(Object key) throws AttributeException {
        Object ret = this.attributes.get(key);
        if (ret instanceof Double) {
            return (Double)ret;
        }
        throw new AttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306fdouble\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public final void setAttribute(Object key, boolean value) {
        this.attributes.put(key, new Boolean(value));
    }

    public final boolean getAttributeBoolean(Object key) throws AttributeException {
        Object ret = this.attributes.get(key);
        if (ret instanceof Boolean) {
            return (Boolean)ret;
        }
        throw new AttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306fboolean\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public SockletDeployInfo copyInfo(String appname, String classname) {
        SockletDeployInfo newinfo = new SockletDeployInfo(appname);
        newinfo.setClassname(classname);
        this.info.copyInitParamsTo(newinfo);
        newinfo.setTimeout(this.info.getTimeout());
        return newinfo;
    }

    public final Socklet getOtherSocklet(String appname) {
        if (this.server == null) {
            return null;
        }
        if (appname.equals(this.getName())) {
            return null;
        }
        Socklet other = this.server.getSocklet(appname);
        if (!other.allowAccessFromOtherSocklet(this)) {
            return null;
        }
        return other;
    }

    public final synchronized void sendToAllClients(String message) {
        this.sendToClients(new ArrayList(this.clients), message);
    }

    public final synchronized void sendToClients(String message, Finder finder) {
        if (finder == null) {
            return;
        }
        this.sendToClients(finder.getList(this.clients), message);
    }

    public final synchronized void sendToClients(String message, String condition) {
        try {
            this.sendToClients(message, SocketProcessorFinder.getFinder(condition));
        }
        catch (Throwable e) {
            this.log((Object)"Create Finder object failure...", e);
            this.log((Object)("Condition:" + condition), Progress.ERROR);
        }
    }

    public final synchronized void addClient(SocketProcessor client) {
        this.clients.add(client);
    }

    public final synchronized void removeClient(SocketProcessor client) {
        ((AbstractCollection)this.clients).remove(client);
    }

    public final int countClients() {
        return this.clients.size();
    }

    public final synchronized boolean containsClient(SocketProcessor client) {
        return this.clients.indexOf(client) >= 0;
    }

    public final List getAllClients() {
        return new ArrayList(this.clients);
    }

    public final synchronized List getClients(Finder finder) {
        if (finder == null) {
            return new ArrayList();
        }
        return finder.getList(this.clients);
    }

    public final synchronized List getClients(String condition) {
        try {
            return SocketProcessorFinder.getFinder(condition).getList(this.clients);
        }
        catch (Throwable e) {
            this.log((Object)"Create Finder object failure...", e);
            this.log((Object)("Condition:" + condition), Progress.ERROR);
            return new ArrayList();
        }
    }

    public final synchronized void disconnectAllClients(String message) {
        Iterator i = ((AbstractList)new ArrayList(this.clients)).iterator();
        while (i.hasNext()) {
            ((SocketProcessor)i.next()).terminate(message);
        }
    }

    public final Finder preCreateFinder(String condition) {
        try {
            return SocketProcessorFinder.getFinder(condition);
        }
        catch (Throwable e) {
            this.log((Object)"Create Finder object failure...", e);
            this.log((Object)("Condition:" + condition), Progress.ERROR);
            return new SocketProcessorFinder();
        }
    }

    public void log(Object message) {
        this.progress.log(this.defaultLogger, message);
    }

    public void log(Object message, Priority priority) {
        this.progress.log(this.defaultLogger, message, priority);
    }

    public void log(Object message, Throwable throwable) {
        this.progress.log(this.defaultLogger, message, Priority.ERROR, throwable);
    }

    public void log(Object message, Priority priority, Throwable throwable) {
        this.progress.log(this.defaultLogger, message, priority, throwable);
    }

    public void memo(String logger, Object message) {
        this.progress.log(logger, message);
    }

    public void memo(String logger, Object message, Priority priority) {
        this.progress.log(logger, message, priority);
    }

    public void memo(String logger, Object message, Throwable t) {
        this.progress.log(logger, message, Priority.ERROR, t);
    }

    public void memo(String logger, Object message, Priority priority, Throwable t) {
        this.progress.log(logger, message, priority, t);
    }

    public final void init(SockletDeployInfo info, List links, Progress progress) {
        this.clients = new ArrayList();
        this.info = info;
        this.progress = progress;
        if (progress.contansLogger(this.getName())) {
            this.defaultLogger = this.getName();
        }
        this.init(links);
    }

    protected void init(List links) {
        this.init();
    }

    protected void init() {
    }

    public void afterDeployedLinks(Map linkedSocklets) {
    }

    public boolean checkConnection(SocketProcessor client) {
        return true;
    }

    public void preRemoveClient(SocketProcessor client) {
    }

    public void destroy() {
    }

    public boolean allowAccessFromOtherSocklet(Socklet from) {
        return false;
    }

    private void sendToClients(List clients, String message) {
        Iterator i = clients.iterator();
        while (i.hasNext()) {
            SocketProcessor client = (SocketProcessor)i.next();
            if (client.send(message)) continue;
            client.terminate();
        }
    }

    public abstract boolean doCommand(SocketProcessor var1, String var2);
}

