/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss;

import java.lang.reflect.Method;
import jp.wda.gpss.GeneralSocklet;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.SockletException;

public abstract class CommandSocklet
extends GeneralSocklet {
    public final synchronized boolean doCommand(SocketProcessor client, String command) {
        Object preprocessed = null;
        try {
            preprocessed = this.preProcess(client, command);
        }
        catch (SockletException e) {
            return false;
        }
        CommandInfo cmd = this.parseCommand(client, command, preprocessed);
        if (cmd == null) {
            return false;
        }
        if (cmd.name == null) {
            return false;
        }
        if (this.execIgnoreCase(client) && cmd.name.length() > 0) {
            cmd.name = String.valueOf(cmd.name.substring(0, 1).toUpperCase()) + (cmd.name.length() > 1 ? cmd.name.substring(1).toLowerCase() : "");
        }
        Method method = null;
        try {
            method = this.getClass().getMethod("cmd" + cmd.name, cmd.type);
        }
        catch (NoSuchMethodException e) {
            return this.cmdUndefined(client, cmd.name, cmd.params);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return false;
        }
        Object ret = null;
        try {
            ret = method.invoke((Object)this, cmd.params);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret;
        }
        if (ret instanceof String) {
            return Boolean.getBoolean((String)ret);
        }
        if (ret instanceof Integer) {
            return (Integer)ret != 0;
        }
        return false;
    }

    protected abstract CommandInfo parseCommand(SocketProcessor var1, String var2, Object var3);

    public boolean cmdUndefined(SocketProcessor client, String command, Object[] params) {
        return true;
    }

    public Object preProcess(SocketProcessor client, String command) throws SockletException {
        return null;
    }

    public boolean execIgnoreCase(SocketProcessor client) {
        return true;
    }

    protected class CommandInfo {
        public String name;
        public Class[] type;
        public Object[] params;

        protected CommandInfo() {
        }
    }
}

