/*
 * Decompiled with CFR 0.152.
 */
package FESI.Exceptions;

import FESI.Interpreter.EvaluationSource;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;

public class EcmaScriptException
extends Exception {
    protected static String eol = System.getProperty("line.separator", "\n");
    protected Vector evaluationSources = new Vector();
    private Throwable originatingException;

    public EcmaScriptException(String string) {
        super(string);
    }

    public EcmaScriptException(String string, Throwable throwable) {
        super(string);
        this.originatingException = throwable;
    }

    public Throwable getOriginatingException() {
        return this.originatingException;
    }

    public void appendEvaluationSource(EvaluationSource evaluationSource) {
        this.evaluationSources.addElement(evaluationSource);
    }

    public int getLineNumber() {
        if (this.evaluationSources.size() > 0) {
            EvaluationSource evaluationSource = (EvaluationSource)this.evaluationSources.elementAt(0);
            return evaluationSource.getLineNumber();
        }
        return -1;
    }

    public String getMessage() {
        Object object;
        String string = "Runtime error " + super.getMessage();
        if (this.originatingException != null) {
            string = String.valueOf(string) + eol + "Caused by exception: " + eol + "  " + this.originatingException.getMessage();
        }
        if (this.originatingException != null) {
            StringWriter stringWriter = new StringWriter();
            object = new PrintWriter(stringWriter);
            this.originatingException.printStackTrace((PrintWriter)object);
            string = String.valueOf(string) + eol;
            ((PrintWriter)object).close();
            string = String.valueOf(string) + stringWriter.toString();
        }
        int n = 0;
        while (n < this.evaluationSources.size()) {
            object = (EvaluationSource)this.evaluationSources.elementAt(n);
            string = String.valueOf(string) + eol + (n == 0 ? "detected " : "called ") + object;
            ++n;
        }
        return string;
    }

    public boolean isIncomplete() {
        return false;
    }

    public void printStackTrace() {
        System.err.println(this);
        this.printStackTrace0(new PrintWriter(System.err));
    }

    public void printStackTrace(PrintStream printStream) {
        printStream.println(this);
        PrintWriter printWriter = new PrintWriter(printStream);
        this.printStackTrace0(printWriter);
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.println(this);
        this.printStackTrace0(printWriter);
    }

    private void printStackTrace0(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.originatingException != null) {
            printWriter.println("due to:");
            this.originatingException.printStackTrace(printWriter);
        }
        printWriter.flush();
    }
}

