/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ArrayPrototype;
import FESI.Data.CompatibilityDescriptor;
import FESI.Data.DatePrototype;
import FESI.Data.ESArrayWrapper;
import FESI.Data.ESBoolean;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Data.ESWrapper;
import FESI.Data.JSWrapper;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.LocalClassLoader;
import FESI.Interpreter.ScopeChain;
import FESI.jslib.JSFunction;
import java.util.Date;

public abstract class ESLoader
extends ESObject {
    protected static boolean debugJavaAccess;
    protected static boolean debugLoader;
    protected String packageName;
    protected ESLoader previousPackage;
    protected LocalClassLoader classLoader;
    private static CompatibilityDescriptor nonCompatible;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;

    public static void setDebugJavaAccess(boolean bl) {
        debugJavaAccess = bl;
    }

    public static boolean isDebugJavaAccess() {
        return debugJavaAccess;
    }

    public static void setDebugLoader(boolean bl) {
        debugLoader = bl;
    }

    public static boolean isDebugLoader() {
        return debugLoader;
    }

    public ESLoader(Evaluator evaluator) {
        super(null, evaluator);
    }

    public ESLoader(String string, ESLoader eSLoader, LocalClassLoader localClassLoader, Evaluator evaluator) {
        super(null, evaluator);
        this.packageName = string;
        this.previousPackage = eSLoader;
        this.classLoader = localClassLoader;
    }

    protected String buildPrefix() {
        if (this.previousPackage == null) {
            return null;
        }
        String string = this.previousPackage.buildPrefix();
        if (string == null) {
            return this.packageName;
        }
        return String.valueOf(string) + "." + this.packageName;
    }

    public ESObject getPrototype() {
        throw new ProgrammingError("Cannot get prototype of Package");
    }

    public int getTypeOf() {
        return 6;
    }

    public ESValue getPropertyInScope(String string, ScopeChain scopeChain, int n) throws EcmaScriptException {
        throw new EcmaScriptException("A loader object (" + this + ") should not be part of a with statement");
    }

    public boolean hasProperty(String string, int n) throws EcmaScriptException {
        return true;
    }

    public boolean isHiddenProperty(String string, int n) {
        return false;
    }

    public void putProperty(String string, ESValue eSValue, int n) throws EcmaScriptException {
    }

    public void putHiddenProperty(String string, ESValue eSValue) throws EcmaScriptException {
        throw new ProgrammingError("Cannot put hidden property in " + this);
    }

    public boolean deleteProperty(String string, int n) throws EcmaScriptException {
        return false;
    }

    public ESValue getDefaultValue(int n) throws EcmaScriptException {
        if (n == 5) {
            return new ESString(this.toString());
        }
        throw new EcmaScriptException("No default value for " + this + " and hint " + n);
    }

    public ESValue getDefaultValue() throws EcmaScriptException {
        return this.getDefaultValue(5);
    }

    public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        throw new EcmaScriptException("No contructor for loader object: " + this);
    }

    public double doubleValue() {
        double d = Double.NaN;
        return d;
    }

    public boolean booleanValue() {
        return true;
    }

    public String toString() {
        return this.toDetailString();
    }

    static boolean isBasicClass(Class clazz) {
        return clazz == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ESLoader.class$("java.lang.String"))) || clazz == (class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = ESLoader.class$("java.lang.Character"))) || clazz == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = ESLoader.class$("java.lang.Byte"))) || clazz == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = ESLoader.class$("java.lang.Short"))) || clazz == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = ESLoader.class$("java.lang.Integer"))) || clazz == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = ESLoader.class$("java.lang.Long"))) || clazz == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = ESLoader.class$("java.lang.Float"))) || clazz == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = ESLoader.class$("java.lang.Double"))) || clazz == (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ESLoader.class$("java.lang.Boolean"))) || clazz == (class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = ESLoader.class$("java.util.Date")));
    }

    static boolean isPrimitiveNumberClass(Class clazz) {
        return clazz == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = ESLoader.class$("java.lang.Byte"))) || clazz == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = ESLoader.class$("java.lang.Short"))) || clazz == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = ESLoader.class$("java.lang.Integer"))) || clazz == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = ESLoader.class$("java.lang.Long"))) || clazz == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = ESLoader.class$("java.lang.Float"))) || clazz == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = ESLoader.class$("java.lang.Double")));
    }

    public static ESValue normalizeValue(Object object, Evaluator evaluator) throws EcmaScriptException {
        if (object == null) {
            return ESNull.theNull;
        }
        if (object instanceof String) {
            return new ESString((String)object);
        }
        if (ESLoader.isPrimitiveNumberClass(object.getClass())) {
            return new ESNumber(((Number)object).doubleValue());
        }
        if (object instanceof Boolean) {
            return ESBoolean.makeBoolean((Boolean)object);
        }
        if (object instanceof Character) {
            return new ESNumber(((Character)object).charValue());
        }
        if (object instanceof JSFunction) {
            return JSWrapper.wrapJSFunction(evaluator, (JSFunction)object);
        }
        if (object instanceof JSWrapper) {
            return ((JSWrapper)object).getESObject();
        }
        if (object instanceof Date) {
            return new DatePrototype(evaluator, (Date)object);
        }
        if (object instanceof ESWrapper) {
            return (ESWrapper)object;
        }
        if (object instanceof ESArrayWrapper) {
            return (ESArrayWrapper)object;
        }
        if (object.getClass().isArray()) {
            return new ESArrayWrapper(object, evaluator);
        }
        return new ESWrapper(object, evaluator);
    }

    public static ESObject normalizeObject(Object object, Evaluator evaluator) throws EcmaScriptException {
        ESValue eSValue = ESLoader.normalizeValue(object, evaluator);
        return (ESObject)eSValue.toESObject(evaluator);
    }

    private static Class convertPrimitive(Class clazz) {
        if (clazz == Boolean.TYPE) {
            clazz = class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ESLoader.class$("java.lang.Boolean"));
        } else if (clazz == Character.TYPE) {
            clazz = class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = ESLoader.class$("java.lang.Character"));
        } else if (clazz == Byte.TYPE) {
            clazz = class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = ESLoader.class$("java.lang.Byte"));
        } else if (clazz == Short.TYPE) {
            clazz = class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = ESLoader.class$("java.lang.Short"));
        } else if (clazz == Integer.TYPE) {
            clazz = class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = ESLoader.class$("java.lang.Integer"));
        } else if (clazz == Long.TYPE) {
            clazz = class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = ESLoader.class$("java.lang.Long"));
        } else if (clazz == Float.TYPE) {
            clazz = class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = ESLoader.class$("java.lang.Float"));
        } else if (clazz == Double.TYPE) {
            clazz = class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = ESLoader.class$("java.lang.Double"));
        } else {
            throw new ProgrammingError("Not a recognized primitive type: " + clazz);
        }
        return clazz;
    }

    private static int getNumberSize(Class clazz) {
        if (clazz == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = ESLoader.class$("java.lang.Byte")))) {
            return 1;
        }
        if (clazz == (class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = ESLoader.class$("java.lang.Character")))) {
            return 2;
        }
        if (clazz == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = ESLoader.class$("java.lang.Short")))) {
            return 2;
        }
        if (clazz == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = ESLoader.class$("java.lang.Integer")))) {
            return 3;
        }
        if (clazz == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = ESLoader.class$("java.lang.Long")))) {
            return 4;
        }
        if (clazz == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = ESLoader.class$("java.lang.Float")))) {
            return 5;
        }
        if (clazz == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = ESLoader.class$("java.lang.Double")))) {
            return 6;
        }
        throw new ProgrammingError("Unexpected number class");
    }

    static CompatibilityDescriptor areParametersCompatible(Class[] classArray, Object[] objectArray) {
        int n = classArray.length;
        if (n != objectArray.length) {
            return nonCompatible;
        }
        boolean[] blArray = null;
        Object[] objectArray2 = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            boolean bl = false;
            Class clazz = classArray[n3];
            Class<?> clazz2 = null;
            String string = " not accepted";
            if (objectArray[n3] == null) {
                if (clazz.isPrimitive()) {
                    bl = false;
                    string = " rejected (null cannot be assigned to primitive)";
                } else {
                    bl = true;
                    string = " accepted (null to Object)";
                }
            } else {
                if (clazz.isPrimitive()) {
                    clazz = ESLoader.convertPrimitive(clazz);
                }
                clazz2 = objectArray[n3].getClass();
                bl = clazz.isAssignableFrom(clazz2);
                string = " accepted (subclassing)";
                if (!bl) {
                    if ((ESLoader.isPrimitiveNumberClass(clazz2) || clazz2 == (class$java$lang$Character != null ? class$java$lang$Character : ESLoader.class$("java.lang.Character"))) && ESLoader.isPrimitiveNumberClass(clazz)) {
                        int n4;
                        int n5 = ESLoader.getNumberSize(clazz);
                        if (n5 > (n4 = ESLoader.getNumberSize(clazz2))) {
                            bl = true;
                            string = " accepted (number widening: " + (n2 += Math.abs(n5 - n4)) + ")";
                        } else {
                            string = " rejected (not widening numbers)";
                        }
                    } else if ((clazz == (class$java$lang$Character != null ? class$java$lang$Character : ESLoader.class$("java.lang.Character")) || clazz == (class$java$lang$Integer != null ? class$java$lang$Integer : ESLoader.class$("java.lang.Integer")) || clazz == (class$java$lang$Long != null ? class$java$lang$Long : ESLoader.class$("java.lang.Long")) || clazz == (class$java$lang$Float != null ? class$java$lang$Float : ESLoader.class$("java.lang.Float")) || clazz == (class$java$lang$Double != null ? class$java$lang$Double : ESLoader.class$("java.lang.Double"))) && objectArray[n3] instanceof String) {
                        if (((String)objectArray[n3]).length() == 1) {
                            bl = true;
                            if (blArray == null) {
                                blArray = new boolean[n];
                            }
                            blArray[n3] = true;
                            string = " accepted (String(1) as Character)";
                        } else {
                            string = " rejected (String not of length 1)";
                        }
                    } else if (clazz.isArray()) {
                        if (objectArray[n3] instanceof JSWrapper) {
                            ESObject eSObject = ((JSWrapper)objectArray[n3]).getESObject();
                            if (eSObject instanceof ArrayPrototype) {
                                Object object = null;
                                try {
                                    object = ((ArrayPrototype)eSObject).toJavaArray(clazz.getComponentType());
                                    bl = true;
                                    string = " accepted (array converted)";
                                    if (objectArray2 == null) {
                                        objectArray2 = new Object[n];
                                    }
                                    objectArray2[n3] = object;
                                }
                                catch (EcmaScriptException ecmaScriptException) {
                                    string = " rejected (" + ecmaScriptException.getMessage() + ")";
                                }
                            } else {
                                string = " rejected (EcmaScript object is not an array)";
                            }
                        } else {
                            string = " rejected (only same native array or EcmaScript Array can be assigned to array)";
                        }
                    } else {
                        string = " rejected (incompatible types)";
                    }
                }
            }
            if (debugJavaAccess) {
                System.out.println(" Assign " + clazz2 + " to " + classArray[n3] + string);
            }
            if (!bl) {
                return nonCompatible;
            }
            ++n3;
        }
        return new CompatibilityDescriptor(n2, blArray, objectArray2);
    }

    public static String typeName(Class clazz) {
        String string = "";
        while (clazz.isArray()) {
            string = String.valueOf(string) + "[]";
            clazz = clazz.getComponentType();
        }
        return String.valueOf(clazz.getName()) + string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        nonCompatible = new CompatibilityDescriptor(-1, null, null);
    }
}

