/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.AST.ASTStatementList;
import FESI.Data.ESArguments;
import FESI.Data.ESNull;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.ObjectObject;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.EvaluationSource;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.ScopeChain;
import java.util.Vector;

public class ConstructedFunctionObject
extends FunctionPrototype {
    private static final String PROTOTYPEstring = new String("prototype").intern();
    private static final int PROTOTYPEhash = PROTOTYPEstring.hashCode();
    private ASTStatementList theFunctionAST;
    private String[] theArguments;
    private Vector localVariableNames;
    private EvaluationSource evaluationSource;
    private String functionSource;
    private ESValue currentArguments = ESNull.theNull;

    private ConstructedFunctionObject(FunctionPrototype functionPrototype, Evaluator evaluator, String string, EvaluationSource evaluationSource, String string2, String[] stringArray, Vector vector, ASTStatementList aSTStatementList) {
        super(functionPrototype, evaluator, string, stringArray.length);
        this.evaluationSource = evaluationSource;
        this.functionSource = string2;
        this.theFunctionAST = aSTStatementList;
        this.theArguments = stringArray;
        this.localVariableNames = vector;
    }

    public String getFunctionImplementationString() {
        if (this.functionSource == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("function ");
            stringBuffer.append(this.getFunctionName());
            stringBuffer.append("(");
            int n = 0;
            while (n < this.theArguments.length) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.theArguments[n]);
                ++n;
            }
            stringBuffer.append(")");
            stringBuffer.append("function {<internal abstract syntax tree representation>}");
            return stringBuffer.toString();
        }
        return this.functionSource;
    }

    public Vector getLocalVariableNames() {
        return this.localVariableNames;
    }

    public String getFunctionParametersString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n = 0;
        while (n < this.theArguments.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.theArguments[n]);
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        ESValue eSValue = null;
        ESArguments eSArguments = ESArguments.makeNewESArguments(this.evaluator, this, this.theArguments, eSValueArray);
        ESValue eSValue2 = this.currentArguments;
        this.currentArguments = eSArguments;
        try {
            eSValue = this.evaluator.evaluateFunction(this.theFunctionAST, this.evaluationSource, eSArguments, this.localVariableNames, eSObject);
        }
        finally {
            Object var7_6 = null;
            this.currentArguments = eSValue2;
        }
        return eSValue;
    }

    public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        ESValue eSValue = this.getProperty(PROTOTYPEstring, PROTOTYPEhash);
        ESObject eSObject2 = this.evaluator.getObjectPrototype();
        if (!(eSValue instanceof ESObject)) {
            eSValue = eSObject2;
        }
        ObjectPrototype objectPrototype = new ObjectPrototype((ESObject)eSValue, this.evaluator);
        this.callFunction(objectPrototype, eSValueArray);
        return objectPrototype;
    }

    public String toString() {
        return this.getFunctionImplementationString();
    }

    public String toDetailString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Function: ");
        stringBuffer.append(this.getFunctionName());
        stringBuffer.append("(");
        int n = 0;
        while (n < this.theArguments.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.theArguments[n]);
            ++n;
        }
        stringBuffer.append(")>");
        return stringBuffer.toString();
    }

    public static ConstructedFunctionObject makeNewConstructedFunction(Evaluator evaluator, String string, EvaluationSource evaluationSource, String string2, String[] stringArray, Vector vector, ASTStatementList aSTStatementList) {
        ConstructedFunctionObject constructedFunctionObject = null;
        try {
            FunctionPrototype functionPrototype = (FunctionPrototype)evaluator.getFunctionPrototype();
            constructedFunctionObject = new ConstructedFunctionObject(functionPrototype, evaluator, string, evaluationSource, string2, stringArray, vector, aSTStatementList);
            ObjectPrototype objectPrototype = ObjectObject.createObject(evaluator);
            constructedFunctionObject.putHiddenProperty("prototype", objectPrototype);
            objectPrototype.putHiddenProperty("constructor", constructedFunctionObject);
        }
        catch (EcmaScriptException ecmaScriptException) {
            ecmaScriptException.printStackTrace();
            throw new ProgrammingError(ecmaScriptException.getMessage());
        }
        return constructedFunctionObject;
    }

    public ESValue getPropertyInScope(String string, ScopeChain scopeChain, int n) throws EcmaScriptException {
        if (string.equals("arguments")) {
            return this.currentArguments;
        }
        return super.getPropertyInScope(string, scopeChain, n);
    }

    public ESValue getProperty(String string, int n) throws EcmaScriptException {
        if (string.equals("arguments")) {
            return this.currentArguments;
        }
        return super.getProperty(string, n);
    }

    public boolean hasProperty(String string, int n) throws EcmaScriptException {
        if (string.equals("arguments")) {
            return true;
        }
        return super.hasProperty(string, n);
    }

    public void putProperty(String string, ESValue eSValue, int n) throws EcmaScriptException {
        if (!string.equals("arguments")) {
            super.putProperty(string, eSValue, n);
        }
    }
}

