/*
 * Decompiled with CFR 0.152.
 */
package jp.moja.socklet.util.security;

import java.util.AbstractCollection;
import java.util.ArrayList;
import jp.moja.socklet.util.security.ClientChecker;
import jp.wda.gpss.SocketProcessor;

public class LimitedConnectionChecker
extends ClientChecker {
    private int maxConnection;
    private ArrayList connections;
    private int trueOperation;
    private int falseOperation;

    public LimitedConnectionChecker(int max, int trueOperation, int falseOperation) {
        this.maxConnection = max;
        this.connections = new ArrayList();
        this.trueOperation = trueOperation;
        this.falseOperation = falseOperation;
    }

    public synchronized int enter(SocketProcessor client) {
        this.connections.add(client);
        if (this.connections.size() <= this.maxConnection) {
            return this.trueOperation;
        }
        return this.falseOperation;
    }

    public synchronized void exit(SocketProcessor client) {
        ((AbstractCollection)this.connections).remove(client);
    }
}

